/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.filter;

import com.pingidentity.common.util.LockScope;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public abstract class AbstractConfigIntegrityFilter
extends AbstractHttpFilter {
    private static final Log log = LogFactory.getLog(AbstractConfigIntegrityFilter.class);
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.admin.api.filter.AbstractConfigIntegrityFilter");

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!configStore.getBooleanValue("EnableConfigIntegrityFilter", true) || !this.requestMayModifyConfig(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Waiting to acquire config integrity lock");
        }
        try (LockScope scope = MgmtFactory.getMediator().newSharedConfigIntegrityLockScope();){
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected abstract boolean requestMayModifyConfig(HttpServletRequest var1);
}

