/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AdminNodeRole;
import com.pingidentity.admin.api.model.ConfigSyncStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="Describes the administrative console state information when the active/passive administrative console feature is enabled.")
public class AdminConsoleInfo {
    private AdminNodeRole consoleRole;
    private Date consoleRoleLastUpdateDate;
    private ConfigSyncStatus configSyncStatus;
    private Date configSyncTimestamp;

    public AdminConsoleInfo() {
    }

    public AdminConsoleInfo(AdminConsoleInfo other) {
        if (other != null) {
            this.consoleRole = other.consoleRole;
            this.consoleRoleLastUpdateDate = other.consoleRoleLastUpdateDate == null ? null : new Date(other.consoleRoleLastUpdateDate.getTime());
            this.configSyncStatus = other.configSyncStatus;
            this.configSyncTimestamp = other.configSyncTimestamp == null ? null : new Date(other.configSyncTimestamp.getTime());
        }
    }

    @ApiModelProperty(position=10, value="For console nodes, indicates whether the node is active or passive.")
    public AdminNodeRole getConsoleRole() {
        return this.consoleRole;
    }

    public void setConsoleRole(AdminNodeRole consoleRole) {
        this.consoleRole = consoleRole;
    }

    @ApiModelProperty(position=20, value="The timestamp of when the administrative console's role was last updated.")
    public Date getConsoleRoleLastUpdateDate() {
        return this.consoleRoleLastUpdateDate == null ? null : new Date(this.consoleRoleLastUpdateDate.getTime());
    }

    public void setConsoleRoleLastUpdateDate(Date consoleRoleLastUpdateDate) {
        this.consoleRoleLastUpdateDate = consoleRoleLastUpdateDate == null ? null : new Date(consoleRoleLastUpdateDate.getTime());
    }

    @ApiModelProperty(position=30, value="The status of the last configuration synchronization.")
    public ConfigSyncStatus getConfigSyncStatus() {
        return this.configSyncStatus;
    }

    public void setConfigSyncStatus(ConfigSyncStatus configSyncStatus) {
        this.configSyncStatus = configSyncStatus;
    }

    @ApiModelProperty(position=40, value="The timestamp of the last configuration synchronization.")
    public Date getConfigSyncTimestamp() {
        return this.configSyncTimestamp == null ? null : new Date(this.configSyncTimestamp.getTime());
    }

    public void setConfigSyncTimestamp(Date configSyncTimestamp) {
        this.configSyncTimestamp = configSyncTimestamp == null ? null : new Date(configSyncTimestamp.getTime());
    }
}

