/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AdministrativeRoleType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;

@ApiModel(description="A PingFederate administrator account.")
public class AdministrativeAccount {
    private String username;
    private String password;
    private String encryptedPassword;
    private String phoneNumber;
    private String emailAddress;
    private String department;
    private String description;
    private boolean auditor;
    private boolean active;
    private Set<AdministrativeRoleType> roles = new HashSet<AdministrativeRoleType>();

    @ApiModelProperty(position=10, value="Username for the Administrative Account.", required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ApiModelProperty(position=20, value="Password for the Account. This field is only applicable during a POST operation.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(position=25, value="For GET requests, this field contains the encrypted account password. For POST and PUT requests, if you wish to re-use the password from an API response to this endpoint, this field should be passed back unchanged.")
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @ApiModelProperty(position=30, value="Indicates whether the account is active or not.")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @ApiModelProperty(position=40, value="Description of the account.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(position=50, value="Indicates whether the account belongs to an Auditor. An Auditor has View-only permissions for all administrative functions. An Auditor cannot have any administrative roles.")
    public boolean isAuditor() {
        return this.auditor;
    }

    public void setAuditor(boolean auditor) {
        this.auditor = auditor;
    }

    @ApiModelProperty(position=60, value="Phone number associated with the account.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @ApiModelProperty(position=70, value="Email address associated with the account.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @ApiModelProperty(position=80, value="The Department name of account user.")
    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @ApiModelProperty(position=90, value="Roles available for an administrator. <br>USER_ADMINISTRATOR - Can create, deactivate or delete accounts and reset passwords. Additionally, install replacement license keys. <br> CRYPTO_ADMINISTRATOR - Can manage local keys and certificates. <br> ADMINISTRATOR - Can configure partner connections and most system settings (except the management of native accounts and the handling of local keys and certificates. <br>EXPRESSION_ADMINISTRATOR - Can add and update OGNL expressions. <br>DATA_COLLECTION_ADMINISTRATOR - Can run the Collect Support Data Utility. <br>")
    public Set<AdministrativeRoleType> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<AdministrativeRoleType> roles) {
        this.roles = roles;
    }
}

