/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.IssuanceCriteria;
import com.pingidentity.admin.api.model.SourceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@ApiModel(description="A list of mappings from attribute sources to attribute targets.")
public class AttributeMapping {
    private List<AttributeSource> attributeSources = new ArrayList<AttributeSource>();
    private Map<String, AttributeFulfillmentValue> attributeContractFulfillment = new HashMap<String, AttributeFulfillmentValue>();
    private IssuanceCriteria issuanceCriteria = new IssuanceCriteria();

    @ApiModelProperty(position=10, value="A list of configured data stores to look up attributes from.")
    public List<AttributeSource> getAttributeSources() {
        return this.attributeSources;
    }

    public void setAttributeSource(List<AttributeSource> attributeSources) {
        if (attributeSources == null) {
            this.attributeSources.clear();
        } else {
            this.attributeSources = attributeSources;
        }
    }

    @ApiModelProperty(position=20, value="A list of mappings from attribute names to their fulfillment values.", required=true)
    public Map<String, AttributeFulfillmentValue> getAttributeContractFulfillment() {
        return this.attributeContractFulfillment;
    }

    public void setAttributeContractFulfillment(Map<String, AttributeFulfillmentValue> attributeContractFulfillment) {
        if (attributeContractFulfillment == null) {
            this.attributeContractFulfillment.clear();
        } else {
            this.attributeContractFulfillment = attributeContractFulfillment;
        }
    }

    @ApiModelProperty(position=30, value="The issuance criteria that this transaction must meet before the corresponding attribute contract is fulfilled.")
    public IssuanceCriteria getIssuanceCriteria() {
        return this.issuanceCriteria;
    }

    public void setIssuanceCriteria(IssuanceCriteria issuanceCriteria) {
        if (issuanceCriteria != null) {
            this.issuanceCriteria = issuanceCriteria;
        }
    }

    @JsonIgnore
    public void ignoreId() {
        for (AttributeSource source : this.attributeSources) {
            if (source == null) continue;
            source.setId(null);
        }
        for (AttributeFulfillmentValue afv : this.attributeContractFulfillment.values()) {
            if (afv.getSource() == null) continue;
            afv.getSource().setId(null);
        }
        for (ConditionalIssuanceCriteriaEntry icEntry : this.issuanceCriteria.getConditionalCriteria()) {
            if (icEntry == null || icEntry.getSource() == null) continue;
            icEntry.getSource().setId(null);
        }
    }

    @JsonIgnore
    public void checkAndSetIdOnSingleAttrSource() {
        AttributeSource attributeSource;
        if (this.attributeSources != null && this.attributeSources.size() == 1 && StringUtils.isBlank((String)(attributeSource = this.attributeSources.get(0)).getId())) {
            attributeSource.setId("defaultAttrSourceId");
            for (AttributeFulfillmentValue afv : this.attributeContractFulfillment.values()) {
                if (afv.getSource() == null || !StringUtils.isBlank((String)afv.getSource().getId()) || afv.getSource().getType() == null || afv.getSource().getType() != SourceType.JDBC_DATA_STORE && afv.getSource().getType() != SourceType.LDAP_DATA_STORE && afv.getSource().getType() != SourceType.CUSTOM_DATA_STORE) continue;
                afv.getSource().setId(attributeSource.getId());
            }
            for (ConditionalIssuanceCriteriaEntry icEntry : this.issuanceCriteria.getConditionalCriteria()) {
                if (icEntry.getSource() == null || !StringUtils.isBlank((String)icEntry.getSource().getId()) || icEntry.getSource().getType() == null || icEntry.getSource().getType() != SourceType.JDBC_DATA_STORE && icEntry.getSource().getType() != SourceType.LDAP_DATA_STORE && icEntry.getSource().getType() != SourceType.CUSTOM_DATA_STORE) continue;
                icEntry.getSource().setId(attributeSource.getId());
            }
        }
    }

    @JsonIgnore
    public void checkAndSetDescriptionOnSingleAttrSource() {
        AttributeSource attributeSource;
        if (this.attributeSources != null && this.attributeSources.size() == 1 && StringUtils.isBlank((String)(attributeSource = this.attributeSources.get(0)).getDescription())) {
            attributeSource.setDescription(attributeSource.getType().toString());
        }
    }

    @JsonIgnore
    public boolean hasAttributeMapping() {
        return !this.attributeSources.isEmpty() || !this.attributeContractFulfillment.isEmpty() || this.issuanceCriteria.hasIssuanceCriteria();
    }
}

