/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.CustomAttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.JdbcAttributeSource;
import com.pingidentity.admin.api.model.LdapAttributeSource;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.resolver.AttributeSourceResolver;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=AttributeSource.class)
@JsonTypeIdResolver(value=AttributeSourceResolver.class)
@ApiModel(description="The configured settings to look up attributes from an associated data store.", subTypes={LdapAttributeSource.class, CustomAttributeSource.class, JdbcAttributeSource.class})
public class AttributeSource {
    private ResourceLink dataStoreRef;
    private String id;
    private String description;
    private Map<String, AttributeFulfillmentValue> attributeContractFulfillment;

    @JsonTypeId
    @ApiModelProperty(position=10, value="The data store type of this attribute source.", required=true)
    public DataStoreType getType() {
        return null;
    }

    @ApiModelProperty(position=20, value="Reference to the associated data store.", required=true)
    public ResourceLink getDataStoreRef() {
        return this.dataStoreRef;
    }

    public void setDataStoreRef(ResourceLink dataStoreRef) {
        this.dataStoreRef = dataStoreRef;
    }

    @ApiModelProperty(position=30, value="The ID that defines this attribute source. Only alphanumeric characters allowed.<br>Note: Required for OpenID Connect policy attribute sources, OAuth IdP adapter mappings, OAuth access token mappings and APC-to-SP Adapter Mappings. IdP Connections will ignore this property since it only allows one attribute source to be defined per mapping. IdP-to-SP Adapter Mappings can contain multiple attribute sources.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=40, value="The description of this attribute source. The description needs to be unique amongst the attribute sources for the mapping.<br>Note: Required for APC-to-SP Adapter Mappings", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(position=50, value="A list of mappings from attribute names to their fulfillment values. This field is only valid for the SP Connection's Browser SSO mappings", required=false)
    public Map<String, AttributeFulfillmentValue> getAttributeContractFulfillment() {
        return this.attributeContractFulfillment;
    }

    public void setAttributeContractFulfillment(Map<String, AttributeFulfillmentValue> attributeContractFulfillment) {
        this.attributeContractFulfillment = attributeContractFulfillment;
    }
}

