/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

@ApiModel(description="An authentication policy tree.")
public class AuthenticationPolicyTree {
    private AuthenticationPolicyTreeNode rootNode;
    private String id;
    private String name;
    private String description;
    private Boolean enabled;
    private ResourceLink authenticationApiApplicationRef;
    private Boolean handleFailuresLocally;

    @ApiModelProperty(position=10, value="The authentication policy ID. ID is unique.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The authentication policy name. Name is unique.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="A description for the authentication policy.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(position=31, value="Authentication API Application Id to be used in this policy branch. If the value is not specified, no Authentication API Application will be used.")
    public ResourceLink getAuthenticationApiApplicationRef() {
        return this.authenticationApiApplicationRef;
    }

    public void setAuthenticationApiApplicationRef(ResourceLink authenticationApiApplicationRef) {
        this.authenticationApiApplicationRef = authenticationApiApplicationRef;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(position=40, value="Whether or not this authentication policy tree is enabled. Default is true.")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(position=50, value="A node inside the authentication policy tree.", required=true)
    public AuthenticationPolicyTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(AuthenticationPolicyTreeNode node) {
        this.rootNode = node;
    }

    @ApiModelProperty(position=60, value="If a policy ends in failure keep the user local.")
    public Boolean getHandleFailuresLocally() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.handleFailuresLocally, (boolean)false);
    }

    public void setHandleFailuresLocally(Boolean handleFailuresLocally) {
        this.handleFailuresLocally = handleFailuresLocally;
    }

    @JsonIgnore
    public boolean isMatchingId(String otherPolicyId) {
        return StringUtils.equals((String)this.id, (String)otherPolicyId);
    }
}

