/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.ArtifactSettings;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.SloServiceEndpoint;
import com.pingidentity.admin.api.model.SsoServiceEndpoint;
import com.pingidentity.admin.api.model.UrlWhitelistEntry;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BaseBrowserSso {
    private Protocol protocol;
    private Set<Profile> enabledProfiles = new HashSet<Profile>();
    private Set<Binding> incomingBindings;
    private List<ProtocolMessageCustomization> messageCustomizations = null;
    private ArtifactSettings artifact;
    private List<SloServiceEndpoint> sloServiceEndpoints;
    private List<UrlWhitelistEntry> urlWhitelistEntries = null;
    private String defaultTargetUrl = null;
    private Boolean alwaysSignArtifactResponse = null;
    private String ssoApplicationEndpoint;

    @ApiModelProperty(position=10, value="The browser-based SSO protocol to use.", required=true)
    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @ApiModelProperty(position=20, value="The profiles that are enabled for browser-based SSO. SAML 2.0 supports all profiles whereas SAML 1.x IdP connections support both IdP and SP (non-standard) initiated SSO. This is required for SAMLx.x Connections. ")
    public Set<Profile> getEnabledProfiles() {
        return this.enabledProfiles;
    }

    public void setEnabledProfiles(Set<Profile> enabledProfiles) {
        this.enabledProfiles = enabledProfiles;
    }

    @ApiModelProperty(position=30, value="The SAML bindings that are enabled for browser-based SSO. This is required for SAML 2.0 connections when the enabled profiles contain the SP-initiated SSO profile or either SLO profile. For SAML 1.x based connections, it is not used for SP Connections and it is optional for IdP Connections.")
    public Set<Binding> getIncomingBindings() {
        return this.incomingBindings;
    }

    public void setIncomingBindings(Set<Binding> incomingBindings) {
        this.incomingBindings = incomingBindings;
    }

    @ApiModelProperty(position=40, value="The message customizations for browser-based SSO. Depending on server settings, connection type, and protocol this may or may not be supported.")
    public List<ProtocolMessageCustomization> getMessageCustomizations() {
        return this.messageCustomizations;
    }

    public void setMessageCustomizations(List<ProtocolMessageCustomization> messageCustomizations) {
        this.messageCustomizations = messageCustomizations;
    }

    @ApiModelProperty(position=50, value="For WS-Federation connections, a whitelist of additional allowed domains and paths used to validate wreply for SLO, if enabled.")
    public List<UrlWhitelistEntry> getUrlWhitelistEntries() {
        return this.urlWhitelistEntries;
    }

    public void setUrlWhitelistEntries(List<UrlWhitelistEntry> urlWhitelistEntries) {
        this.urlWhitelistEntries = urlWhitelistEntries;
    }

    @ApiModelProperty(position=60, value="The settings for an artifact binding.")
    public ArtifactSettings getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArtifactSettings artifact) {
        this.artifact = artifact;
    }

    @ApiModelProperty(position=70, value="A list of possible endpoints to send SLO requests and responses.")
    public List<SloServiceEndpoint> getSloServiceEndpoints() {
        return this.sloServiceEndpoints;
    }

    public void setSloServiceEndpoints(List<SloServiceEndpoint> sloServiceEndpoints) {
        this.sloServiceEndpoints = sloServiceEndpoints;
    }

    @ApiModelProperty(position=80, value="Default Target URL for SAML1.x connections. For SP connections, this default URL represents the destination on the SP where the user will be directed. For IdP connections, entering a URL in the Default Target URL field overrides the SP Default URL SSO setting.")
    public String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        this.defaultTargetUrl = defaultTargetUrl;
    }

    @ApiModelProperty(position=90, value="Specify to always sign the SAML ArtifactResponse.")
    public Boolean isAlwaysSignArtifactResponse() {
        return this.alwaysSignArtifactResponse;
    }

    public void setAlwaysSignArtifactResponse(Boolean alwaysSignArtifactResponse) {
        this.alwaysSignArtifactResponse = alwaysSignArtifactResponse;
    }

    @ApiModelProperty(position=100, value="Application endpoint that can be used to invoke single sign-on (SSO) for the connection. This is a read-only parameter.")
    public String getSsoApplicationEndpoint() {
        return this.ssoApplicationEndpoint;
    }

    public void setSsoApplicationEndpoint(String sSOApplicationEndpoint) {
        this.ssoApplicationEndpoint = sSOApplicationEndpoint;
    }

    @JsonIgnore
    public boolean isProfileSelected(Profile profile) {
        if (this.getEnabledProfiles() == null) {
            return false;
        }
        return this.getEnabledProfiles().contains((Object)profile);
    }

    @JsonIgnore
    public boolean isAnySloSelected() {
        return this.isProfileSelected(Profile.IDP_INITIATED_SLO) || this.isProfileSelected(Profile.SP_INITIATED_SLO);
    }

    @JsonIgnore
    public boolean isAnySsoSelected() {
        return this.isIdpSsoSelected() || this.isProfileSelected(Profile.SP_INITIATED_SSO);
    }

    @JsonIgnore
    public boolean isIdpSsoSelected() {
        return this.isProfileSelected(Profile.IDP_INITIATED_SSO) || Protocol.isSaml1x(this.getProtocol());
    }

    @JsonIgnore
    public boolean isArtifactSsoSloUsed() {
        return this.isBindingSsoUsed(Binding.ARTIFACT) || this.isBindingSloUsed(Binding.ARTIFACT);
    }

    @JsonIgnore
    public boolean isInboundArtifact() {
        if (this.getIncomingBindings() == null) {
            return false;
        }
        return this.getIncomingBindings().contains((Object)Binding.ARTIFACT);
    }

    @JsonIgnore
    public boolean isBindingSsoUsed(Binding binding) {
        if (this.getBaseSsoServiceEndpoints() == null) {
            return false;
        }
        for (SsoServiceEndpoint ssoServiceEndpoint : this.getBaseSsoServiceEndpoints()) {
            if (ssoServiceEndpoint == null || binding != ssoServiceEndpoint.getBinding()) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public boolean isBindingSloUsed(Binding binding) {
        if (this.getSloServiceEndpoints() == null) {
            return false;
        }
        for (SloServiceEndpoint serviceEndpoint : this.getSloServiceEndpoints()) {
            if (serviceEndpoint == null || binding != serviceEndpoint.getBinding()) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public abstract List<? extends SsoServiceEndpoint> getBaseSsoServiceEndpoints();
}

