/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Settings related to signing messages.")
public class BaseSigningSettings {
    private ResourceLink signingKeyPairRef;
    private String signingAlgorithm;
    private Boolean includeCertInSignature = Boolean.FALSE;
    private Boolean includeRawKeyInSignature = Boolean.FALSE;

    @ApiModelProperty(position=10, required=true, value="The ID of the key pair used to sign messages sent to this partner. The ID of the key pair is also known as the alias and can be found by viewing the corresponding certificate under 'Signing & Decryption Keys & Certificates' in the PingFederate admin console.")
    public ResourceLink getSigningKeyPairRef() {
        return this.signingKeyPairRef;
    }

    public void setSigningKeyPairRef(ResourceLink signingKeyPairRef) {
        this.signingKeyPairRef = signingKeyPairRef;
    }

    @ApiModelProperty(position=30, value="The algorithm used to sign messages sent to this partner. The default is SHA1withDSA for DSA certs, SHA256withRSA for RSA certs, and SHA256withECDSA for EC certs. For RSA certs, SHA1withRSA, SHA384withRSA, SHA512withRSA, SHA256withRSAandMGF1, SHA384withRSAandMGF1 and SHA512withRSAandMGF1 are also supported. For EC certs, SHA384withECDSA and SHA512withECDSA are also supported. If the connection is WS-Federation with JWT token type, then the possible values are RSA SHA256, RSA SHA384, RSA SHA512, RSASSA-PSS SHA256, RSASSA-PSS SHA384, RSASSA-PSS SHA512, ECDSA SHA256, ECDSA SHA384, ECDSA SHA512")
    public String getAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    @ApiModelProperty(position=40, value="Determines whether the signing certificate is included in the signature <KeyInfo> element.")
    public Boolean isIncludeCertInSignature() {
        return this.includeCertInSignature;
    }

    public void setIncludeCertInSignature(Boolean includeCertInSignature) {
        this.includeCertInSignature = includeCertInSignature;
    }

    @ApiModelProperty(position=50, value="Determines whether the <KeyValue> element with the raw public key is included in the signature <KeyInfo> element.")
    public Boolean isIncludeRawKeyInSignature() {
        return this.includeRawKeyInSignature;
    }

    public void setIncludeRawKeyInSignature(Boolean includeRawKeyInSignature) {
        this.includeRawKeyInSignature = includeRawKeyInSignature;
    }
}

