/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ChannelSource;
import com.pingidentity.admin.api.model.SaasAttributeMapping;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="A channel is a combination of a source data store and a provisioning target. It include settings of a source data store, managing provisioning threads and mapping of attributes.")
public class Channel {
    private boolean active;
    private ChannelSource channelSource;
    private List<SaasAttributeMapping> attributeMapping;
    private String name;
    private int maxThreads = 1;
    private int timeout = 60;

    @ApiModelProperty(position=10, value="Indicates whether the channel is the active channel for this connection.", required=true)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @ApiModelProperty(position=20, value="The LDAP settings that apply to the source user-data store.", required=true)
    public ChannelSource getChannelSource() {
        return this.channelSource;
    }

    public void setChannelSource(ChannelSource channelSource) {
        this.channelSource = channelSource;
    }

    @ApiModelProperty(position=30, value="The mapping of attributes from the local data store into Fields specified by the service provider.", required=true)
    public List<SaasAttributeMapping> getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(List<SaasAttributeMapping> attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @ApiModelProperty(position=40, value="The name of the channel.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=50, value="The number of processing threads. The default value is 1.", required=true)
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @ApiModelProperty(position=60, value="Timeout, in seconds, for individual user and group provisioning operations on the target service provider. The default value is 60.", required=true)
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

