/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AdminConsoleInfo;
import com.pingidentity.admin.api.model.DeploymentMode;
import com.pingidentity.admin.api.model.ReplicationStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="Describes a node in a clustered deployment of PingFederate.")
public class ClusterNode {
    private String address;
    private DeploymentMode mode;
    private int index;
    private String nodeGroup;
    private String version;
    private String nodeTags;
    private Date configurationTimestamp;
    private ReplicationStatus replicationStatus;
    private AdminConsoleInfo adminConsoleInfo;

    @ApiModelProperty(position=10, value="The IP address and port this node is running on.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ApiModelProperty(position=20, value="Index of the node within the cluster, or -1 if an index is not assigned.")
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @ApiModelProperty(position=30, value="The deployment mode of this node, from a clustering standpoint. CLUSTERED_DUAL is not supported.")
    public DeploymentMode getMode() {
        return this.mode;
    }

    public void setMode(DeploymentMode mode) {
        this.mode = mode;
    }

    @ApiModelProperty(position=40, value="The node group for this node. This field is only populated if adaptive clustering is enabled.")
    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    @ApiModelProperty(position=50, value="The PingFederate version this node is running on.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(position=60, value="The node tags for this node. This field is only populated for engine nodes.")
    public String getNodeTags() {
        return this.nodeTags;
    }

    public void setNodeTags(String nodeTags) {
        this.nodeTags = nodeTags;
    }

    @ApiModelProperty(position=70, value="The time stamp of the configuration data retrieved by this node.")
    public Date getConfigurationTimestamp() {
        return this.configurationTimestamp == null ? null : new Date(this.configurationTimestamp.getTime());
    }

    public void setConfigurationTimestamp(Date configurationTimestamp) {
        this.configurationTimestamp = configurationTimestamp == null ? null : new Date(configurationTimestamp.getTime());
    }

    @ApiModelProperty(position=80, value="The replication status of the node.")
    public ReplicationStatus getReplicationStatus() {
        return this.replicationStatus;
    }

    public void setReplicationStatus(ReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
    }

    @ApiModelProperty(position=90, value="The administrative console information when the active/passive administrative console feature is enabled.")
    public AdminConsoleInfo getAdminConsoleInfo() {
        return this.adminConsoleInfo == null ? null : new AdminConsoleInfo(this.adminConsoleInfo);
    }

    public void setAdminConsoleInfo(AdminConsoleInfo adminConsoleInfo) {
        this.adminConsoleInfo = adminConsoleInfo == null ? null : new AdminConsoleInfo(adminConsoleInfo);
    }
}

