/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.pingidentity.admin.api.model.AdditionalAllowedEntitiesConfiguration;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.ConnectionMetadataUrl;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.ContactInfo;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ItemReplicationStatus;
import org.sourceid.saml20.domain.LoggingMode;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=IdpConnection.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=IdpConnection.class, name="IDP"), @JsonSubTypes.Type(value=SpConnection.class, name="SP")})
@ApiModel(description="Settings shared by SP-side and IdP-side connections.", subTypes={IdpConnection.class, SpConnection.class})
@JsonTypeIdResolver(value=ConnectionTypeIdResolver.class)
public abstract class Connection {
    private String id;
    private String name;
    private String entityId;
    private boolean active;
    private ContactInfo contactInfo;
    private String baseUrl;
    private LoggingMode loggingMode = LoggingMode.STANDARD;
    private String defaultVirtualEntityId;
    private List<String> virtualEntityIds;
    private ConnectionMetadataUrl metadataReloadSettings;
    private String licenseConnectionGroup;
    private ConnectionCredentials credentials;
    private AdditionalAllowedEntitiesConfiguration additionalAllowedEntitiesConfiguration;
    private Map<String, ParameterValues> extendedProperties = new HashMap<String, ParameterValues>();
    private Date modificationDate;
    private Date creationDate;
    private ItemReplicationStatus replicationStatus;

    @ApiModelProperty(position=5, value="The type of this connection. Default is 'IDP'.")
    @JsonTypeId
    public abstract ConnectionType getType();

    @ApiModelProperty(position=10, value="The persistent, unique ID for the connection. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The partner's entity ID (connection ID) or issuer value (for OIDC Connections).", required=true)
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @ApiModelProperty(position=30, value="The connection name.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=35, value="The time at which the connection was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getModificationDate() {
        if (this.modificationDate == null) {
            return null;
        }
        return new Date(this.modificationDate.getTime());
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate == null ? null : new Date(modificationDate.getTime());
    }

    @ApiModelProperty(position=36, value="The time at which the connection was created. This property is read only and is ignored on PUT and POST requests.")
    public Date getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return new Date(this.creationDate.getTime());
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate == null ? null : new Date(creationDate.getTime());
    }

    @ApiModelProperty(position=40, value="Specifies whether the connection is active and ready to process incoming requests. The default value is false.")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @ApiModelProperty(position=50, value="The fully-qualified hostname and port on which your partner's federation deployment runs.")
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @ApiModelProperty(position=60, value="The default alternate entity ID that identifies the local server to this partner. It is required when virtualEntityIds is not empty and must be included in that list.")
    public String getDefaultVirtualEntityId() {
        return this.defaultVirtualEntityId;
    }

    public void setDefaultVirtualEntityId(String defaultVirtualEntityId) {
        this.defaultVirtualEntityId = defaultVirtualEntityId;
    }

    @ApiModelProperty(position=70, value="List of alternate entity IDs that identifies the local server to this partner.")
    public List<String> getVirtualEntityIds() {
        return this.virtualEntityIds;
    }

    public void setVirtualEntityIds(List<String> virtualEntityIds) {
        this.virtualEntityIds = virtualEntityIds;
    }

    @ApiModelProperty(position=75, value="Connection metadata automatic reload settings.")
    public ConnectionMetadataUrl getMetadataReloadSettings() {
        return this.metadataReloadSettings;
    }

    public void setMetadataReloadSettings(ConnectionMetadataUrl metadataUrl) {
        this.metadataReloadSettings = metadataUrl;
    }

    @ApiModelProperty(position=80, value="The certificates and settings for encryption, signing, and signature verification. It is required for  SAMLx.x and WS-Fed Connections.")
    public ConnectionCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(ConnectionCredentials credentials) {
        this.credentials = credentials;
    }

    @ApiModelProperty(position=90, value="The contact information for this partner.")
    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    @ApiModelProperty(position=100, value="The license connection group. If your PingFederate license is based on connection groups, each connection must be assigned to a group before it can be used.")
    public String getLicenseConnectionGroup() {
        return this.licenseConnectionGroup;
    }

    public void setLicenseConnectionGroup(String licenseConnectionGroup) {
        this.licenseConnectionGroup = licenseConnectionGroup;
    }

    @ApiModelProperty(position=110, value="The level of transaction logging applicable for this connection. Default is STANDARD.")
    public LoggingMode getLoggingMode() {
        return this.loggingMode;
    }

    public void setLoggingMode(LoggingMode loggingMode) {
        this.loggingMode = loggingMode;
    }

    @ApiModelProperty(position=120, value="Additional allowed entities or issuers configuration. Currently only used in OIDC IdP (RP) connection.")
    public AdditionalAllowedEntitiesConfiguration getAdditionalAllowedEntitiesConfiguration() {
        return this.additionalAllowedEntitiesConfiguration;
    }

    public void setAdditionalAllowedEntitiesConfiguration(AdditionalAllowedEntitiesConfiguration additionalAllowedEntitiesConfiguration) {
        this.additionalAllowedEntitiesConfiguration = additionalAllowedEntitiesConfiguration;
    }

    @ApiModelProperty(position=130, value="Extended Properties allows to store additional information for IdP/SP Connections. The names of these extended properties should be defined in /extendedProperties.")
    public Map<String, ParameterValues> getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map<String, ParameterValues> extendedParameters) {
        this.extendedProperties = extendedParameters;
    }

    @ApiModelProperty(position=140, value="This status indicates whether the connection has been replicated to the cluster. This property only applies when automatic replication of connections is enabled. It is read only and is ignored on PUT and POST requests.")
    public ItemReplicationStatus getReplicationStatus() {
        return this.replicationStatus;
    }

    public void setReplicationStatus(ItemReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
    }

    @JsonIgnore
    public boolean isAdditionalAllowedEntitiesConfigured() {
        return this.additionalAllowedEntitiesConfiguration != null;
    }

    @JsonIgnore
    public abstract BaseBrowserSso getBrowserSso();

    @JsonIgnore
    public boolean isBrowserSsoSaml2() {
        return this.getBrowserSso() != null && this.getBrowserSso().getProtocol() == Protocol.SAML20;
    }

    public static class ConnectionTypingException
    extends RuntimeException {
        ConnectionTypingException(String message) {
            super(message);
        }
    }

    protected static class ConnectionTypeIdResolver
    extends TypeIdResolverBase {
        private JavaType baseType;

        protected ConnectionTypeIdResolver() {
        }

        private String getBaseTypeId() {
            if (this.baseType.getRawClass().isAssignableFrom(IdpConnection.class)) {
                return ConnectionType.IDP.toString();
            }
            if (this.baseType.getRawClass().isAssignableFrom(SpConnection.class)) {
                return ConnectionType.SP.toString();
            }
            return "";
        }

        private Class<?> getSubClassFromTypeId(String id) {
            if (id.equals(ConnectionType.IDP.toString())) {
                return IdpConnection.class;
            }
            if (id.equals(ConnectionType.SP.toString())) {
                return SpConnection.class;
            }
            return IdpConnection.class;
        }

        public void init(JavaType baseType) {
            this.baseType = baseType;
        }

        public String idFromValue(Object o) {
            return this.idFromValueAndType(o, o.getClass());
        }

        public String idFromValueAndType(Object o, Class<?> aClass) {
            if (this.baseType.getRawClass().isAssignableFrom(aClass)) {
                return this.getBaseTypeId();
            }
            return null;
        }

        public JavaType typeFromId(DatabindContext context, String id) {
            if (this.baseType.getRawClass().equals(Connection.class)) {
                return context.constructSpecializedType(this.baseType, this.getSubClassFromTypeId(id));
            }
            if (id.equals(this.getBaseTypeId()) || StringUtils.isBlank((String)id)) {
                return context.constructSpecializedType(this.baseType, this.getSubClassFromTypeId(this.getBaseTypeId()));
            }
            if (id.equals(ConnectionType.SP.toString()) || id.equals(ConnectionType.IDP.toString())) {
                throw new ConnectionTypingException(String.format("Expected '%s' connection type, but encountered '%s' connection type", this.getBaseTypeId(), id));
            }
            throw new ConnectionTypingException(String.format("The value '%s' is not a recognized constant for the 'ConnectionType' enum.", id));
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.NAME;
        }
    }
}

