/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.SourceType;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.saml20.domain.DataSource;

public enum DataStoreRepositoryType {
    LDAP(SourceType.LDAP_DATA_STORE, DataSource.DSType.LDAP.getName()),
    JDBC(SourceType.JDBC_DATA_STORE, DataSource.DSType.JDBC.getName());

    private SourceType id;
    private static final Map<SourceType, DataStoreRepositoryType> ID_TO_TYPE_MAP;
    private String description;

    private DataStoreRepositoryType(SourceType id, String description) {
        this.id = id;
        this.description = description;
    }

    public SourceType getId() {
        return this.id;
    }

    public static DataStoreRepositoryType getType(SourceType id) {
        return ID_TO_TYPE_MAP.get((Object)id);
    }

    public String getDescription() {
        return this.description;
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<SourceType, DataStoreRepositoryType>();
        for (DataStoreRepositoryType dataStoreRepositoryType : DataStoreRepositoryType.values()) {
            ID_TO_TYPE_MAP.put(dataStoreRepositoryType.getId(), dataStoreRepositoryType);
        }
    }
}

