/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.SourceType;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.saml20.domain.DataSource;

public enum DataStoreType {
    LDAP(SourceType.LDAP_DATA_STORE, DataSource.DSType.LDAP.getName()),
    PING_ONE_LDAP_GATEWAY(SourceType.PING_ONE_LDAP_GATEWAY_DATA_STORE, DataSource.DSType.LDAP.getName()),
    JDBC(SourceType.JDBC_DATA_STORE, DataSource.DSType.JDBC.getName()),
    CUSTOM(SourceType.CUSTOM_DATA_STORE, DataSource.DSType.Other.getName());

    private SourceType id;
    private static final Map<SourceType, DataStoreType> ID_TO_TYPE_MAP;
    private String description;

    private DataStoreType(SourceType id, String description) {
        this.id = id;
        this.description = description;
    }

    public SourceType getId() {
        return this.id;
    }

    public static DataStoreType getType(SourceType id) {
        return ID_TO_TYPE_MAP.get((Object)id);
    }

    public String getDescription() {
        return this.description;
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<SourceType, DataStoreType>();
        for (DataStoreType dataStoreType : DataStoreType.values()) {
            ID_TO_TYPE_MAP.put(dataStoreType.getId(), dataStoreType);
        }
    }
}

