/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description="Defines what to encrypt in the browser-based SSO profile.")
public class EncryptionPolicy {
    private boolean encryptAssertion;
    private boolean encryptSloSubjectNameId;
    private boolean sloSubjectNameIDEncrypted;
    private List<String> encryptedAttributes = new ArrayList<String>();

    @ApiModelProperty(position=10, value="Whether the outgoing SAML assertion will be encrypted.")
    public boolean isEncryptAssertion() {
        return this.encryptAssertion;
    }

    public void setEncryptAssertion(boolean encryptAssertion) {
        this.encryptAssertion = encryptAssertion;
    }

    @ApiModelProperty(position=20, value="The list of outgoing SAML assertion attributes that will be encrypted. The 'encryptAssertion' property takes precedence over this.")
    public List<String> getEncryptedAttributes() {
        return this.encryptedAttributes;
    }

    public void setEncryptAttributeList(List<String> encryptAttribList) {
        if (encryptAttribList != null) {
            this.encryptedAttributes = encryptAttribList;
        } else {
            this.encryptedAttributes.clear();
        }
    }

    @ApiModelProperty(position=30, value="Encrypt the name-identifier attribute in outbound SLO messages.  This can be set if the name id is encrypted.")
    public boolean isEncryptSloSubjectNameId() {
        return this.encryptSloSubjectNameId;
    }

    public void setEncryptSloSubjectNameId(boolean sloEncryptSubjectNameID) {
        this.encryptSloSubjectNameId = sloEncryptSubjectNameID;
    }

    @ApiModelProperty(position=40, value="Allow the encryption of the name-identifier attribute for inbound SLO messages. This can be set if SP initiated SLO is enabled.")
    public boolean isSloSubjectNameIDEncrypted() {
        return this.sloSubjectNameIDEncrypted;
    }

    public void setSloSubjectNameIDEncrypted(boolean sloSubjectNameIDEncrypted) {
        this.sloSubjectNameIDEncrypted = sloSubjectNameIDEncrypted;
    }
}

