/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.SessionTimeoutPolicy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.sourceid.saml20.domain.SessionTimeUnit;

@ApiModel(description="The global policy for authentication sessions.")
public class GlobalAuthenticationSessionPolicy
implements SessionTimeoutPolicy {
    private Boolean enableSessions;
    private Boolean persistentSessions;
    private Boolean hashUniqueUserKeyAttribute;
    private Integer idleTimeoutMins;
    private SessionTimeUnit idleTimeoutDisplayUnit;
    private Integer maxTimeoutMins;
    private SessionTimeUnit maxTimeoutDisplayUnit;

    public GlobalAuthenticationSessionPolicy() {
    }

    public GlobalAuthenticationSessionPolicy(Boolean enableSessions, Boolean persistentSessions, Integer idleTimeoutMins, SessionTimeUnit idleTimeoutDisplayUnit, Integer maxTimeoutMins, SessionTimeUnit maxTimeoutDisplayUnit, Boolean trackAdapterSessionsForLogout) {
        this.enableSessions = enableSessions;
        this.persistentSessions = persistentSessions;
        this.idleTimeoutMins = idleTimeoutMins;
        this.idleTimeoutDisplayUnit = idleTimeoutDisplayUnit;
        this.maxTimeoutMins = maxTimeoutMins;
        this.maxTimeoutDisplayUnit = maxTimeoutDisplayUnit;
    }

    @ApiModelProperty(position=10, value="Determines whether authentication sessions are enabled globally.", required=true)
    public Boolean isEnableSessions() {
        return this.enableSessions;
    }

    public void setEnableSessions(Boolean enableCaching) {
        this.enableSessions = enableCaching;
    }

    @ApiModelProperty(position=12, value="Determines whether authentication sessions are persistent by default. Persistent sessions are linked to a persistent cookie and stored in a data store. This field is ignored if enableSessions is false.")
    public Boolean isPersistentSessions() {
        return this.persistentSessions;
    }

    public void setPersistentSessions(Boolean persistentSessions) {
        this.persistentSessions = persistentSessions;
    }

    @ApiModelProperty(position=14, value="Determines whether to hash the value of the unique user key attribute.")
    public Boolean isHashUniqueUserKeyAttribute() {
        return this.hashUniqueUserKeyAttribute;
    }

    public void setHashUniqueUserKeyAttribute(Boolean hashUniqueUserKeyAttribute) {
        this.hashUniqueUserKeyAttribute = hashUniqueUserKeyAttribute;
    }

    @Override
    @ApiModelProperty(position=20, value="The idle timeout period, in minutes. If set to -1, the idle timeout will be set to the maximum timeout. The default is 60.")
    public Integer getIdleTimeoutMins() {
        return this.idleTimeoutMins;
    }

    @Override
    public void setIdleTimeoutMins(Integer idleTimeoutMins) {
        this.idleTimeoutMins = idleTimeoutMins;
    }

    @ApiModelProperty(position=25, value="The display unit for the idle timeout period in the PingFederate administrative console. When the display unit is HOURS or DAYS, the timeout value in minutes must correspond to a whole number value for the specified unit.")
    public SessionTimeUnit getIdleTimeoutDisplayUnit() {
        return this.idleTimeoutDisplayUnit;
    }

    public void setIdleTimeoutDisplayUnit(SessionTimeUnit idleTimeoutDisplayUnit) {
        this.idleTimeoutDisplayUnit = idleTimeoutDisplayUnit;
    }

    @Override
    @ApiModelProperty(position=30, value="The maximum timeout period, in minutes. If set to -1, sessions do not expire. The default is 480.")
    public Integer getMaxTimeoutMins() {
        return this.maxTimeoutMins;
    }

    @Override
    public void setMaxTimeoutMins(Integer maxTimeoutMins) {
        this.maxTimeoutMins = maxTimeoutMins;
    }

    @ApiModelProperty(position=35, value="The display unit for the maximum timeout period in the PingFederate administrative console. When the display unit is HOURS or DAYS, the timeout value in minutes must correspond to a whole number value for the specified unit.")
    public SessionTimeUnit getMaxTimeoutDisplayUnit() {
        return this.maxTimeoutDisplayUnit;
    }

    public void setMaxTimeoutDisplayUnit(SessionTimeUnit maxTimeoutDisplayUnit) {
        this.maxTimeoutDisplayUnit = maxTimeoutDisplayUnit;
    }
}

