/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Incoming Proxy Settings.")
public class IncomingProxySettings {
    private String forwardedIpAddressHeaderName;
    private ForwardedHeaderIndex forwardedIpAddressHeaderIndex = ForwardedHeaderIndex.LAST;
    private String forwardedHostHeaderName;
    private ForwardedHeaderIndex forwardedHostHeaderIndex = ForwardedHeaderIndex.LAST;
    private Boolean enableClientCertHeaderAuth;
    private ClientCertHeaderEncodingFormat clientCertHeaderEncodingFormat = ClientCertHeaderEncodingFormat.APACHE_MOD_SSL;
    private String clientCertSSLHeaderName;
    private String clientCertChainSSLHeaderName;
    private boolean proxyTerminatesHttpsConns;

    @ApiModelProperty(position=10, value="Globally specify the header name (for example, X-Forwarded-For) where PingFederate should attempt to retrieve the client IP address in all HTTP requests.")
    public String getForwardedIpAddressHeaderName() {
        return this.forwardedIpAddressHeaderName;
    }

    public void setForwardedIpAddressHeaderName(String forwardedIpAddressHeaderName) {
        this.forwardedIpAddressHeaderName = forwardedIpAddressHeaderName;
    }

    @ApiModelProperty(position=20, value="PingFederate combines multiple comma-separated header values into the same order that they are received. Define which IP address you want to use. Default is to use the last address.")
    public ForwardedHeaderIndex getForwardedIpAddressHeaderIndex() {
        return this.forwardedIpAddressHeaderIndex;
    }

    public void setForwardedIpAddressHeaderIndex(ForwardedHeaderIndex forwardedIpAddressHeaderIndex) {
        this.forwardedIpAddressHeaderIndex = forwardedIpAddressHeaderIndex;
    }

    @ApiModelProperty(position=30, value="Globally specify the header name (for example, X-Forwarded-Host) where PingFederate should attempt to retrieve the hostname and port in all HTTP requests.")
    public String getForwardedHostHeaderName() {
        return this.forwardedHostHeaderName;
    }

    public void setForwardedHostHeaderName(String forwardedHostHeaderName) {
        this.forwardedHostHeaderName = forwardedHostHeaderName;
    }

    @ApiModelProperty(position=40, value="PingFederate combines multiple comma-separated header values into the same order that they are received. Define which hostname you want to use. Default is to use the last hostname.")
    public ForwardedHeaderIndex getForwardedHostHeaderIndex() {
        return this.forwardedHostHeaderIndex;
    }

    public void setForwardedHostHeaderIndex(ForwardedHeaderIndex forwardedHostHeaderIndex) {
        this.forwardedHostHeaderIndex = forwardedHostHeaderIndex;
    }

    @ApiModelProperty(position=48, value="Enable client certificate header authentication.")
    public Boolean getEnableClientCertHeaderAuth() {
        return this.enableClientCertHeaderAuth;
    }

    public void setEnableClientCertHeaderAuth(Boolean enableClientCertHeaderAuth) {
        this.enableClientCertHeaderAuth = enableClientCertHeaderAuth;
    }

    @ApiModelProperty(position=49, value="Specify the encoding format of the client certificate header. The default value is APACHE_MOD_SSL.")
    public ClientCertHeaderEncodingFormat getClientCertHeaderEncodingFormat() {
        return this.clientCertHeaderEncodingFormat;
    }

    public void setClientCertHeaderEncodingFormat(ClientCertHeaderEncodingFormat clientCertHeaderEncodingFormat) {
        this.clientCertHeaderEncodingFormat = clientCertHeaderEncodingFormat;
    }

    @ApiModelProperty(position=50, value="While the proxy server is configured to pass client certificates as HTTP request headers, specify the header name here.")
    public String getClientCertSSLHeaderName() {
        return this.clientCertSSLHeaderName;
    }

    public void setClientCertSSLHeaderName(String clientCertSSLHeaderName) {
        this.clientCertSSLHeaderName = clientCertSSLHeaderName;
    }

    @ApiModelProperty(position=60, value="While the proxy server is configured to pass client certificates as HTTP request headers, specify the chain header name here.")
    public String getClientCertChainSSLHeaderName() {
        return this.clientCertChainSSLHeaderName;
    }

    public void setClientCertChainSSLHeaderName(String clientCertChainSSLHeaderName) {
        this.clientCertChainSSLHeaderName = clientCertChainSSLHeaderName;
    }

    @ApiModelProperty(position=70, value="Allows you to globally specify that connections to the reverse proxy are made over HTTPS even when HTTP is used between the reverse proxy and PingFederate.")
    public boolean isProxyTerminatesHttpsConns() {
        return this.proxyTerminatesHttpsConns;
    }

    public void setProxyTerminatesHttpsConns(boolean proxyTerminatesHttpsConns) {
        this.proxyTerminatesHttpsConns = proxyTerminatesHttpsConns;
    }

    public static enum ClientCertHeaderEncodingFormat {
        APACHE_MOD_SSL,
        NGINX;

    }

    public static enum ForwardedHeaderIndex {
        FIRST,
        LAST;

    }
}

