/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.DataStore;
import com.pingidentity.admin.api.model.DataStoreType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;

@ApiModel(description="A JDBC data store.", parent=DataStore.class)
public class JdbcDataStore
implements DataStore {
    private String id;
    private boolean maskAttributeValues;
    private String connectionUrl;
    private String driverClass;
    private String userName;
    private String password;
    private String encryptedPassword;
    private String validateConnectionSql = null;
    private boolean allowMultiValueAttributes = true;
    private String name;
    private List<JdbcTagConfig> connectionUrlTags;
    private Date lastModified;
    private Integer minPoolSize = 10;
    private Integer maxPoolSize = 100;
    private Integer blockingTimeout = 5000;
    private Integer idleTimeout = 5;

    @Override
    @ApiModelProperty(position=10, value="The data store type.", required=true)
    public DataStoreType getType() {
        return DataStoreType.JDBC;
    }

    @Override
    @ApiModelProperty(position=20, value="The persistent, unique ID for the data store. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @ApiModelProperty(position=30, value="Whether attribute values should be masked in the log.")
    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    @Override
    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    @ApiModelProperty(position=40, value="The set of connection URLs and associated tags for this JDBC data store. This is required if 'connectionUrl' is not provided.")
    public List<JdbcTagConfig> getConnectionUrlTags() {
        return this.connectionUrlTags;
    }

    public void setConnectionUrlTags(List<JdbcTagConfig> connectionUrlTags) {
        this.connectionUrlTags = connectionUrlTags;
    }

    @ApiModelProperty(position=42, value="The default location of the JDBC database. This field is required if no mapping for JDBC database location and tags is specified.")
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    @ApiModelProperty(position=45, value="The data store name with a unique value across all data sources. Omitting this attribute will set the value to a combination of the connection url and the username.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=50, value="The name of the driver class used to communicate with the source database.", required=true)
    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    @ApiModelProperty(position=60, value="The name that identifies the user when connecting to the database.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @ApiModelProperty(position=70, value="The password needed to access the database. GETs will not return this attribute. To update this field, specify the new value in this attribute.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(position=80, value="The encrypted password needed to access the database. If you do not want to update the stored value, this attribute should be passed back unchanged. Secret Reference may be provided in this field with format 'OBF:MGR:{secretManagerId}:{secretId}'.")
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @ApiModelProperty(position=90, value="A simple SQL statement used by PingFederate at runtime to verify that the database connection is still active and to reconnect if needed.")
    public String getValidateConnectionSql() {
        return this.validateConnectionSql;
    }

    public void setValidateConnectionSql(String validateConnectionSql) {
        this.validateConnectionSql = validateConnectionSql;
    }

    @ApiModelProperty(position=100, value="Indicates that this data store can select more than one record from a column and return the results as a multi-value attribute.")
    public boolean isAllowMultiValueAttributes() {
        return this.allowMultiValueAttributes;
    }

    public void setAllowMultiValueAttributes(boolean allowMultiValueAttributes) {
        this.allowMultiValueAttributes = allowMultiValueAttributes;
    }

    @ApiModelProperty(position=110, value="The smallest number of database connections in the connection pool for the given data store. Omitting this attribute will set the value to the connection pool default. The default value is 10.")
    public Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(Integer minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    @ApiModelProperty(position=120, value="The largest number of database connections in the connection pool for the given data store. Omitting this attribute will set the value to the connection pool default. The default value is 100.")
    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @ApiModelProperty(position=130, value="The amount of time in milliseconds a request waits to get a connection from the connection pool before it fails. Omitting this attribute will set the value to the connection pool default. The default value is 5000 milliseconds.")
    public Integer getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setBlockingTimeout(Integer blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    @ApiModelProperty(position=140, value="The length of time in minutes the connection can be idle in the pool before it is closed. Omitting this attribute will set the value to the connection pool default. The default value is 5 minutes.")
    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Override
    @ApiModelProperty(position=150, value="The time at which the datastore instance was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

