/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="The configured settings used to look up attributes from a JDBC stored-procedure data store.", parent=AttributeSource.class)
public class JdbcStoredProcedureAttributeSource
extends AttributeSource {
    private String schema;
    private String storedProcedure;
    private List<String> parameterNames;

    @Override
    @ApiModelProperty(position=10, value="The data store type of this attribute source.", required=true)
    public DataStoreType getType() {
        return DataStoreType.JDBC;
    }

    @ApiModelProperty(value="Lists the stored-procedure structure that stores information within a database.", position=30)
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @ApiModelProperty(value="The name of the database stored-procedure. The name is used to construct the SQL query to retrieve data from the data store.", position=40, required=true)
    public String getStoredProcedure() {
        return this.storedProcedure;
    }

    public void setStoredProcedure(String storedProcedure) {
        this.storedProcedure = storedProcedure;
    }

    @ApiModelProperty(value="A list of parameters used to construct the SQL query to retrieve data from the specified stored-procedure in the datastore.", position=50)
    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }
}

