/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public enum LdapType {
    ACTIVE_DIRECTORY(LdapInfo.LdapType.ActiveDirectory),
    ORACLE_DIRECTORY_SERVER(LdapInfo.LdapType.SunDirectoryServer),
    ORACLE_UNIFIED_DIRECTORY(LdapInfo.LdapType.OracleUnifiedDirectory),
    UNBOUNDID_DS(LdapInfo.LdapType.UnboundID),
    PING_DIRECTORY(LdapInfo.LdapType.PingDirectory),
    PING_DS(LdapInfo.LdapType.PingDS),
    GENERIC(LdapInfo.LdapType.Generic);

    private final LdapInfo.LdapType ldapInfoEquivalent;

    private LdapType(LdapInfo.LdapType info) {
        this.ldapInfoEquivalent = info;
    }

    private String getLdapInfoString() {
        return this.ldapInfoEquivalent.getDescription();
    }

    public LdapInfo.LdapType getLdapInfoEquivalent() {
        return this.ldapInfoEquivalent;
    }

    public static LdapType fromPingOneVendor(String vendor) {
        if ("Oracle Directory Server Enterprise Edition".equals(vendor)) {
            return ORACLE_DIRECTORY_SERVER;
        }
        if ("OpenDJ Directory Server".equals(vendor)) {
            return PING_DS;
        }
        LdapType apiLdapType = GENERIC;
        for (LdapType currType : LdapType.values()) {
            if (!currType.getLdapInfoString().equalsIgnoreCase(vendor)) continue;
            apiLdapType = currType;
        }
        return apiLdapType;
    }
}

