/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ConnectionGroupLicenseView;
import com.pingidentity.admin.api.model.LicenseFeatureView;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="PingFederate License details.")
public class LicenseView {
    private String name;
    private String id;
    private Integer maxConnections;
    private Integer usedConnections;
    private String tier;
    private Date issueDate;
    private Date expirationDate;
    private String enforcementType;
    private String version;
    private String product;
    private String organization;
    private Long gracePeriod;
    private Integer nodeLimit;
    private List<ConnectionGroupLicenseView> licenseGroups;
    private boolean isOauthEnabled;
    private boolean isWsTrustEnabled;
    private boolean isProvisioningEnabled;
    private boolean isBridgeMode;
    private List<LicenseFeatureView> features;

    @ApiModelProperty(position=5, value="Name of the person the license was issued to.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=10, value="Unique identifier of a license.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=15, value="Maximum number of connections that can be created under this license (if applicable).")
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @ApiModelProperty(position=16, value="Number of used connections under this license.")
    public Integer getUsedConnections() {
        return this.usedConnections;
    }

    public void setUsedConnections(Integer usedConnections) {
        this.usedConnections = usedConnections;
    }

    @ApiModelProperty(position=20, value="The tier value from the license file. The possible values are FREE, PERPETUAL or SUBSCRIPTION.")
    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    @ApiModelProperty(position=25, value="The issue date value from the license file.")
    public Date getIssueDate() {
        return this.issueDate == null ? null : new Date(this.issueDate.getTime());
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate == null ? null : new Date(issueDate.getTime());
    }

    @ApiModelProperty(position=30, value="The expiration date value from the license file (if applicable).")
    public Date getExpirationDate() {
        return this.expirationDate == null ? null : new Date(this.expirationDate.getTime());
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate == null ? null : new Date(expirationDate.getTime());
    }

    @ApiModelProperty(position=35, value="The enforcement type is a 3-bit binary value, expressed as a decimal digit. The bits from left to right are: <br>1: Shutdown on expire <br>2: Notify on expire <br>4: Enforce minor version <br>if all three enforcements are active, the enforcement type will be 7 (1 + 2 + 4); if only the first two are active, you have an enforcement type of 3 (1 + 2). ")
    public String getEnforcementType() {
        return this.enforcementType;
    }

    public void setEnforcementType(String enforcementType) {
        this.enforcementType = enforcementType;
    }

    @ApiModelProperty(position=40, value="The Ping Identity product version from the license file.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(position=45, value="The Ping Identity product value from the license file.")
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @ApiModelProperty(position=50, value="The organization value from the license file.")
    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @ApiModelProperty(position=55, value="Number of days provided as grace period, past the expiration date (if applicable).")
    public Long getGracePeriod() {
        return this.gracePeriod;
    }

    public void setGracePeriod(Long gracePeriod) {
        this.gracePeriod = gracePeriod;
    }

    @ApiModelProperty(position=60, value="Maximum number of clustered nodes allowed under this license (if applicable).")
    public Integer getNodeLimit() {
        return this.nodeLimit;
    }

    public void setNodeLimit(Integer nodeLimit) {
        this.nodeLimit = nodeLimit;
    }

    @ApiModelProperty(position=65, value="License connection groups, if applicable.")
    public List<ConnectionGroupLicenseView> getLicenseGroups() {
        return this.licenseGroups;
    }

    public void setLicenseGroups(List<ConnectionGroupLicenseView> licenseGroups) {
        this.licenseGroups = licenseGroups;
    }

    @ApiModelProperty(position=70, value="Indicates whether OAuth role is enabled for this license.")
    public boolean isOauthEnabled() {
        return this.isOauthEnabled;
    }

    public void setOauthEnabled(boolean oauthEnabled) {
        this.isOauthEnabled = oauthEnabled;
    }

    @ApiModelProperty(position=75, value="Indicates whether WS-Trust role is enabled for this license.")
    public boolean isWsTrustEnabled() {
        return this.isWsTrustEnabled;
    }

    public void setWsTrustEnabled(boolean wsTrustEnabled) {
        this.isWsTrustEnabled = wsTrustEnabled;
    }

    @ApiModelProperty(position=80, value="Indicates whether Provisioning role is enabled for this license.")
    public boolean isProvisioningEnabled() {
        return this.isProvisioningEnabled;
    }

    public void setProvisioningEnabled(boolean provisioningEnabled) {
        this.isProvisioningEnabled = provisioningEnabled;
    }

    @ApiModelProperty(position=90, value="Indicates whether this license is a bridge license or not.")
    public boolean isBridgeMode() {
        return this.isBridgeMode;
    }

    public void setBridgeMode(boolean bridgeMode) {
        this.isBridgeMode = bridgeMode;
    }

    @ApiModelProperty(position=100, value="Other licence features, if applicable.")
    public List<LicenseFeatureView> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<LicenseFeatureView> features) {
        this.features = features;
    }
}

