/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.crypto.OCSPCheckerSupport;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="OCSP settings.")
public class OcspSettings {
    private boolean requesterAddNonce;
    private String actionOnResponderUnavailable = OCSPCheckerSupport.ACTION.CONTINUE.toString();
    private String actionOnStatusUnknown = OCSPCheckerSupport.ACTION.FAIL.toString();
    private String actionOnUnsuccessfulResponse = OCSPCheckerSupport.ACTION.FAIL.toString();
    private int currentUpdateGracePeriod = 5;
    private int nextUpdateGracePeriod = 5;
    private int responseCachePeriod = 48;
    private int responderTimeout = 5;
    private String responderUrl;
    private ResourceLink responderCertReference;

    @ApiModelProperty(position=20, value="Do not allow responder to use cached responses. This setting defaults to disabled.")
    public boolean isRequesterAddNonce() {
        return this.requesterAddNonce;
    }

    public void setRequesterAddNonce(boolean requesterAddNonce) {
        this.requesterAddNonce = requesterAddNonce;
    }

    @ApiModelProperty(position=30, value="Default responder URL. This URL is used if the certificate being checked does not specify an OCSP responder URL.")
    public String getResponderUrl() {
        return this.responderUrl;
    }

    public void setResponderUrl(String responderUrl) {
        this.responderUrl = responderUrl;
    }

    @ApiModelProperty(position=40, value="Resource link to OCSP responder signature verification certificate. A previously selected certificate will be deselected if this attribute is not defined.")
    public ResourceLink getResponderCertReference() {
        return this.responderCertReference;
    }

    public void setResponderCertReference(ResourceLink responderCertReference) {
        this.responderCertReference = responderCertReference;
    }

    @ApiModelProperty(position=50, value="Current update grace period in minutes. This value defaults to \"5\".")
    public int getCurrentUpdateGracePeriod() {
        return this.currentUpdateGracePeriod;
    }

    public void setCurrentUpdateGracePeriod(int currentUpdateGracePeriod) {
        this.currentUpdateGracePeriod = currentUpdateGracePeriod;
    }

    @ApiModelProperty(position=60, value="Next update grace period in minutes. This value defaults to \"5\".")
    public int getNextUpdateGracePeriod() {
        return this.nextUpdateGracePeriod;
    }

    public void setNextUpdateGracePeriod(int nextUpdateGracePeriod) {
        this.nextUpdateGracePeriod = nextUpdateGracePeriod;
    }

    @ApiModelProperty(position=70, value="Response cache period in hours. This value defaults to \"48\".")
    public int getResponseCachePeriod() {
        return this.responseCachePeriod;
    }

    public void setResponseCachePeriod(int responseCachePeriod) {
        this.responseCachePeriod = responseCachePeriod;
    }

    @ApiModelProperty(position=80, value="Responder connection timeout in seconds. This value defaults to \"5\".")
    public int getResponderTimeout() {
        return this.responderTimeout;
    }

    public void setResponderTimeout(int responderTimeout) {
        this.responderTimeout = responderTimeout;
    }

    @ApiModelProperty(position=90, value="Action on responder unavailable. This value defaults to  \"CONTINUE\".")
    public String getActionOnResponderUnavailable() {
        return this.actionOnResponderUnavailable;
    }

    public void setActionOnResponderUnavailable(String actionOnResponderUnavailable) {
        this.actionOnResponderUnavailable = actionOnResponderUnavailable;
    }

    @ApiModelProperty(position=100, value="Action on status unknown. This value defaults to  \"FAIL\".")
    public String getActionOnStatusUnknown() {
        return this.actionOnStatusUnknown;
    }

    public void setActionOnStatusUnknown(String actionOnStatusUnknown) {
        this.actionOnStatusUnknown = actionOnStatusUnknown;
    }

    @ApiModelProperty(position=110, value="Action on unsuccessful response. This value defaults to  \"FAIL\".")
    public String getActionOnUnsuccessfulResponse() {
        return this.actionOnUnsuccessfulResponse;
    }

    public void setActionOnUnsuccessfulResponse(String actionOnUnsuccessfulResponse) {
        this.actionOnUnsuccessfulResponse = actionOnUnsuccessfulResponse;
    }
}

