/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="PingOne connection.")
public class PingOneConnection {
    private String id;
    private String name;
    private String description;
    private Boolean active;
    private String credential;
    private String encryptedCredential;
    private Date creationDate;
    private String credentialId;
    private String pingOneConnectionId;
    private String environmentId;
    private String organizationName;
    private String region;
    private String pingOneManagementApiEndpoint;
    private String pingOneAuthenticationApiEndpoint;

    @ApiModelProperty(position=10, value="The persistent, unique ID of the connection. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The name of the PingOne connection.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="A description for the PingOne connection.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(position=40, value="Whether or not this connection is active. Defaults to true.")
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @ApiModelProperty(position=50, value="The credential for the PingOne connection. To update the credential, specify the plaintext value of the credential in this field. This field will not be populated for GET requests.")
    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    @ApiModelProperty(position=60, value="The encrypted credential for the PingOne connection. For POST and PUT requests, if you wish to keep the existing credential, this field should be passed back unchanged.")
    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public void setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
    }

    @ApiModelProperty(position=70, value="The ID of the PingOne credential. This field is read only.")
    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    @ApiModelProperty(position=80, value="The ID of the PingOne connection. This field is read only.")
    public String getPingOneConnectionId() {
        return this.pingOneConnectionId;
    }

    public void setPingOneConnectionId(String pingOneConnectionId) {
        this.pingOneConnectionId = pingOneConnectionId;
    }

    @ApiModelProperty(position=90, value="The ID of the environment of the PingOne credential. This field is read only.")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @ApiModelProperty(position=100, value="The creation date of the PingOne connection. This field is read only.")
    public Date getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return new Date(this.creationDate.getTime());
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate == null ? null : new Date(creationDate.getTime());
    }

    @ApiModelProperty(position=110, value="The name of the organization associated with this PingOne connection. This field is read only.")
    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    @ApiModelProperty(position=120, value="The region of the PingOne connection. This field is read only.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @ApiModelProperty(position=130, value="The PingOne management API endpoint. This field is read only.")
    public String getPingOneManagementApiEndpoint() {
        return this.pingOneManagementApiEndpoint;
    }

    public void setPingOneManagementApiEndpoint(String pingOneManagementApiEndpoint) {
        this.pingOneManagementApiEndpoint = pingOneManagementApiEndpoint;
    }

    @ApiModelProperty(position=140, value="The PingOne authentication API endpoint. This field is read only.")
    public String getPingOneAuthenticationApiEndpoint() {
        return this.pingOneAuthenticationApiEndpoint;
    }

    public void setPingOneAuthenticationApiEndpoint(String pingOneAuthenticationApiEndpoint) {
        this.pingOneAuthenticationApiEndpoint = pingOneAuthenticationApiEndpoint;
    }
}

