/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceCategory;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="An API model representing a reference to an API resource.")
public class ResourceUsage {
    private String id;
    private String type;
    private String name;
    private ResourceCategory categoryId;
    private String systemId;

    public ResourceUsage() {
    }

    public ResourceUsage(String id, String name, ResourceCategory category) {
        this.id = id;
        this.systemId = id;
        this.name = name;
        this.type = category.getInstanceName();
        this.categoryId = category;
    }

    public ResourceUsage(String id, String name, ResourceCategory category, String type) {
        this.id = id;
        this.systemId = id;
        this.name = name;
        this.categoryId = category;
        this.type = type;
    }

    @ApiModelProperty(position=10, value="The ID of the referencing resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The name of the referencing resource.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="The category of the referencing resource.")
    public ResourceCategory getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(ResourceCategory categoryId) {
        this.categoryId = categoryId;
    }

    @ApiModelProperty(position=40, value="The type of the referencing resource. In the case of plugins, this is the plugin type. Otherwise, it is usually the same as the name of the category.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @ApiModelProperty(position=50, value="A link to the referencing resource.")
    public ResourceLink getRef() {
        String resourcePath = this.getResourcePath(this.categoryId);
        String location = null;
        if (resourcePath != null) {
            location = ApiUtil.getResourceUrl(resourcePath, this.systemId);
        }
        return new ResourceLink(this.id, location);
    }

    private String getResourcePath(ResourceCategory category) {
        switch (category) {
            case IDP_CONNECTION: {
                return "/sp/idpConnections";
            }
            case SP_CONNECTION: {
                return "/idp/spConnections";
            }
            case DYNAMIC_CLIENT_REGISTRATION_PLUGIN: {
                return "/oauth/clientRegistrationPolicies";
            }
            case IDENTITY_STORE_PROVISIONER: {
                return null;
            }
            case AUTHENTICATION_SELECTOR: {
                return "/authenticationSelectors";
            }
            case OOB_AUTH_PLUGIN: {
                return "/oauth/outOfBandAuthPlugins";
            }
            case TOKEN_GENERATOR: {
                return "/sp/tokenGenerators";
            }
            case TOKEN_PROCESSOR: {
                return "/idp/tokenProcessors";
            }
            case DATA_STORE: {
                return "/dataStores";
            }
            case NOTIFICATION_PUBLISHER: {
                return "/notificationPublishers";
            }
            case PASSWORD_CREDENTIAL_VALIDATOR: {
                return "/passwordCredentialValidators";
            }
            case IDP_ADAPTER: {
                return "/idp/adapters";
            }
            case SP_ADAPTER: {
                return "/sp/adapters";
            }
            case ACCESS_TOKEN_MGMT_PLUGIN: {
                return "/oauth/accessTokenManagers";
            }
            case RISK_PROVIDER: {
                return "/captchaProviders";
            }
        }
        throw new RuntimeException("Unexpected resource category " + category);
    }
}

