/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import java.util.HashMap;
import java.util.Map;

public enum SaasChangedUsersAlgorithm {
    ACTIVE_DIRECTORY_USN("Active Directory USN"),
    TIMESTAMP("Timestamp"),
    TIMESTAMP_NO_NEGATION("Timestamp No Negation");

    private String domainAlgorithmName;
    private static final Map<String, SaasChangedUsersAlgorithm> DOMAIN_TO_API_TYPE_MAP;

    private SaasChangedUsersAlgorithm(String domainAlgorithmName) {
        this.domainAlgorithmName = domainAlgorithmName;
    }

    public String getDomainAlgorithmName() {
        return this.domainAlgorithmName;
    }

    public static SaasChangedUsersAlgorithm getApiType(String domainType) {
        return DOMAIN_TO_API_TYPE_MAP.get(domainType);
    }

    static {
        DOMAIN_TO_API_TYPE_MAP = new HashMap<String, SaasChangedUsersAlgorithm>();
        for (SaasChangedUsersAlgorithm type : SaasChangedUsersAlgorithm.values()) {
            DOMAIN_TO_API_TYPE_MAP.put(type.getDomainAlgorithmName(), type);
        }
    }
}

