/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.RsaAlgKeyId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Setting for a OAuth/OpenID Connect signing key set while using multiple virtual issuers.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SigningKeys {
    private ResourceLink p256ActiveCertRef;
    private ResourceLink p256PreviousCertRef;
    private Boolean p256PublishX5cParameter;
    private String p256ActiveKeyId;
    private String p256PreviousKeyId;
    private ResourceLink p384ActiveCertRef;
    private ResourceLink p384PreviousCertRef;
    private Boolean p384PublishX5cParameter;
    private String p384ActiveKeyId;
    private String p384PreviousKeyId;
    private ResourceLink p521ActiveCertRef;
    private ResourceLink p521PreviousCertRef;
    private Boolean p521PublishX5cParameter;
    private String p521ActiveKeyId;
    private String p521PreviousKeyId;
    private ResourceLink rsaActiveCertRef;
    private ResourceLink rsaPreviousCertRef;
    private Boolean rsaPublishX5cParameter;
    private String rsaActiveKeyId;
    private String rsaPreviousKeyId;
    private List<RsaAlgKeyId> rsaAlgorithmActiveKeyIds;
    private List<RsaAlgKeyId> rsaAlgorithmPreviousKeyIds;

    @ApiModelProperty(position=15, value="Reference to the P-256 key currently active.")
    public ResourceLink getP256ActiveCertRef() {
        return this.p256ActiveCertRef;
    }

    public void setP256ActiveCertRef(ResourceLink p256ActiveCertRef) {
        this.p256ActiveCertRef = p256ActiveCertRef;
    }

    @ApiModelProperty(position=20, value="Reference to the P-256 key previously active.")
    public ResourceLink getP256PreviousCertRef() {
        return this.p256PreviousCertRef;
    }

    public void setP256PreviousCertRef(ResourceLink p256PreviousCertRef) {
        this.p256PreviousCertRef = p256PreviousCertRef;
    }

    @ApiModelProperty(position=25, value="Enable publishing of the P-256 certificate chain associated with the active key.")
    public Boolean isP256PublishX5cParameter() {
        return this.p256PublishX5cParameter;
    }

    public void setP256PublishX5cParameter(Boolean p256PublishX5cParameter) {
        this.p256PublishX5cParameter = p256PublishX5cParameter;
    }

    @ApiModelProperty(position=27, value="Key Id for currently active P-256 key.")
    public String getP256ActiveKeyId() {
        return this.p256ActiveKeyId;
    }

    public void setP256ActiveKeyId(String p256ActiveKeyId) {
        this.p256ActiveKeyId = p256ActiveKeyId;
    }

    @ApiModelProperty(position=28, value="Key Id for previously active P-256 key.")
    public String getP256PreviousKeyId() {
        return this.p256PreviousKeyId;
    }

    public void setP256PreviousKeyId(String p256PreviousKeyId) {
        this.p256PreviousKeyId = p256PreviousKeyId;
    }

    @ApiModelProperty(position=30, value="Reference to the P-384 key currently active.")
    public ResourceLink getP384ActiveCertRef() {
        return this.p384ActiveCertRef;
    }

    public void setP384ActiveCertRef(ResourceLink p384ActiveCertRef) {
        this.p384ActiveCertRef = p384ActiveCertRef;
    }

    @ApiModelProperty(position=35, value="Reference to the P-384 key previously active.")
    public ResourceLink getP384PreviousCertRef() {
        return this.p384PreviousCertRef;
    }

    public void setP384PreviousCertRef(ResourceLink p384PreviousCertRef) {
        this.p384PreviousCertRef = p384PreviousCertRef;
    }

    @ApiModelProperty(position=40, value="Enable publishing of the P-384 certificate chain associated with the active key.")
    public Boolean isP384PublishX5cParameter() {
        return this.p384PublishX5cParameter;
    }

    public void setP384PublishX5cParameter(Boolean p384PublishX5cParameter) {
        this.p384PublishX5cParameter = p384PublishX5cParameter;
    }

    @ApiModelProperty(position=43, value="Key Id for currently active P-384 key.")
    public String getP384ActiveKeyId() {
        return this.p384ActiveKeyId;
    }

    public void setP384ActiveKeyId(String p384ActiveKeyId) {
        this.p384ActiveKeyId = p384ActiveKeyId;
    }

    @ApiModelProperty(position=44, value="Key Id for previously active P-384 key.")
    public String getP384PreviousKeyId() {
        return this.p384PreviousKeyId;
    }

    public void setP384PreviousKeyId(String p384PreviousKeyId) {
        this.p384PreviousKeyId = p384PreviousKeyId;
    }

    @ApiModelProperty(position=45, value="Reference to the P-521 key currently active.")
    public ResourceLink getP521ActiveCertRef() {
        return this.p521ActiveCertRef;
    }

    public void setP521ActiveCertRef(ResourceLink p521ActiveCertRef) {
        this.p521ActiveCertRef = p521ActiveCertRef;
    }

    @ApiModelProperty(position=50, value="Reference to the P-521 key previously active.")
    public ResourceLink getP521PreviousCertRef() {
        return this.p521PreviousCertRef;
    }

    public void setP521PreviousCertRef(ResourceLink p521PreviousCertRef) {
        this.p521PreviousCertRef = p521PreviousCertRef;
    }

    @ApiModelProperty(position=55, value="Enable publishing of the P-521 certificate chain associated with the active key.")
    public Boolean isP521PublishX5cParameter() {
        return this.p521PublishX5cParameter;
    }

    public void setP521PublishX5cParameter(Boolean p521PublishX5cParameter) {
        this.p521PublishX5cParameter = p521PublishX5cParameter;
    }

    @ApiModelProperty(position=57, value="Key Id for currently active P-521 key.")
    public String getP521ActiveKeyId() {
        return this.p521ActiveKeyId;
    }

    public void setP521ActiveKeyId(String p521ActiveKeyId) {
        this.p521ActiveKeyId = p521ActiveKeyId;
    }

    @ApiModelProperty(position=58, value="Key Id for previously active P-521 key.")
    public String getP521PreviousKeyId() {
        return this.p521PreviousKeyId;
    }

    public void setP521PreviousKeyId(String p521PreviousKeyId) {
        this.p521PreviousKeyId = p521PreviousKeyId;
    }

    @ApiModelProperty(position=60, value="Reference to the RSA key currently active.")
    public ResourceLink getRsaActiveCertRef() {
        return this.rsaActiveCertRef;
    }

    public void setRsaActiveCertRef(ResourceLink rsaActiveCertRef) {
        this.rsaActiveCertRef = rsaActiveCertRef;
    }

    @ApiModelProperty(position=65, value="Reference to the RSA key previously active.")
    public ResourceLink getRsaPreviousCertRef() {
        return this.rsaPreviousCertRef;
    }

    public void setRsaPreviousCertRef(ResourceLink rsaPreviousCertRef) {
        this.rsaPreviousCertRef = rsaPreviousCertRef;
    }

    @ApiModelProperty(position=67, value="Enable publishing of the RSA certificate chain associated with the active key.")
    public Boolean isRsaPublishX5cParameter() {
        return this.rsaPublishX5cParameter;
    }

    public void setRsaPublishX5cParameter(Boolean rsaPublishX5cParameter) {
        this.rsaPublishX5cParameter = rsaPublishX5cParameter;
    }

    @ApiModelProperty(position=68, value="Key Id for currently active RSA key.")
    public String getRsaActiveKeyId() {
        return this.rsaActiveKeyId;
    }

    public void setRsaActiveKeyId(String rsaActiveKeyId) {
        this.rsaActiveKeyId = rsaActiveKeyId;
    }

    @ApiModelProperty(position=69, value="Key Id for previously active RSA key.")
    public String getRsaPreviousKeyId() {
        return this.rsaPreviousKeyId;
    }

    public void setRsaPreviousKeyId(String rsaPreviousKeyId) {
        this.rsaPreviousKeyId = rsaPreviousKeyId;
    }

    @ApiModelProperty(position=75, value="PingFederate uses the same RSA key for all RSA signing algorithms. To enable active RSA JWK entry to have unique single valued ''alg'' parameter, use this list to set a key identifier for each RSA algorithm (RS256, RS384, RS512, PS256, PS384 and PS512).")
    public List<RsaAlgKeyId> getRsaAlgorithmActiveKeyIds() {
        return this.rsaAlgorithmActiveKeyIds;
    }

    public void setRsaAlgorithmActiveKeyIds(List<RsaAlgKeyId> rsaAlgorithmActiveKeyIds) {
        this.rsaAlgorithmActiveKeyIds = rsaAlgorithmActiveKeyIds;
    }

    @ApiModelProperty(position=80, value="PingFederate uses the same RSA key for all RSA signing algorithms. To enable previously active RSA JWK entry to have unique single valued ''alg'' parameter, use this list to set a key identifier for each RSA algorithm (RS256, RS384, RS512, PS256, PS384 and PS512).")
    public List<RsaAlgKeyId> getRsaAlgorithmPreviousKeyIds() {
        return this.rsaAlgorithmPreviousKeyIds;
    }

    public void setRsaAlgorithmPreviousKeyIds(List<RsaAlgKeyId> rsaAlgorithmPreviousKeyIds) {
        this.rsaAlgorithmPreviousKeyIds = rsaAlgorithmPreviousKeyIds;
    }
}

