/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.pingidentity.admin.api.model.AdditionalAllowedEntitiesConfiguration;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionTargetType;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.OutboundProvision;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpAttributeQuery;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.WsFedTokenType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="The set of attributes used to configure an SP connection.", parent=Connection.class)
public class SpConnection
extends Connection {
    private SpBrowserSso spBrowserSso;
    private SpAttributeQuery attributeQuery;
    private String applicationName;
    private String applicationIconUrl;
    private SpWsTrust wsTrust;
    private OutboundProvision outboundProvision;
    private ConnectionTargetType connectionTargetType;

    @Override
    @ApiModelProperty(position=5, value="The type of this connection. Default is 'IDP'.")
    @JsonTypeId
    public ConnectionType getType() {
        return ConnectionType.SP;
    }

    @ApiModelProperty(position=65, value="The browser-based SSO settings used to communicate with your SP.")
    public SpBrowserSso getSpBrowserSso() {
        return this.spBrowserSso;
    }

    public void setSpBrowserSso(SpBrowserSso spBrowserSso) {
        this.spBrowserSso = spBrowserSso;
    }

    @ApiModelProperty(position=101, value="The application name.")
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @ApiModelProperty(position=102, value="The application icon url.")
    public String getApplicationIconUrl() {
        return this.applicationIconUrl;
    }

    public void setApplicationIconUrl(String applicationIconUrl) {
        this.applicationIconUrl = applicationIconUrl;
    }

    @Override
    @JsonIgnore
    public BaseBrowserSso getBrowserSso() {
        return this.spBrowserSso;
    }

    @ApiModelProperty(position=66, value="The attribute query settings for supporting SPs in requesting user attributes.")
    public SpAttributeQuery getAttributeQuery() {
        return this.attributeQuery;
    }

    public void setAttributeQuery(SpAttributeQuery attributeQuery) {
        this.attributeQuery = attributeQuery;
    }

    @ApiModelProperty(position=67, value="The Ws-Trust settings.")
    public SpWsTrust getWsTrust() {
        return this.wsTrust;
    }

    public void setWsTrust(SpWsTrust wsTrust) {
        this.wsTrust = wsTrust;
    }

    @Override
    @ApiModelProperty(position=120, value="Additional allowed entities or issuers configuration. Currently only used in OIDC IdP (RP) connection.")
    public AdditionalAllowedEntitiesConfiguration getAdditionalAllowedEntitiesConfiguration() {
        return null;
    }

    @ApiModelProperty(position=150, value="The Outbound Provision settings.")
    public OutboundProvision getOutboundProvision() {
        return this.outboundProvision;
    }

    public void setOutboundProvision(OutboundProvision outboundProvisioning) {
        this.outboundProvision = outboundProvisioning;
    }

    @ApiModelProperty(position=160, value="The connection target type. This field is intended for bulk import/export usage. Changing its value may result in unexpected behavior.")
    public ConnectionTargetType getConnectionTargetType() {
        return this.connectionTargetType;
    }

    public void setConnectionTargetType(ConnectionTargetType targetType) {
        this.connectionTargetType = targetType;
    }

    @Override
    @JsonIgnore
    public boolean isBrowserSsoSaml2() {
        return this.getBrowserSso() != null && (this.getBrowserSso().getProtocol() == Protocol.SAML20 || Protocol.WSFED == this.getBrowserSso().getProtocol() && WsFedTokenType.SAML20 == ((SpBrowserSso)this.getBrowserSso()).getWsFedTokenType());
    }
}

