/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.bulkconfig;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.bulkconfig.BulkConfigManager;
import com.pingidentity.admin.api.bulkconfig.BulkConfigProviderFactory;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperation;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperationType;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.exception.ValidationErrorException;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConfigOperationDeserializer
extends StdDeserializer<ConfigOperation> {
    public ConfigOperationDeserializer() {
        this(null);
    }

    public ConfigOperationDeserializer(Class<ConfigOperation> cls) {
        super(cls);
    }

    public ConfigOperation deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode itemIdsNode;
        ConfigOperation result = new ConfigOperation();
        JsonNode operationNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        HashMap<String, JsonNode> fieldsMap = new HashMap<String, JsonNode>();
        Iterator fieldIter = operationNode.fields();
        while (fieldIter.hasNext()) {
            Map.Entry entry = (Map.Entry)fieldIter.next();
            fieldsMap.put((String)entry.getKey(), (JsonNode)entry.getValue());
        }
        String operationType = this.getStringFieldValue(jsonParser, operationNode, "operationType");
        if (operationType == null) {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_operation_type_required, this.getFieldPath(jsonParser.getParsingContext(), "operationType"));
            throw new ValidationErrorException(error, 422);
        }
        if (!this.isValidConfigOperation(operationType)) {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_operation_type_invalid, this.getFieldPath(jsonParser.getParsingContext(), "operationType"));
            throw new ValidationErrorException(error, 400);
        }
        result.setOperationType(ConfigOperationType.valueOf(operationType));
        String resourceType = this.getStringFieldValue(jsonParser, operationNode, "resourceType");
        if (resourceType == null) {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_resource_type_required, this.getFieldPath(jsonParser.getParsingContext(), "resourceType"));
            throw new ValidationErrorException(error, 422);
        }
        BulkConfigProviderFactory<?> providerFactory = BulkConfigManager.getInstance().getProviderFactoryForPath(resourceType);
        if (providerFactory == null) {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_resource_type_invalid, this.getFieldPath(jsonParser.getParsingContext(), "resourceType"), new Object[]{resourceType});
            throw new ValidationErrorException(error, 422);
        }
        result.setResourceType(resourceType);
        String subResource = this.getStringFieldValue(jsonParser, operationNode, "subResource");
        result.setSubResource(subResource);
        JsonNode itemsNode = operationNode.get("items");
        if (itemsNode != null) {
            try {
                JsonParser itemsParser = itemsNode.traverse(jsonParser.getCodec());
                itemsParser.nextToken();
                JsonDeserializer deserializer = deserializationContext.findRootValueDeserializer((JavaType)deserializationContext.getTypeFactory().constructCollectionType(List.class, providerFactory.getResourceTypeClass()));
                List itemsList = (List)deserializer.deserialize(itemsParser, deserializationContext);
                result.setItems(itemsList);
            }
            catch (JsonMappingException e) {
                throw JsonMappingException.wrapWithPath((Throwable)e, (Object)result, (String)"items");
            }
        }
        if ((itemIdsNode = operationNode.get("itemIds")) != null) {
            try {
                JsonParser itemIdsParser = itemIdsNode.traverse(jsonParser.getCodec());
                itemIdsParser.nextToken();
                JsonDeserializer deserializer = deserializationContext.findRootValueDeserializer((JavaType)deserializationContext.getTypeFactory().constructCollectionType(List.class, String.class));
                List itemIdsList = (List)deserializer.deserialize(itemIdsParser, deserializationContext);
                result.setItemIds(itemIdsList);
            }
            catch (JsonMappingException e) {
                throw JsonMappingException.wrapWithPath((Throwable)e, (Object)result, (String)"itemIds");
            }
        }
        return result;
    }

    private String getStringFieldValue(JsonParser jsonParser, JsonNode operationNode, String fieldName) throws ValidationErrorException {
        JsonNode node = operationNode.get(fieldName);
        if (node == null) {
            return null;
        }
        if (!node.getNodeType().equals((Object)JsonNodeType.STRING)) {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.format_invalid, this.getFieldPath(jsonParser.getParsingContext(), fieldName), new Object[]{fieldName});
            throw new ValidationErrorException(error, 400);
        }
        return node.textValue();
    }

    private boolean isValidConfigOperation(String operationName) {
        return Arrays.stream(ConfigOperationType.values()).anyMatch(type -> type.name().equals(operationName));
    }

    private String getFieldPath(JsonStreamContext streamContext, String currentField) {
        return this.trimLeadingDot(this.doGetFieldPath(streamContext, "." + currentField));
    }

    private String doGetFieldPath(JsonStreamContext streamContext, String tail) {
        if (streamContext == null) {
            return tail;
        }
        if (streamContext.inArray()) {
            return this.doGetFieldPath(streamContext.getParent(), this.prependToTail("[" + streamContext.getCurrentIndex() + "]", tail));
        }
        if (streamContext.inObject()) {
            return this.doGetFieldPath(streamContext.getParent(), this.prependToTail("." + streamContext.getCurrentName(), tail));
        }
        return tail;
    }

    private String prependToTail(String prefix, String tail) {
        if (tail == null) {
            return prefix;
        }
        return prefix + tail;
    }

    private String trimLeadingDot(String tail) {
        if (tail != null && tail.startsWith(".")) {
            return tail.substring(1);
        }
        return tail;
    }
}

