/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.bulkconfig;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperation;
import java.io.IOException;

public class ConfigOperationSerializer
extends StdSerializer<ConfigOperation> {
    public static final String FIELD_RESOURCE_TYPE = "resourceType";
    public static final String FIELD_OPERATION_TYPE = "operationType";
    public static final String FIELD_SUB_RESOURCE = "subResource";
    public static final String FIELD_ITEMS = "items";
    public static final String FIELD_ITEM_IDS = "itemIds";

    public ConfigOperationSerializer() {
        this(null);
    }

    public ConfigOperationSerializer(Class<ConfigOperation> cls) {
        super(cls);
    }

    public void serialize(ConfigOperation value, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField(FIELD_RESOURCE_TYPE, value.getResourceType());
        jgen.writeStringField(FIELD_OPERATION_TYPE, value.getOperationType().toString());
        if (value.getSubResource() != null) {
            jgen.writeStringField(FIELD_SUB_RESOURCE, value.getSubResource());
        }
        if (value.getItems() != null) {
            jgen.writeArrayFieldStart(FIELD_ITEMS);
            for (Object item : value.getItems()) {
                serializerProvider.defaultSerializeValue(item, jgen);
            }
            jgen.writeEndArray();
        }
        if (value.getItemIds() != null) {
            jgen.writeFieldName(FIELD_ITEM_IDS);
            serializerProvider.defaultSerializeValue(value.getItemIds(), jgen);
        }
        jgen.writeEndObject();
    }
}

