/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.collectsupportdata;

import com.pingidentity.admin.api.model.collectsupportdata.CsdNodeType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Settings related to the Collect Support Data utility.")
public class CsdSettings {
    private List<Integer> nodesToCollect;
    private CsdNodeType nodeTypeToCollect;
    private boolean truncateLogs;
    private Long fileHeadCollectionKBSize;
    private Long fileTailCollectionKBSize;
    private Long rolledLogCount;
    private boolean encryptArchive;
    private String encryptionPassphrase;
    private boolean collectExpensiveData;
    private Long numHeartbeatSamples;
    private Long intervalBetweenHeartbeatSamples;
    private Long reportCount;
    private Long reportInterval;
    private boolean includeBinaryFiles;
    private String comment;

    @ApiModelProperty(position=10, value="The list of nodes to collect support data archives from.")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public List<Integer> getNodesToCollect() {
        return this.nodesToCollect;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setNodesToCollect(List<Integer> nodesToCollect) {
        this.nodesToCollect = nodesToCollect;
    }

    @ApiModelProperty(position=15, value="The type of PingFederate nodes to collect support data archives from.")
    public CsdNodeType getNodeTypeToCollect() {
        return this.nodeTypeToCollect;
    }

    public void setNodeTypeToCollect(CsdNodeType nodeTypeToCollect) {
        this.nodeTypeToCollect = nodeTypeToCollect;
    }

    @ApiModelProperty(position=20, value="If set, PingFederate logs will be truncated.")
    public boolean isTruncateLogs() {
        return this.truncateLogs;
    }

    public void setTruncateLogs(boolean truncateLogs) {
        this.truncateLogs = truncateLogs;
    }

    @ApiModelProperty(position=30, value="The amount of data in kilobytes to collect at the beginning of truncated files. Data will not be truncated from the beginning of files if left blank.")
    public Long getFileHeadCollectionKBSize() {
        return this.fileHeadCollectionKBSize;
    }

    public void setFileHeadCollectionKBSize(Long fileHeadCollectionKBSize) {
        this.fileHeadCollectionKBSize = fileHeadCollectionKBSize;
    }

    @ApiModelProperty(position=40, value="The amount of data in kilobytes to collect at the end of truncated files. Data will not be truncated from the end of files if left blank.")
    public Long getFileTailCollectionKBSize() {
        return this.fileTailCollectionKBSize;
    }

    public void setFileTailCollectionKBSize(Long fileTailCollectionKBSize) {
        this.fileTailCollectionKBSize = fileTailCollectionKBSize;
    }

    @ApiModelProperty(position=45, value="The number of rolled server log files to collect.")
    public Long getRolledLogCount() {
        return this.rolledLogCount;
    }

    public void setRolledLogCount(Long rolledLogCount) {
        this.rolledLogCount = rolledLogCount;
    }

    @ApiModelProperty(position=50, value="Indicates that the resulting support data archive should be encrypted.")
    public boolean isEncryptArchive() {
        return this.encryptArchive;
    }

    public void setEncryptArchive(boolean encryptArchive) {
        this.encryptArchive = encryptArchive;
    }

    @ApiModelProperty(position=60, value="The passphrase to use to encrypt and decrypt the support data archive. Required if encryptArchive is true.")
    public String getEncryptionPassphrase() {
        return this.encryptionPassphrase;
    }

    public void setEncryptionPassphrase(String encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase;
    }

    @ApiModelProperty(position=100, value="If set, binary files will be included in the collected archive.")
    public boolean isIncludeBinaryFiles() {
        return this.includeBinaryFiles;
    }

    public void setIncludeBinaryFiles(boolean includeBinaryFiles) {
        this.includeBinaryFiles = includeBinaryFiles;
    }

    @ApiModelProperty(position=110, value="Collect data from expensive or long running processes. These processes may make the PingFederate server unresponsive for a couple of minutes.")
    public boolean isCollectExpensiveData() {
        return this.collectExpensiveData;
    }

    public void setCollectExpensiveData(boolean collectExpensiveData) {
        this.collectExpensiveData = collectExpensiveData;
    }

    @ApiModelProperty(position=120, value="Number of heartbeat samples to take.")
    public Long getNumHeartbeatSamples() {
        return this.numHeartbeatSamples;
    }

    public void setNumHeartbeatSamples(Long numHeartbeatSamples) {
        this.numHeartbeatSamples = numHeartbeatSamples;
    }

    @ApiModelProperty(position=130, value="Interval between heartbeat calls in seconds.")
    public Long getIntervalBetweenHeartbeatSamples() {
        return this.intervalBetweenHeartbeatSamples;
    }

    public void setIntervalBetweenHeartbeatSamples(Long intervalBetweenHeartbeatSamples) {
        this.intervalBetweenHeartbeatSamples = intervalBetweenHeartbeatSamples;
    }

    @ApiModelProperty(position=140, value="Number of reports generated for commands that support sampling (for example, mpstat). A value of 0 (zero) indicates that no reports will be generated for these commands")
    public Long getReportCount() {
        return this.reportCount;
    }

    public void setReportCount(Long reportCount) {
        this.reportCount = reportCount;
    }

    @ApiModelProperty(position=150, value="Number of seconds between reports for commands that support sampling (for example, mpstat).")
    public Long getReportInterval() {
        return this.reportInterval;
    }

    public void setReportInterval(Long reportInterval) {
        this.reportInterval = reportInterval;
    }

    @ApiModelProperty(position=160, value="Specify additional information about the collected data set.  This comment will be added to the generated archive as a README file.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

