/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.internal;

import com.pingidentity.admin.api.model.internal.InternalItems;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.pf.admin.rest.translator.internal.PFInfoTranslator;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import java.util.List;
import java.util.Map;

public class InternalInfo
extends InternalItems<NavNode> {
    private static final int CONSOLE_SESSION_TIMEOUT_IN_MILLI;
    private final String environment;
    private final String consoleTitle;
    private final Map<String, String> documentationUrls;
    private final boolean showBackground;
    private final String version;
    private final boolean accountManagementVisible;
    private final boolean adminVisible;
    private final String pingOneAdminUrlRegion;
    private final String pingOneAdminUrlEnvironmentId;
    private final String timezone;
    private final boolean isLog4j2Upgraded;

    public InternalInfo(List<NavNode> items, PFInfoTranslator translator) {
        super(items);
        this.environment = translator.getEnvironment();
        this.version = translator.getVersion();
        this.consoleTitle = translator.getConsoleTitle();
        this.documentationUrls = translator.getAllDocContextLinks();
        this.showBackground = translator.getShowBackground();
        this.accountManagementVisible = translator.isAccountManagementVisible();
        this.adminVisible = translator.isAdminVisible();
        this.pingOneAdminUrlRegion = translator.getPingOneAdminUrlRegion();
        this.pingOneAdminUrlEnvironmentId = translator.getPingOneAdminUrlEnvironmentId();
        this.timezone = translator.getTimezone();
        this.isLog4j2Upgraded = translator.getIsLog4j2Upgraded();
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getConsoleTitle() {
        return this.consoleTitle;
    }

    public Map<String, String> getDocumentationUrls() {
        return this.documentationUrls;
    }

    public boolean getShowBackground() {
        return this.showBackground;
    }

    public String getPingOneAdminUrlRegion() {
        return this.pingOneAdminUrlRegion;
    }

    public String getPingOneAdminUrlEnvironmentId() {
        return this.pingOneAdminUrlEnvironmentId;
    }

    public int getConsoleSessionTimeoutInMilli() {
        return CONSOLE_SESSION_TIMEOUT_IN_MILLI;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }

    public boolean isAccountManagementVisible() {
        return this.accountManagementVisible;
    }

    public boolean isAdminVisible() {
        return this.adminVisible;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public boolean getIsLog4j2Upgraded() {
        return this.isLog4j2Upgraded;
    }

    static {
        int intTimeout;
        String timeout = System.getProperty("pf.console.session.timeout", "30");
        try {
            intTimeout = Integer.parseInt(timeout);
            if (intTimeout < 1 || intTimeout > 480) {
                intTimeout = 30;
            }
        }
        catch (NumberFormatException e) {
            intTimeout = 30;
        }
        CONSOLE_SESSION_TIMEOUT_IN_MILLI = intTimeout * 1000 * 60;
    }
}

