/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.localidentity;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.localidentity.type.EmailVerificationType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="A local identity email verification configuration.")
public class EmailVerificationConfig {
    public static final String DEFAULT_VERIFY_EMAIL_TEMPLATE_NAME = "message-template-email-ownership-verification.html";
    public static final String DEFAULT_EMAIL_VERIFICATION_SENT_TEMPLATE_NAME = "local.identity.email.verification.sent.html";
    public static final String DEFAULT_EMAIL_VERIFICATION_SUCCESS_TEMPLATE_NAME = "local.identity.email.verification.success.html";
    public static final String DEFAULT_EMAIL_VERIFICATION_ERROR_TEMPLATE_NAME = "local.identity.email.verification.error.html";
    public static final String DEFAULT_REQUIRE_VERIFIED_EMAIL_TEMPLATE_NAME = "local.identity.email.verification.required.html";
    public static final String DEFAULT_EMAIL_VERIFICATION_OTP_TEMPLATE_NAME = "local.identity.email.verification.otp.html";
    public static final int DEFAULT_OTL_TIME_TO_LIVE = 1440;
    public static final int DEFAULT_OTP_RETRY_ATTEMPTS = 3;
    public static final int DEFAULT_OTP_LENGTH = 8;
    public static final int DEFAULT_OTP_TIME_TO_LIVE = 15;
    public static final String DEFAULT_ALLOWED_OTP_CHARACTER_SET = "23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz";
    private boolean emailVerificationEnabled;
    private String verifyEmailTemplateName;
    private String emailVerificationSentTemplateName;
    private String emailVerificationSuccessTemplateName;
    private String emailVerificationErrorTemplateName;
    private EmailVerificationType emailVerificationType;
    private Integer otpLength;
    private Integer otpRetryAttempts;
    private String allowedOtpCharacterSet;
    private Integer otpTimeToLive;
    private String emailVerificationOtpTemplateName;
    private Integer otlTimeToLive;
    private String fieldForEmailToVerify;
    private String fieldStoringVerificationStatus;
    private ResourceLink notificationPublisherRef;
    private Boolean requireVerifiedEmail;
    private String requireVerifiedEmailTemplateName;

    @ApiModelProperty(position=10, value="Whether the email ownership verification is enabled.")
    public boolean isEmailVerificationEnabled() {
        return this.emailVerificationEnabled;
    }

    public void setEmailVerificationEnabled(boolean emailVerificationEnabled) {
        this.emailVerificationEnabled = emailVerificationEnabled;
    }

    @ApiModelProperty(position=20, value="The template name for verify email. The default is message-template-email-ownership-verification.html.")
    public String getVerifyEmailTemplateName() {
        return this.verifyEmailTemplateName;
    }

    public void setVerifyEmailTemplateName(String verifyEmailTemplateName) {
        this.verifyEmailTemplateName = verifyEmailTemplateName;
    }

    @ApiModelProperty(position=30, value="The template name for email verification sent. The default is local.identity.email.verification.sent.html.<br>Note:Only applicable if EmailVerificationType is OTL.")
    public String getEmailVerificationSentTemplateName() {
        return this.emailVerificationSentTemplateName;
    }

    public void setEmailVerificationSentTemplateName(String emailVerificationSentTemplateName) {
        this.emailVerificationSentTemplateName = emailVerificationSentTemplateName;
    }

    @ApiModelProperty(position=40, value="The template name for email verification success. The default is local.identity.email.verification.success.html.")
    public String getEmailVerificationSuccessTemplateName() {
        return this.emailVerificationSuccessTemplateName;
    }

    public void setEmailVerificationSuccessTemplateName(String emailVerificationSuccessTemplateName) {
        this.emailVerificationSuccessTemplateName = emailVerificationSuccessTemplateName;
    }

    @ApiModelProperty(position=50, value="The template name for email verification error.  The default is local.identity.email.verification.error.html.")
    public String getEmailVerificationErrorTemplateName() {
        return this.emailVerificationErrorTemplateName;
    }

    public void setEmailVerificationErrorTemplateName(String emailVerificationErrorTemplateName) {
        this.emailVerificationErrorTemplateName = emailVerificationErrorTemplateName;
    }

    @ApiModelProperty(position=60, value="Email Verification Type.")
    public EmailVerificationType getEmailVerificationType() {
        return this.emailVerificationType;
    }

    public void setEmailVerificationType(EmailVerificationType emailVerificationType) {
        this.emailVerificationType = emailVerificationType;
    }

    @ApiModelProperty(position=70, value="The OTP length generated for email verification. The default is 8.<br>Note: Only applicable if EmailVerificationType is OTP.")
    public Integer getOtpLength() {
        return this.otpLength;
    }

    public void setOtpLength(Integer otpLength) {
        this.otpLength = otpLength;
    }

    @ApiModelProperty(position=80, value="The number of OTP retry attempts for email verification. The default is 3.<br>Note: Only applicable if EmailVerificationType is OTP.")
    public Integer getOtpRetryAttempts() {
        return this.otpRetryAttempts;
    }

    public void setOtpRetryAttempts(Integer otpRetryAttempts) {
        this.otpRetryAttempts = otpRetryAttempts;
    }

    @ApiModelProperty(position=90, value="The allowed character set used to generate the OTP. The default is 23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz.<br>Note: Only applicable if EmailVerificationType is OTP.")
    public String getAllowedOtpCharacterSet() {
        return this.allowedOtpCharacterSet;
    }

    public void setAllowedOtpCharacterSet(String allowedOtpCharacterSet) {
        this.allowedOtpCharacterSet = allowedOtpCharacterSet;
    }

    @ApiModelProperty(position=100, value="Field used OTP time to live. The default is 15.<br>Note: Only applicable if EmailVerificationType is OTP.")
    public Integer getOtpTimeToLive() {
        return this.otpTimeToLive;
    }

    public void setOtpTimeToLive(Integer otpTimeToLive) {
        this.otpTimeToLive = otpTimeToLive;
    }

    @ApiModelProperty(position=110, value="The template name for email verification OTP verification.  The default is local.identity.email.verification.otp.html.<br>Note: Only applicable if EmailVerificationType is OTP.")
    public String getEmailVerificationOtpTemplateName() {
        return this.emailVerificationOtpTemplateName;
    }

    public void setEmailVerificationOtpTemplateName(String emailVerificationOtpTemplateName) {
        this.emailVerificationOtpTemplateName = emailVerificationOtpTemplateName;
    }

    @ApiModelProperty(position=120, value="Field used OTL time to live. The default is 1440.<br>Note: Only applicable if EmailVerificationType is OTL.")
    public Integer getOtlTimeToLive() {
        return this.otlTimeToLive;
    }

    public void setOtlTimeToLive(Integer otlTimeToLive) {
        this.otlTimeToLive = otlTimeToLive;
    }

    @ApiModelProperty(position=130, value="Field used for email ownership verification.<br>Note: Not required when emailVerificationEnabled is set to false.", required=true)
    public String getFieldForEmailToVerify() {
        return this.fieldForEmailToVerify;
    }

    public void setFieldForEmailToVerify(String fieldForEmailToVerify) {
        this.fieldForEmailToVerify = fieldForEmailToVerify;
    }

    @ApiModelProperty(position=140, value="Field used for storing email verification status.<br>Note: Not required when emailVerificationEnabled is set to false.", required=true)
    public String getFieldStoringVerificationStatus() {
        return this.fieldStoringVerificationStatus;
    }

    public void setFieldStoringVerificationStatus(String fieldStoringVerificationStatus) {
        this.fieldStoringVerificationStatus = fieldStoringVerificationStatus;
    }

    @ApiModelProperty(position=150, value="Reference to the associated notification publisher.", required=false)
    public ResourceLink getNotificationPublisherRef() {
        return this.notificationPublisherRef;
    }

    public void setNotificationPublisherRef(ResourceLink notificationPublisherRef) {
        this.notificationPublisherRef = notificationPublisherRef;
    }

    @ApiModelProperty(position=160, value="Whether the user must verify their email address before they can complete a single sign-on transaction. The default is false.")
    public Boolean isRequireVerifiedEmail() {
        return this.requireVerifiedEmail;
    }

    public void setRequireVerifiedEmail(Boolean requireVerifiedEmail) {
        this.requireVerifiedEmail = requireVerifiedEmail;
    }

    @ApiModelProperty(position=170, value="The template to render when the user must verify their email address before they can complete a single sign-on transaction. The default is local.identity.email.verification.required.html.<br>Note:Only applicable if EmailVerificationType is OTL and requireVerifiedEmail is true.")
    public String getRequireVerifiedEmailTemplateName() {
        return this.requireVerifiedEmailTemplateName;
    }

    public void setRequireVerifiedEmailTemplateName(String requireVerifiedEmailTemplateName) {
        this.requireVerifiedEmailTemplateName = requireVerifiedEmailTemplateName;
    }
}

