/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.localidentity;

import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.localidentity.DataStoreAttribute;
import com.pingidentity.admin.api.model.localidentity.DataStoreConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;

@ApiModel(description="LDAP data store configuration.", parent=DataStoreConfig.class)
public class LdapDataStoreConfig
implements DataStoreConfig {
    private ResourceLink dataStoreRef;
    private Map<String, DataStoreAttribute> dataStoreAttributeMapping;
    private String baseDn;
    private String createPattern;
    private String objectClass;
    private List<String> auxiliaryObjectClasses;
    private boolean bypassDataStoreValidation;

    @Override
    @ApiModelProperty(position=10, value="The data store config type.", required=true)
    public DataStoreType getType() {
        return DataStoreType.LDAP;
    }

    @Override
    @ApiModelProperty(value="Reference to the associated data store.", required=true, position=20)
    public ResourceLink getDataStoreRef() {
        return this.dataStoreRef;
    }

    @Override
    public void setDataStoreRef(ResourceLink dataStoreRef) {
        this.dataStoreRef = dataStoreRef;
    }

    @ApiModelProperty(value="The base DN to search from.", position=30, required=true)
    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    @ApiModelProperty(value="The Relative DN Pattern that will be used to create objects in the directory.", position=50, required=true)
    public String getCreatePattern() {
        return this.createPattern;
    }

    public void setCreatePattern(String createPattern) {
        this.createPattern = createPattern;
    }

    @ApiModelProperty(value="The Object Class used by the new objects stored in the LDAP data store.", position=60, required=true)
    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    @ApiModelProperty(value="The Auxiliary Object Classes used by the new objects stored in the LDAP data store.", position=70)
    public List<String> getAuxiliaryObjectClasses() {
        return this.auxiliaryObjectClasses;
    }

    public void setAuxiliaryObjectClasses(List<String> auxiliaryObjectClasses) {
        this.auxiliaryObjectClasses = auxiliaryObjectClasses;
    }

    @Override
    @ApiModelProperty(value="The data store mapping.", position=100, required=true)
    public Map<String, DataStoreAttribute> getDataStoreMapping() {
        return this.dataStoreAttributeMapping;
    }

    @Override
    public void setDataStoreMapping(Map<String, DataStoreAttribute> mapping) {
        this.dataStoreAttributeMapping = mapping;
    }
}

