/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.localidentity;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.localidentity.ExecuteWorkflowSetting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="A local identity profile registration configuration.")
public class RegistrationConfig {
    public static final String DEFAULT_TEMPLATE_NAME = "local.identity.registration.html";
    private boolean captchaEnabled = false;
    private ResourceLink captchaProviderRef;
    private String templateName = "local.identity.registration.html";
    private boolean createAuthnSessionAfterRegistration = true;
    private String usernameField;
    private boolean thisIsMyDeviceEnabled = false;
    private ResourceLink registrationWorkflow;
    private ExecuteWorkflowSetting executeWorkflow;

    @ApiModelProperty(position=10, value="Whether CAPTCHA is enabled or not in the registration configuration.")
    public boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    public void setCaptchaEnabled(boolean captchaEnabled) {
        this.captchaEnabled = captchaEnabled;
    }

    @ApiModelProperty(position=15, value="Reference to the associated CAPTCHA provider.")
    public ResourceLink getCaptchaProviderRef() {
        return this.captchaProviderRef;
    }

    public void setCaptchaProviderRef(ResourceLink captchaProviderRef) {
        this.captchaProviderRef = captchaProviderRef;
    }

    @ApiModelProperty(position=20, value="The template name for the registration configuration.", required=true)
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @ApiModelProperty(position=30, value="Whether to create an Authentication Session when registering a local account. Default is true.")
    public boolean isCreateAuthnSessionAfterRegistration() {
        return this.createAuthnSessionAfterRegistration;
    }

    public void setCreateAuthnSessionAfterRegistration(boolean createAuthnSessionAfterRegistration) {
        this.createAuthnSessionAfterRegistration = createAuthnSessionAfterRegistration;
    }

    @ApiModelProperty(position=31, value="When creating an Authentication Session after registering a local account, PingFederate will pass the Unique ID field's value as the username. If the Unique ID value is not the username, then override which field's value will be used as the username.")
    public String getUsernameField() {
        return this.usernameField;
    }

    public void setUsernameField(String usernameField) {
        this.usernameField = usernameField;
    }

    @ApiModelProperty(position=40, value="Allows users to indicate whether their device is shared or private. In this mode, PingFederate Authentication Sessions will not be stored unless the user indicates the device is private.")
    public boolean isThisIsMyDeviceEnabled() {
        return this.thisIsMyDeviceEnabled;
    }

    public void setThisIsMyDeviceEnabled(boolean thisIsMyDeviceEnabled) {
        this.thisIsMyDeviceEnabled = thisIsMyDeviceEnabled;
    }

    @ApiModelProperty(position=50, value="The policy fragment to be executed as part of the registration workflow.")
    public ResourceLink getRegistrationWorkflow() {
        return this.registrationWorkflow;
    }

    public void setRegistrationWorkflow(ResourceLink registrationWorkflow) {
        this.registrationWorkflow = registrationWorkflow;
    }

    @ApiModelProperty(position=51, value="This setting indicates whether PingFederate should execute the workflow before or after account creation. The default is to run the registration workflow after account creation.", allowableValues="BEFORE_ACCOUNT_CREATION, AFTER_ACCOUNT_CREATION")
    public ExecuteWorkflowSetting getExecuteWorkflow() {
        return this.executeWorkflow;
    }

    public void setExecuteWorkflow(ExecuteWorkflowSetting executeWorkflow) {
        this.executeWorkflow = executeWorkflow;
    }
}

