/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.moveitem;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.MoveItemRequest;
import com.pingidentity.admin.api.model.fieldpaths.MoveItemRequestPaths;
import com.pingidentity.admin.api.model.moveitem.MoveItemRequestException;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.PolicyMoveException;
import org.sourceid.saml20.domain.mgmt.PolicyMoveToIdException;
import org.sourceid.saml20.domain.mgmt.PolicyMoveToIndexException;

public class PolicyMoveRequestProcessor {
    private static final Log log = LogFactory.getLog(PolicyMoveRequestProcessor.class);
    private final AuthnSelectionConfigManager authnSelectionConfigManager;

    public PolicyMoveRequestProcessor(AuthnSelectionConfigManager authnSelectionConfigManager) {
        this.authnSelectionConfigManager = authnSelectionConfigManager;
    }

    public void doMove(String policyId, MoveItemRequest moveItemRequest) throws MoveItemRequestException {
        try {
            switch (moveItemRequest.getLocation()) {
                case START: {
                    this.authnSelectionConfigManager.moveAuthnSelectionTreeToStart(policyId);
                    break;
                }
                case END: {
                    this.authnSelectionConfigManager.moveAuthnSelectionTreeToEnd(policyId);
                    break;
                }
                case BEFORE: {
                    this.authnSelectionConfigManager.moveAuthnSelectionTree(policyId, moveItemRequest.getMoveToId(), false);
                    break;
                }
                case AFTER: {
                    this.authnSelectionConfigManager.moveAuthnSelectionTree(policyId, moveItemRequest.getMoveToId(), true);
                    break;
                }
                default: {
                    log.error((Object)("Cannot move policy. Unknown move to location: " + moveItemRequest.getLocation()));
                    break;
                }
            }
        }
        catch (PolicyMoveException policyMoveException) {
            ValidationError validationError = this.getValidationErrorForPolicyMoveException(policyMoveException, moveItemRequest);
            throw new MoveItemRequestException((Exception)((Object)policyMoveException), Collections.singletonList(validationError));
        }
    }

    ValidationError getValidationErrorForPolicyMoveException(PolicyMoveException policyMoveException, MoveItemRequest moveItemRequest) {
        if (policyMoveException != null) {
            if (policyMoveException instanceof PolicyMoveToIdException) {
                PolicyMoveToIdException policyMoveToIdException = (PolicyMoveToIdException)policyMoveException;
                return ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_policy_tree_move_invalid_move_to_policy_id, this.getJsonPathForMoveItemRequest(moveItemRequest), new Object[]{policyMoveToIdException.getMoveToPolicyId()});
            }
            if (policyMoveException instanceof PolicyMoveToIndexException) {
                PolicyMoveToIndexException policyMoveToIndexException = (PolicyMoveToIndexException)policyMoveException;
                return ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_policy_tree_move_invalid_target_position, this.getJsonPathForMoveItemRequest(moveItemRequest), new Object[]{policyMoveToIndexException.getMoveToIndex()});
            }
            return ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_policy_tree_move_invalid_policy_id, this.getJsonPathForMoveItemRequest(moveItemRequest), new Object[]{policyMoveException.getPolicyIdToMove()});
        }
        return null;
    }

    private String getJsonPathForMoveItemRequest(MoveItemRequest moveItemRequest) {
        if (moveItemRequest != null) {
            switch (moveItemRequest.getLocation()) {
                case START: 
                case END: {
                    return MoveItemRequestPaths.getLocation();
                }
                case BEFORE: 
                case AFTER: {
                    return MoveItemRequestPaths.moveToId();
                }
            }
            log.debug((Object)("Unrecognized move to location value while determining JSON Path for move item metadata: " + moveItemRequest.getLocation()));
            return null;
        }
        log.debug((Object)"No move item metadata to determine the JSON path for move item metadata.");
        return null;
    }
}

