/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;

public enum AccessTokenMappingType {
    DEFAULT,
    PCV,
    IDP_CONNECTION,
    IDP_ADAPTER,
    AUTHENTICATION_POLICY_CONTRACT,
    CLIENT_CREDENTIALS,
    TOKEN_EXCHANGE_PROCESSOR_POLICY;


    public static AccessTokenMappingType fromContextId(String contextId) {
        AccessTokenMappingType type = null;
        if ("default".equals(contextId)) {
            return DEFAULT;
        }
        if ("client_credentials".equals(contextId)) {
            return CLIENT_CREDENTIALS;
        }
        ContextUtil contextUtil = new ContextUtil();
        ContextUtil.Ctx context = contextUtil.split(contextId);
        OAuthSourceId.Type idType = context.getOAuthSourceId().getType();
        switch (idType) {
            case IDP_CONNECTION: {
                type = IDP_CONNECTION;
                break;
            }
            case APC: {
                type = AUTHENTICATION_POLICY_CONTRACT;
                break;
            }
            case ADAPTER: {
                type = IDP_ADAPTER;
                break;
            }
            case PCV: {
                type = PCV;
                break;
            }
            case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                type = TOKEN_EXCHANGE_PROCESSOR_POLICY;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return type;
    }

    public static String toContextId(AccessTokenMappingType type, String id) {
        String qualifier = null;
        OAuthSourceId sourceId = null;
        switch (type) {
            case DEFAULT: {
                return "default";
            }
            case CLIENT_CREDENTIALS: {
                return "client_credentials";
            }
            case PCV: {
                qualifier = "password";
                sourceId = new OAuthSourceId(OAuthSourceId.Type.PCV, id);
                break;
            }
            case IDP_CONNECTION: {
                qualifier = "authz_req";
                sourceId = new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, id);
                break;
            }
            case IDP_ADAPTER: {
                qualifier = "authz_req";
                sourceId = new OAuthSourceId(OAuthSourceId.Type.ADAPTER, id);
                break;
            }
            case AUTHENTICATION_POLICY_CONTRACT: {
                qualifier = "authz_req";
                sourceId = new OAuthSourceId(OAuthSourceId.Type.APC, id);
                break;
            }
            case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                qualifier = "urn:ietf:params:oauth:grant-type:token-exchange";
                sourceId = new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, id);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ContextUtil contextUtil = new ContextUtil();
        return contextUtil.buildQualifiedId(qualifier, sourceId);
    }
}

