/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.PersistentGrantContract;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalTimeUnit;
import com.pingidentity.admin.api.model.oauth.ScopeEntry;
import com.pingidentity.admin.api.model.oauth.ScopeGroupEntry;
import com.pingidentity.pf.common.api.model.oauth.GrantType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.sourceid.oauth.conf.xmlbinding.OAuthConfigDocument;
import org.sourceid.oauth.conf.xmlbinding.OAuthConfigType;
import org.sourceid.oauth20.domain.ActivationCodeCheckMode;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;

@ApiModel(description="Authorization Server Settings attributes.")
public class AuthorizationServerSettings {
    private static final OAuthConfigType DEFAULT_CONFIG = OAuthConfigDocument.Factory.newInstance().addNewOAuthConfig();
    private String defaultScopeDescription;
    private List<ScopeEntry> scopes;
    private List<ScopeGroupEntry> scopeGroups;
    private List<ScopeEntry> exclusiveScopes;
    private List<ScopeGroupEntry> exclusiveScopeGroups;
    private int authorizationCodeTimeout;
    private int authorizationCodeEntropy;
    private boolean disallowPlainPKCE;
    private boolean includeIssuerInAuthorizationResponse;
    private Long persistentGrantLifetime;
    private PersistentGrantLifetimeUnit persistentGrantLifetimeUnit;
    private Long persistentGrantIdleTimeout;
    private PersistentGrantLifetimeUnit persistentGrantIdleTimeoutTimeUnit;
    private int refreshTokenLength;
    private boolean rollRefreshTokenValues = true;
    private int refreshTokenRollingGracePeriod = DEFAULT_CONFIG.getRefreshTokenRollingGracePeriod();
    private Long refreshRollingInterval;
    private RefreshTokenRollingIntervalTimeUnit refreshRollingIntervalTimeUnit = RefreshTokenRollingIntervalTimeUnit.HOURS;
    private List<GrantType> persistentGrantReuseGrantTypes;
    private PersistentGrantContract persistentGrantContract;
    private boolean bypassAuthorizationForApprovedGrants;
    private boolean allowUnidentifiedClientROCreds;
    private boolean allowUnidentifiedClientExtensionGrants;
    private String tokenEndpointBaseUrl;
    private boolean requireOfflineAccessScopeToIssueRefreshTokens;
    private boolean offlineAccessRequireConsentPrompt;
    private String userAuthorizationUrl = DEFAULT_CONFIG.getUserAuthzUrl();
    private String registeredAuthorizationPath = DEFAULT_CONFIG.getRegisteredAuthzPath();
    private Integer pendingAuthorizationTimeout = DEFAULT_CONFIG.getPendingAuthzTimeout();
    private boolean bypassActivationCodeConfirmation = DEFAULT_CONFIG.getBypassActivationCodeConfirmation();
    private Integer devicePollingInterval = DEFAULT_CONFIG.getDevicePollingInterval();
    private ActivationCodeCheckMode activationCodeCheckMode = ActivationCodeCheckMode.AFTER_AUTHENTICATION;
    private boolean enableCookielessUserAuthorizationAuthenticationApi = DEFAULT_CONFIG.getEnableCookielessUserAuthzAuthnApi();
    private boolean returnIdTokenOnOpenIdWithDeviceAuthzGrant = DEFAULT_CONFIG.getReturnIdTokenOnOpenIdWithDeviceAuthzGrant();
    private UserAuthorizationConsentPageSetting userAuthorizationConsentPageSetting;
    private String userAuthorizationConsentAdapter;
    private String approvedScopesAttribute;
    private String approvedAuthorizationDetailAttribute;
    private ResourceLink adminWebServicePcvRef;
    private String atmIdForOAuthGrantManagement;
    private String scopeForOAuthGrantManagement;
    private List<String> allowedOrigins;
    private Boolean trackUserSessionsForLogout;
    private Integer parReferenceTimeout;
    private Integer parReferenceLength;
    private ParServerPolicy.Status parStatus;
    private Integer clientSecretRetentionPeriod = DEFAULT_CONFIG.getClientSecretRetentionPeriod();
    private Integer jwtSecuredAuthorizationResponseModeLifetime = DEFAULT_CONFIG.getJwtSecuredAuthorizationResponseModeLifetime();
    private boolean dpopProofRequireNonce;
    private Integer dpopProofLifetimeSeconds = DEFAULT_CONFIG.getDpopProofLifetimeSeconds();
    private boolean dpopProofEnforceReplayPrevention;
    private boolean bypassAuthorizationForApprovedConsents;
    private Integer consentLifetimeDays = DEFAULT_CONFIG.getConsentLifetimeDays();

    @ApiModelProperty(position=10, value="The default scope description.")
    public String getDefaultScopeDescription() {
        return this.defaultScopeDescription;
    }

    public void setDefaultScopeDescription(String defaultScopeDescription) {
        this.defaultScopeDescription = defaultScopeDescription;
    }

    @ApiModelProperty(position=20, value="The list of common scopes.")
    public List<ScopeEntry> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<ScopeEntry> scopes) {
        this.scopes = scopes;
    }

    @ApiModelProperty(position=30, value="The list of common scope groups.")
    public List<ScopeGroupEntry> getScopeGroups() {
        return this.scopeGroups;
    }

    public void setScopeGroups(List<ScopeGroupEntry> scopeGroups) {
        this.scopeGroups = scopeGroups;
    }

    @ApiModelProperty(position=40, value="The list of exclusive scopes.")
    public List<ScopeEntry> getExclusiveScopes() {
        return this.exclusiveScopes;
    }

    public void setExclusiveScopes(List<ScopeEntry> exclusiveScopes) {
        this.exclusiveScopes = exclusiveScopes;
    }

    @ApiModelProperty(position=50, value="The list of exclusive scope groups.")
    public List<ScopeGroupEntry> getExclusiveScopeGroups() {
        return this.exclusiveScopeGroups;
    }

    public void setExclusiveScopeGroups(List<ScopeGroupEntry> exclusiveScopeGroups) {
        this.exclusiveScopeGroups = exclusiveScopeGroups;
    }

    @ApiModelProperty(position=60, value="The authorization code timeout, in seconds.", required=true)
    public int getAuthorizationCodeTimeout() {
        return this.authorizationCodeTimeout;
    }

    public void setAuthorizationCodeTimeout(int authorizationCodeTimeout) {
        this.authorizationCodeTimeout = authorizationCodeTimeout;
    }

    @ApiModelProperty(position=70, value="The authorization code entropy, in bytes.", required=true)
    public int getAuthorizationCodeEntropy() {
        return this.authorizationCodeEntropy;
    }

    public void setAuthorizationCodeEntropy(int authorizationCodeEntropy) {
        this.authorizationCodeEntropy = authorizationCodeEntropy;
    }

    @ApiModelProperty(position=80, value="Determines whether PKCE's 'plain' code challenge method will be disallowed. The default value is false.")
    public boolean isDisallowPlainPKCE() {
        return this.disallowPlainPKCE;
    }

    public void setDisallowPlainPKCE(boolean disallowPlainPKCE) {
        this.disallowPlainPKCE = disallowPlainPKCE;
    }

    @ApiModelProperty(position=90, value="Determines whether the authorization server's issuer value is added to the authorization response or not. The default value is false.")
    public boolean isIncludeIssuerInAuthorizationResponse() {
        return this.includeIssuerInAuthorizationResponse;
    }

    public void setIncludeIssuerInAuthorizationResponse(boolean includeIssuerInAuthorizationResponse) {
        this.includeIssuerInAuthorizationResponse = includeIssuerInAuthorizationResponse;
    }

    @ApiModelProperty(position=100, value="Determines whether user sessions are tracked for logout. If this property is not provided on a PUT, the setting is left unchanged.")
    public Boolean isTrackUserSessionsForLogout() {
        return this.trackUserSessionsForLogout;
    }

    public void setTrackUserSessionsForLogout(Boolean trackUserSessionsForLogout) {
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
    }

    @ApiModelProperty(position=110, value="The token endpoint base URL used to validate the 'aud' claim during Private Key JWT Client Authentication.")
    public String getTokenEndpointBaseUrl() {
        return this.tokenEndpointBaseUrl;
    }

    public void setTokenEndpointBaseUrl(String tokenEndpointBaseUrl) {
        this.tokenEndpointBaseUrl = tokenEndpointBaseUrl;
    }

    @ApiModelProperty(position=111, value="Determines whether offline_access scope is required to issue refresh tokens or not. The default value is false.")
    public boolean isRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(boolean requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    @ApiModelProperty(position=112, value="Determines whether offline_access requires the prompt parameter value be 'consent' or not. The value will be reset to default if the 'requireOfflineAccessScopeToIssueRefreshTokens' attribute is set to false. The default value is false.")
    public boolean isOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(boolean offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }

    @ApiModelProperty(position=120, value="The persistent grant lifetime. The default value is indefinite. -1 indicates an indefinite amount of time.")
    public Long getPersistentGrantLifetime() {
        return this.persistentGrantLifetime;
    }

    public void setPersistentGrantLifetime(Long persistentGrantLifetime) {
        this.persistentGrantLifetime = persistentGrantLifetime;
    }

    @ApiModelProperty(position=130, value="The persistent grant lifetime unit.")
    public PersistentGrantLifetimeUnit getPersistentGrantLifetimeUnit() {
        return this.persistentGrantLifetimeUnit;
    }

    public void setPersistentGrantLifetimeUnit(PersistentGrantLifetimeUnit persistentGrantLifetimeUnit) {
        this.persistentGrantLifetimeUnit = persistentGrantLifetimeUnit;
    }

    @ApiModelProperty(position=140, value="The persistent grant idle timeout. The default value is 30 (days). -1 indicates an indefinite amount of time.")
    public Long getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(Long persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    @ApiModelProperty(position=150, value="The persistent grant idle timeout time unit.")
    public PersistentGrantLifetimeUnit getPersistentGrantIdleTimeoutTimeUnit() {
        return this.persistentGrantIdleTimeoutTimeUnit;
    }

    public void setPersistentGrantIdleTimeoutTimeUnit(PersistentGrantLifetimeUnit persistentGrantIdleTimeoutTimeUnit) {
        this.persistentGrantIdleTimeoutTimeUnit = persistentGrantIdleTimeoutTimeUnit;
    }

    @ApiModelProperty(position=160, value="The refresh token length in number of characters.", required=true)
    public int getRefreshTokenLength() {
        return this.refreshTokenLength;
    }

    public void setRefreshTokenLength(int refreshTokenLength) {
        this.refreshTokenLength = refreshTokenLength;
    }

    @ApiModelProperty(position=170, value="The roll refresh token values default policy. The default value is true.")
    public boolean isRollRefreshTokenValues() {
        return this.rollRefreshTokenValues;
    }

    public void setRollRefreshTokenValues(boolean rollRefreshTokenValues) {
        this.rollRefreshTokenValues = rollRefreshTokenValues;
    }

    @ApiModelProperty(position=179, value="The grace period that a rolled refresh token remains valid in seconds. The default value is 60.")
    public int getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(int refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    @ApiModelProperty(position=180, value="The minimum interval to roll refresh tokens.", required=true)
    public Long getRefreshRollingInterval() {
        return this.refreshRollingInterval;
    }

    public void setRefreshRollingInterval(Long refreshRollingInterval) {
        this.refreshRollingInterval = refreshRollingInterval;
    }

    @ApiModelProperty(position=185, value="The refresh token rolling interval time unit. The default unit is HOURS.")
    public RefreshTokenRollingIntervalTimeUnit getRefreshRollingIntervalTimeUnit() {
        return this.refreshRollingIntervalTimeUnit;
    }

    public void setRefreshRollingIntervalTimeUnit(RefreshTokenRollingIntervalTimeUnit refreshRollingIntervalTimeUnit) {
        this.refreshRollingIntervalTimeUnit = refreshRollingIntervalTimeUnit;
    }

    @ApiModelProperty(position=190, value="The grant types that the OAuth AS can reuse rather than creating a new grant for each request. Only 'IMPLICIT' or 'AUTHORIZATION_CODE' or 'RESOURCE_OWNER_CREDENTIALS' are valid grant types.")
    public List<GrantType> getPersistentGrantReuseGrantTypes() {
        return this.persistentGrantReuseGrantTypes;
    }

    public void setPersistentGrantReuseGrantTypes(List<GrantType> reusableGrantTypes) {
        this.persistentGrantReuseGrantTypes = reusableGrantTypes;
    }

    @ApiModelProperty(position=200, value="The persistent grant contract defines attributes that are associated with OAuth persistent grants.")
    public PersistentGrantContract getPersistentGrantContract() {
        return this.persistentGrantContract;
    }

    public void setPersistentGrantContract(PersistentGrantContract persistentGrantContract) {
        this.persistentGrantContract = persistentGrantContract;
    }

    @ApiModelProperty(position=210, value="Bypass authorization for previously approved persistent grants. The default value is false.")
    public boolean isBypassAuthorizationForApprovedGrants() {
        return this.bypassAuthorizationForApprovedGrants;
    }

    public void setBypassAuthorizationForApprovedGrants(boolean bypassAuthorizationForApprovedGrants) {
        this.bypassAuthorizationForApprovedGrants = bypassAuthorizationForApprovedGrants;
    }

    @ApiModelProperty(position=211, value="Bypass authorization for previously approved consents. The default value is false.")
    public boolean isBypassAuthorizationForApprovedConsents() {
        return this.bypassAuthorizationForApprovedConsents;
    }

    public void setBypassAuthorizationForApprovedConsents(boolean bypassAuthorizationForApprovedConsents) {
        this.bypassAuthorizationForApprovedConsents = bypassAuthorizationForApprovedConsents;
    }

    @ApiModelProperty(position=212, value="The consent lifetime in days. The default value is indefinite. -1 indicates an indefinite amount of time.")
    public Integer getConsentLifetimeDays() {
        return this.consentLifetimeDays;
    }

    public void setConsentLifetimeDays(Integer consentLifetimeDays) {
        if (consentLifetimeDays != null) {
            this.consentLifetimeDays = consentLifetimeDays;
        }
    }

    @ApiModelProperty(position=220, value="Allow unidentified clients to request resource owner password credentials grants. The default value is false.")
    public boolean isAllowUnidentifiedClientROCreds() {
        return this.allowUnidentifiedClientROCreds;
    }

    public void setAllowUnidentifiedClientROCreds(boolean allowUnidentifiedClientROCreds) {
        this.allowUnidentifiedClientROCreds = allowUnidentifiedClientROCreds;
    }

    @ApiModelProperty(position=230, value="Allow unidentified clients to request extension grants. The default value is false.")
    public boolean isAllowUnidentifiedClientExtensionGrants() {
        return this.allowUnidentifiedClientExtensionGrants;
    }

    public void setAllowUnidentifiedClientExtensionGrants(boolean allowUnidentifiedClientExtensionGrants) {
        this.allowUnidentifiedClientExtensionGrants = allowUnidentifiedClientExtensionGrants;
    }

    @ApiModelProperty(position=240, value="The password credential validator reference that is used for authenticating access to the OAuth Administrative Web Service.")
    public ResourceLink getAdminWebServicePcvRef() {
        return this.adminWebServicePcvRef;
    }

    public void setAdminWebServicePcvRef(ResourceLink adminWsPcvRef) {
        this.adminWebServicePcvRef = adminWsPcvRef;
    }

    @ApiModelProperty(position=250, value="The ID of the Access Token Manager used for OAuth enabled grant management.")
    public String getAtmIdForOAuthGrantManagement() {
        return this.atmIdForOAuthGrantManagement;
    }

    public void setAtmIdForOAuthGrantManagement(String atmIdForOAuthGrantManagement) {
        this.atmIdForOAuthGrantManagement = atmIdForOAuthGrantManagement;
    }

    @ApiModelProperty(position=260, value="The OAuth scope to validate when accessing grant management service.")
    public String getScopeForOAuthGrantManagement() {
        return this.scopeForOAuthGrantManagement;
    }

    public void setScopeForOAuthGrantManagement(String scopeForOAuthGrantManagement) {
        this.scopeForOAuthGrantManagement = scopeForOAuthGrantManagement;
    }

    @ApiModelProperty(position=270, value="The list of allowed origins.")
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    @ApiModelProperty(position=280, value="The URL used to generate 'verification_url' and 'verification_url_complete' values in a Device Authorization request")
    public String getUserAuthorizationUrl() {
        return this.userAuthorizationUrl;
    }

    public void setUserAuthorizationUrl(String userAuthorizationUrl) {
        this.userAuthorizationUrl = userAuthorizationUrl;
    }

    @ApiModelProperty(position=290, value="The Registered Authorization Path is concatenated to PingFederate base URL to generate 'verification_url' and 'verification_url_complete' values in a Device Authorization request. PingFederate listens to this path if specified")
    public String getRegisteredAuthorizationPath() {
        return this.registeredAuthorizationPath;
    }

    public void setRegisteredAuthorizationPath(String registeredAuthorizationPath) {
        this.registeredAuthorizationPath = registeredAuthorizationPath;
    }

    @ApiModelProperty(position=300, value="The 'device_code' and 'user_code' timeout, in seconds. The default is 600 seconds.")
    public Integer getPendingAuthorizationTimeout() {
        return this.pendingAuthorizationTimeout;
    }

    public void setPendingAuthorizationTimeout(Integer pendingAuthorizationTimeout) {
        this.pendingAuthorizationTimeout = pendingAuthorizationTimeout;
    }

    @ApiModelProperty(position=310, value="The amount of time client should wait between polling requests, in seconds. The default is 5 seconds.")
    public Integer getDevicePollingInterval() {
        return this.devicePollingInterval;
    }

    public void setDevicePollingInterval(Integer devicePollingInterval) {
        this.devicePollingInterval = devicePollingInterval;
    }

    @ApiModelProperty(position=315, value="Determines whether the user is prompted to enter or confirm the activation code after authenticating or before. The default is AFTER_AUTHENTICATION.")
    public ActivationCodeCheckMode getActivationCodeCheckMode() {
        return this.activationCodeCheckMode;
    }

    public void setActivationCodeCheckMode(ActivationCodeCheckMode check) {
        this.activationCodeCheckMode = check;
    }

    @ApiModelProperty(position=320, value="Indicates if the Activation Code Confirmation page should be bypassed if 'verification_url_complete' is used by the end user to authorize a device. The default is false.")
    public boolean isBypassActivationCodeConfirmation() {
        return this.bypassActivationCodeConfirmation;
    }

    public void setBypassActivationCodeConfirmation(boolean bypassActivationCodeConfirmation) {
        this.bypassActivationCodeConfirmation = bypassActivationCodeConfirmation;
    }

    @ApiModelProperty(position=321, value="Indicates if cookies should be used for state tracking when the user authorization endpoint is operating in authentication API redirectless mode")
    public boolean isEnableCookielessUserAuthorizationAuthenticationApi() {
        return this.enableCookielessUserAuthorizationAuthenticationApi;
    }

    public void setEnableCookielessUserAuthorizationAuthenticationApi(boolean enableCookielessUserAuthorizationAuthenticationApi) {
        this.enableCookielessUserAuthorizationAuthenticationApi = enableCookielessUserAuthorizationAuthenticationApi;
    }

    @ApiModelProperty(position=322, value="Indicates if an ID token should be returned during the device authorization grant flow when the 'openid' scope is approved. The default is false.")
    public boolean isReturnIdTokenOnOpenIdWithDeviceAuthzGrant() {
        return this.returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    }

    public void setReturnIdTokenOnOpenIdWithDeviceAuthzGrant(boolean returnIdTokenOnOpenIdWithDeviceAuthzGrant) {
        this.returnIdTokenOnOpenIdWithDeviceAuthzGrant = returnIdTokenOnOpenIdWithDeviceAuthzGrant;
    }

    @ApiModelProperty(position=330, value="User Authorization Consent Page setting to use PingFederate's internal consent page or an external system")
    public UserAuthorizationConsentPageSetting getUserAuthorizationConsentPageSetting() {
        return this.userAuthorizationConsentPageSetting;
    }

    public void setUserAuthorizationConsentPageSetting(UserAuthorizationConsentPageSetting userAuthorizationConsentPageSetting) {
        this.userAuthorizationConsentPageSetting = userAuthorizationConsentPageSetting;
    }

    @ApiModelProperty(position=340, value="Adapter ID of the external consent adapter to be used for the consent page user interface.")
    public String getUserAuthorizationConsentAdapter() {
        return this.userAuthorizationConsentAdapter;
    }

    public void setUserAuthorizationConsentAdapter(String userAuthorizationConsentAdapter) {
        this.userAuthorizationConsentAdapter = userAuthorizationConsentAdapter;
    }

    @ApiModelProperty(position=350, value="Attribute from the external consent adapter's contract, intended for storing approved scopes returned by the external consent page.")
    public String getApprovedScopesAttribute() {
        return this.approvedScopesAttribute;
    }

    public void setApprovedScopesAttribute(String approvedScopesAttribute) {
        this.approvedScopesAttribute = approvedScopesAttribute;
    }

    @ApiModelProperty(position=355, value="Attribute from the external consent adapter's contract, intended for storing approved authorization details returned by the external consent page.")
    public String getApprovedAuthorizationDetailAttribute() {
        return this.approvedAuthorizationDetailAttribute;
    }

    public void setApprovedAuthorizationDetailAttribute(String approvedAuthorizationDetailAttribute) {
        this.approvedAuthorizationDetailAttribute = approvedAuthorizationDetailAttribute;
    }

    @ApiModelProperty(position=360, value="The timeout, in seconds, of the pushed authorization request reference. The default value is 60.")
    public Integer getParReferenceTimeout() {
        return this.parReferenceTimeout;
    }

    public void setParReferenceTimeout(Integer parReferenceTimeout) {
        this.parReferenceTimeout = parReferenceTimeout;
    }

    @ApiModelProperty(position=370, value="The entropy of pushed authorization request references, in bytes. The default value is 24.")
    public Integer getParReferenceLength() {
        return this.parReferenceLength;
    }

    public void setParReferenceLength(Integer parReferenceLength) {
        this.parReferenceLength = parReferenceLength;
    }

    @ApiModelProperty(position=380, value="The status of pushed authorization request support. The default value is ENABLED.", allowableValues="DISABLED, ENABLED, REQUIRED")
    public ParServerPolicy.Status getParStatus() {
        return this.parStatus;
    }

    public void setParStatus(ParServerPolicy.Status parStatus) {
        this.parStatus = parStatus;
    }

    @ApiModelProperty(position=390, value="The length of time in minutes that client secrets will be retained as secondary secrets after secret change. The default value is 0, which will disable secondary client secret retention.")
    public Integer getClientSecretRetentionPeriod() {
        return this.clientSecretRetentionPeriod;
    }

    public void setClientSecretRetentionPeriod(Integer clientSecretRetentionPeriod) {
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
    }

    @ApiModelProperty(position=400, value="The lifetime, in seconds, of the JWT Secured authorization response. The default value is 600.")
    public Integer getJwtSecuredAuthorizationResponseModeLifetime() {
        return this.jwtSecuredAuthorizationResponseModeLifetime;
    }

    public void setJwtSecuredAuthorizationResponseModeLifetime(Integer jwtSecuredAuthorizationResponseModeLifetime) {
        this.jwtSecuredAuthorizationResponseModeLifetime = jwtSecuredAuthorizationResponseModeLifetime;
    }

    @ApiModelProperty(position=410, value="Determines whether nonce is required in the Demonstrating Proof-of-Possession (DPoP) proof JWT. The default value is false.")
    public boolean isDpopProofRequireNonce() {
        return this.dpopProofRequireNonce;
    }

    public void setDpopProofRequireNonce(boolean dpopProofRequireNonce) {
        this.dpopProofRequireNonce = dpopProofRequireNonce;
    }

    @ApiModelProperty(position=411, value="The lifetime, in seconds, of the Demonstrating Proof-of-Possession (DPoP) proof JWT. The default value is 120.")
    public Integer getDpopProofLifetimeSeconds() {
        return this.dpopProofLifetimeSeconds;
    }

    public void setDpopProofLifetimeSeconds(Integer dpopProofLifetimeSeconds) {
        if (dpopProofLifetimeSeconds != null) {
            this.dpopProofLifetimeSeconds = dpopProofLifetimeSeconds;
        }
    }

    @ApiModelProperty(position=412, value="Determines whether Demonstrating Proof-of-Possession (DPoP) proof JWT replay prevention is enforced. The default value is false.")
    public boolean isDpopProofEnforceReplayPrevention() {
        return this.dpopProofEnforceReplayPrevention;
    }

    public void setDpopProofEnforceReplayPrevention(boolean dpopProofEnforceReplayPrevention) {
        this.dpopProofEnforceReplayPrevention = dpopProofEnforceReplayPrevention;
    }
}

