/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.CibaDeliveryMode;
import com.pingidentity.admin.api.model.oauth.CibaRequestObjectSigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.ClientAuth;
import com.pingidentity.admin.api.model.oauth.ClientOIDCPolicy;
import com.pingidentity.admin.api.model.oauth.ClientSecretRetentionPeriodType;
import com.pingidentity.admin.api.model.oauth.ContentEncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.DeviceFlowSettingType;
import com.pingidentity.admin.api.model.oauth.EncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.JwksSettings;
import com.pingidentity.admin.api.model.oauth.JwtSecuredAuthorizationResponseModeSigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.LockoutMaxMaliciousActionsType;
import com.pingidentity.admin.api.model.oauth.OfflineAccessRequireConsentPromptType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.model.oauth.PersistentGrantReuseType;
import com.pingidentity.admin.api.model.oauth.RefreshRollingType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingGracePeriodType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalTimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalType;
import com.pingidentity.admin.api.model.oauth.RequestObjectSigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.RequireOfflineAccessScopeToIssueRefreshTokensType;
import com.pingidentity.admin.api.model.oauth.TokenIntrospectionSigningAlgorithm;
import com.pingidentity.pf.common.api.model.oauth.GrantType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sourceid.saml20.domain.ItemReplicationStatus;

@ApiModel(description="OAuth client.")
public class Client {
    private String clientId;
    private Boolean enabled = null;
    private List<String> redirectUris = new ArrayList<String>();
    private Set<GrantType> grantTypes = new TreeSet<GrantType>();
    private String name;
    private String description;
    private String logoUrl;
    private Date modificationDate;
    private Date creationDate;
    private ItemReplicationStatus replicationStatus;
    private RefreshRollingType refreshRolling = RefreshRollingType.SERVER_DEFAULT;
    private RefreshTokenRollingIntervalType refreshTokenRollingIntervalType = RefreshTokenRollingIntervalType.SERVER_DEFAULT;
    private Long refreshTokenRollingInterval;
    private RefreshTokenRollingIntervalTimeUnit refreshTokenRollingIntervalTimeUnit;
    private PersistentGrantLifetimeType persistentGrantExpirationType = PersistentGrantLifetimeType.SERVER_DEFAULT;
    private Long persistentGrantExpirationTime;
    private PersistentGrantLifetimeUnit persistentGrantExpirationTimeUnit = PersistentGrantLifetimeUnit.DAYS;
    private PersistentGrantLifetimeType persistentGrantIdleTimeoutType = PersistentGrantLifetimeType.SERVER_DEFAULT;
    private Long persistentGrantIdleTimeout;
    private PersistentGrantLifetimeUnit persistentGrantIdleTimeoutTimeUnit = PersistentGrantLifetimeUnit.DAYS;
    private PersistentGrantReuseType persistentGrantReuseType = PersistentGrantReuseType.SERVER_DEFAULT;
    private Set<GrantType> persistentGrantReuseGrantTypes;
    private boolean allowAuthenticationApiInit;
    private boolean enableCookielessAuthenticationApi;
    private boolean bypassApprovalPage;
    private boolean restrictScopes;
    private boolean isRequireSignedRequests;
    private boolean requirePushedAuthorizationRequests;
    private boolean requireJwtSecuredAuthorizationResponseMode;
    private RequestObjectSigningAlgorithm requestObjectSigningAlgorithm;
    private Set<String> restrictedScopes = new TreeSet<String>();
    private Set<String> exclusiveScopes = new TreeSet<String>();
    private Set<String> restrictedResponseTypes = new TreeSet<String>();
    private Set<String> authorizationDetailTypes = new TreeSet<String>();
    private ResourceLink defaultAccessTokenManagerRef;
    private boolean restrictToDefaultAccessTokenManager = false;
    private boolean validateUsingAllEligibleAtms;
    private ClientOIDCPolicy oidcPolicy;
    private ClientAuth clientAuth;
    private JwksSettings jwksSettings;
    private Map<String, ParameterValues> extendedParameters = new HashMap<String, ParameterValues>();
    private DeviceFlowSettingType deviceFlowSettingType = DeviceFlowSettingType.SERVER_DEFAULT;
    private String userAuthorizationUrlOverride;
    private Integer pendingAuthorizationTimeoutOverride;
    private Integer devicePollingIntervalOverride;
    private Boolean bypassActivationCodeConfirmationOverride = null;
    private Boolean requireProofKeyForCodeExchange;
    private CibaDeliveryMode cibaDeliveryMode;
    private String cibaNotificationEndpoint;
    private Integer cibaPollingInterval;
    private Boolean cibaRequireSignedRequests;
    private Boolean cibaUserCodeSupported;
    private CibaRequestObjectSigningAlgorithm cibaRequestObjectSigningAlgorithm;
    private ResourceLink requestPolicyRef;
    private ResourceLink TokenExchangeProcessorPolicyRef;
    private RefreshTokenRollingGracePeriodType refreshTokenRollingGracePeriodType = RefreshTokenRollingGracePeriodType.SERVER_DEFAULT;
    private Integer refreshTokenRollingGracePeriod;
    private ClientSecretRetentionPeriodType clientSecretRetentionPeriodType = ClientSecretRetentionPeriodType.SERVER_DEFAULT;
    private Integer clientSecretRetentionPeriod;
    private Date clientSecretChangedTime;
    private TokenIntrospectionSigningAlgorithm tokenIntrospectionSigningAlgorithm;
    private EncryptionAlgorithm tokenIntrospectionEncryptionAlgorithm;
    private ContentEncryptionAlgorithm tokenIntrospectionContentEncryptionAlgorithm;
    private JwtSecuredAuthorizationResponseModeSigningAlgorithm jwtSecuredAuthorizationResponseModeSigningAlgorithm;
    private EncryptionAlgorithm jwtSecuredAuthorizationResponseModeEncryptionAlgorithm;
    private ContentEncryptionAlgorithm jwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm;
    private boolean requireDpop;
    private RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokens = RequireOfflineAccessScopeToIssueRefreshTokensType.SERVER_DEFAULT;
    private OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPrompt = OfflineAccessRequireConsentPromptType.SERVER_DEFAULT;
    private LockoutMaxMaliciousActionsType lockoutMaxMaliciousActionsType = LockoutMaxMaliciousActionsType.SERVER_DEFAULT;
    private Integer lockoutMaxMaliciousActions;

    @ApiModelProperty(position=10, value="A unique identifier the client provides to the Resource Server to identify itself. This identifier is included with every request the client makes. For PUT requests, this field is optional and it will be overridden by the 'id' parameter of the PUT request.", required=true)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ApiModelProperty(position=15, value="Specifies whether the client is enabled. The default value is true.")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(position=20, value="URIs to which the OAuth AS may redirect the resource owner's user agent after authorization is obtained. A redirection URI is used with the Authorization Code and Implicit grant types. Wildcards are allowed. However, for security reasons, make the URL as restrictive as possible.For example: https://*.company.com/* Important: If more than one URI is added or if a single URI uses wildcards, then Authorization Code grant and token requests must contain a specific matching redirect uri parameter.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        if (redirectUris == null) {
            this.redirectUris.clear();
        } else {
            this.redirectUris = redirectUris;
        }
    }

    @ApiModelProperty(position=30, value="The grant types allowed for this client. The EXTENSION grant type applies to SAML/JWT assertion grants.", required=true)
    public Set<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<GrantType> grantTypes) {
        if (grantTypes == null) {
            this.grantTypes.clear();
        } else {
            this.grantTypes = grantTypes;
        }
    }

    @ApiModelProperty(position=40, value="A descriptive name for the client instance. This name appears when the user is prompted for authorization.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=50, value="A description of what the client application does. This description appears when the user is prompted for authorization.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(position=55, value="The time at which the client was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getModificationDate() {
        if (this.modificationDate == null) {
            return null;
        }
        return new Date(this.modificationDate.getTime());
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate == null ? null : new Date(modificationDate.getTime());
    }

    @ApiModelProperty(position=56, value="The time at which the client was created. This property is read only and is ignored on PUT and POST requests.")
    public Date getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return new Date(this.creationDate.getTime());
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate == null ? null : new Date(creationDate.getTime());
    }

    @ApiModelProperty(position=57, value="This status indicates whether the client has been replicated to the cluster. This property only applies when using XML client storage and automatic replication of clients is enabled. It is read only and is ignored on PUT and POST requests.")
    public ItemReplicationStatus getReplicationStatus() {
        return this.replicationStatus;
    }

    public void setReplicationStatus(ItemReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
    }

    @ApiModelProperty(position=60, value="The location of the logo used on user-facing OAuth grant authorization and revocation pages.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    @ApiModelProperty(position=65, value="The default access token manager for this client.")
    public ResourceLink getDefaultAccessTokenManagerRef() {
        return this.defaultAccessTokenManagerRef;
    }

    public void setDefaultAccessTokenManagerRef(ResourceLink defaultAccessTokenManagerRef) {
        this.defaultAccessTokenManagerRef = defaultAccessTokenManagerRef;
    }

    @ApiModelProperty(position=67, value="Determines whether the client is restricted to using only its default access token manager. The default is false.")
    public boolean isRestrictToDefaultAccessTokenManager() {
        return this.restrictToDefaultAccessTokenManager;
    }

    public void setRestrictToDefaultAccessTokenManager(boolean restrict) {
        this.restrictToDefaultAccessTokenManager = restrict;
    }

    @ApiModelProperty(position=68, value="Validates token using all eligible access token managers for the client. This setting is ignored if 'restrictToDefaultAccessTokenManager' is set to true.")
    public boolean isValidateUsingAllEligibleAtms() {
        return this.validateUsingAllEligibleAtms;
    }

    public void setValidateUsingAllEligibleAtms(boolean validateUsingAllEligibleAtms) {
        this.validateUsingAllEligibleAtms = validateUsingAllEligibleAtms;
    }

    @ApiModelProperty(position=70, value="Use ROLL or DONT_ROLL to override the Roll Refresh Token Values setting on the Authorization Server Settings. SERVER_DEFAULT will default to the Roll Refresh Token Values setting on the Authorization Server Setting screen. Defaults to SERVER_DEFAULT.")
    public RefreshRollingType getRefreshRolling() {
        return this.refreshRolling;
    }

    public void setRefreshRolling(RefreshRollingType refreshRolling) {
        if (refreshRolling != null) {
            this.refreshRolling = refreshRolling;
        }
    }

    @ApiModelProperty(position=73, value="Use OVERRIDE_SERVER_DEFAULT to override the Refresh Token Rolling Interval value on the Authorization Server Settings. SERVER_DEFAULT will default to the Refresh Token Rolling Interval value on the Authorization Server Setting. Defaults to SERVER_DEFAULT.")
    public RefreshTokenRollingIntervalType getRefreshTokenRollingIntervalType() {
        return this.refreshTokenRollingIntervalType;
    }

    public void setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType refreshTokenRollingIntervalType) {
        this.refreshTokenRollingIntervalType = refreshTokenRollingIntervalType;
    }

    @ApiModelProperty(position=74, value="The minimum interval to roll refresh tokens. This value will override the Refresh Token Rolling Interval Value on the Authorization Server Settings.")
    public Long getRefreshTokenRollingInterval() {
        return this.refreshTokenRollingInterval;
    }

    public void setRefreshTokenRollingInterval(Long refreshTokenRollingInterval) {
        this.refreshTokenRollingInterval = refreshTokenRollingInterval;
    }

    @ApiModelProperty(position=75, value="The refresh token rolling interval time unit. Defaults to HOURS.")
    public RefreshTokenRollingIntervalTimeUnit getRefreshTokenRollingIntervalTimeUnit() {
        return this.refreshTokenRollingIntervalTimeUnit;
    }

    public void setRefreshTokenRollingIntervalTimeUnit(RefreshTokenRollingIntervalTimeUnit refreshTokenRollingIntervalTimeUnit) {
        this.refreshTokenRollingIntervalTimeUnit = refreshTokenRollingIntervalTimeUnit;
    }

    @ApiModelProperty(position=80, value="Allows an administrator to override the Persistent Grant Lifetime set globally for the OAuth AS. Defaults to SERVER_DEFAULT.")
    public PersistentGrantLifetimeType getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(PersistentGrantLifetimeType persistentGrantExpirationType) {
        if (persistentGrantExpirationType != null) {
            this.persistentGrantExpirationType = persistentGrantExpirationType;
        }
    }

    @ApiModelProperty(position=90, value="The persistent grant expiration time. -1 indicates an indefinite amount of time.")
    public Long getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(Long persistentGrantExpirationTime) {
        if (persistentGrantExpirationTime != null) {
            this.persistentGrantExpirationTime = persistentGrantExpirationTime;
        }
    }

    @ApiModelProperty(position=100, value="The persistent grant expiration time unit.")
    public PersistentGrantLifetimeUnit getPersistentGrantExpirationTimeUnit() {
        return this.persistentGrantExpirationTimeUnit;
    }

    public void setPersistentGrantExpirationTimeUnit(PersistentGrantLifetimeUnit persistentGrantExpirationTimeUnit) {
        this.persistentGrantExpirationTimeUnit = persistentGrantExpirationTimeUnit;
    }

    @ApiModelProperty(position=101, value="Allows an administrator to override the Persistent Grant Idle Timeout set globally for the OAuth AS. Defaults to SERVER_DEFAULT.")
    public PersistentGrantLifetimeType getPersistentGrantIdleTimeoutType() {
        return this.persistentGrantIdleTimeoutType;
    }

    public void setPersistentGrantIdleTimeoutType(PersistentGrantLifetimeType persistentGrantIdleTimeoutType) {
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
    }

    @ApiModelProperty(position=102, value="The persistent grant idle timeout.")
    public Long getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(Long persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    @ApiModelProperty(position=103, value="The persistent grant idle timeout time unit.")
    public PersistentGrantLifetimeUnit getPersistentGrantIdleTimeoutTimeUnit() {
        return this.persistentGrantIdleTimeoutTimeUnit;
    }

    public void setPersistentGrantIdleTimeoutTimeUnit(PersistentGrantLifetimeUnit persistentGrantIdleTimeoutTimeUnit) {
        this.persistentGrantIdleTimeoutTimeUnit = persistentGrantIdleTimeoutTimeUnit;
    }

    @ApiModelProperty(position=104, value="Allows and administrator to override the Reuse Existing Persistent Access Grants for Grant Types set globally for OAuth AS. Defaults to SERVER_DEFAULT.")
    public PersistentGrantReuseType getPersistentGrantReuseType() {
        return this.persistentGrantReuseType;
    }

    public void setPersistentGrantReuseType(PersistentGrantReuseType persistentGrantReuseType) {
        this.persistentGrantReuseType = persistentGrantReuseType;
    }

    @ApiModelProperty(position=105, value="The grant types that the OAuth AS can reuse rather than creating a new grant for each request. This value will override the Reuse Existing Persistent Access Grants for Grant Types on the Authorization Server Settings. Only 'IMPLICIT' or 'AUTHORIZATION_CODE' or 'RESOURCE_OWNER_CREDENTIALS' are valid grant types.")
    public Set<GrantType> getPersistentGrantReuseGrantTypes() {
        return this.persistentGrantReuseGrantTypes;
    }

    public void setPersistentGrantReuseGrantTypes(Set<GrantType> reusableGrantTypes) {
        if (reusableGrantTypes == null) {
            if (this.persistentGrantReuseGrantTypes != null) {
                this.persistentGrantReuseGrantTypes.clear();
            }
        } else {
            this.persistentGrantReuseGrantTypes = reusableGrantTypes;
        }
    }

    @ApiModelProperty(position=107, value="Set to true to allow this client to initiate the authentication API redirectless flow.")
    public boolean isAllowAuthenticationApiInit() {
        return this.allowAuthenticationApiInit;
    }

    public void setAllowAuthenticationApiInit(boolean allowAuthenticationApiInit) {
        this.allowAuthenticationApiInit = allowAuthenticationApiInit;
    }

    @ApiModelProperty(position=108, value="Set to true to allow the authentication API redirectless flow to function without requiring any cookies.")
    public boolean isEnableCookielessAuthenticationApi() {
        return this.enableCookielessAuthenticationApi;
    }

    public void setEnableCookielessAuthenticationApi(boolean enableCookielessAuthenticationApi) {
        this.enableCookielessAuthenticationApi = enableCookielessAuthenticationApi;
    }

    @ApiModelProperty(position=110, value="Use this setting, for example, when you want to deploy a trusted application and authenticate end users via an IdP adapter or IdP connection.")
    public boolean isBypassApprovalPage() {
        return this.bypassApprovalPage;
    }

    public void setBypassApprovalPage(boolean bypassApprovalPage) {
        this.bypassApprovalPage = bypassApprovalPage;
    }

    @ApiModelProperty(position=120, value="Restricts this client's access to specific scopes.")
    public boolean isRestrictScopes() {
        return this.restrictScopes;
    }

    public void setRestrictScopes(boolean restrictScopes) {
        this.restrictScopes = restrictScopes;
    }

    @ApiModelProperty(position=130, value="The scopes available for this client.")
    public Set<String> getRestrictedScopes() {
        return this.restrictedScopes;
    }

    public void setRestrictedScopes(Set<String> restrictedScopes) {
        if (restrictedScopes == null) {
            this.restrictedScopes.clear();
        } else {
            this.restrictedScopes = restrictedScopes;
        }
    }

    @ApiModelProperty(position=150, value="The exclusive scopes available for this client.")
    public Set<String> getExclusiveScopes() {
        return this.exclusiveScopes;
    }

    public void setAllowExclusiveScopes(Set<String> exclusiveScopes) {
        if (exclusiveScopes == null) {
            this.exclusiveScopes.clear();
        } else {
            this.exclusiveScopes = exclusiveScopes;
        }
    }

    @ApiModelProperty(position=152, value="The authorization detail types available for this client.")
    public Set<String> getAuthorizationDetailTypes() {
        return this.authorizationDetailTypes;
    }

    public void setAuthorizationDetailTypes(Set<String> authorizationDetailTypes) {
        if (authorizationDetailTypes == null) {
            this.authorizationDetailTypes.clear();
        } else {
            this.authorizationDetailTypes = authorizationDetailTypes;
        }
    }

    @ApiModelProperty(position=155, value="The response types allowed for this client. If omitted all response types are available to the client.")
    public Set<String> getRestrictedResponseTypes() {
        return this.restrictedResponseTypes;
    }

    public void setRestrictedResponseTypes(Set<String> restrictedResponseTypes) {
        if (restrictedResponseTypes == null) {
            this.restrictedResponseTypes.clear();
        } else {
            this.restrictedResponseTypes = restrictedResponseTypes;
        }
    }

    @ApiModelProperty(position=158, value="Determines whether pushed authorization requests are required when initiating an authorization request. The default is false.")
    public boolean isRequirePushedAuthorizationRequests() {
        return this.requirePushedAuthorizationRequests;
    }

    public void setRequirePushedAuthorizationRequests(boolean requirePushedAuthorizationRequests) {
        this.requirePushedAuthorizationRequests = requirePushedAuthorizationRequests;
    }

    @ApiModelProperty(position=159, value="Determines whether JWT Secured authorization response mode is required when initiating an authorization request. The default is false.")
    public boolean isRequireJwtSecuredAuthorizationResponseMode() {
        return this.requireJwtSecuredAuthorizationResponseMode;
    }

    public void setRequireJwtSecuredAuthorizationResponseMode(boolean requireJwtSecuredAuthorizationResponseMode) {
        this.requireJwtSecuredAuthorizationResponseMode = requireJwtSecuredAuthorizationResponseMode;
    }

    @ApiModelProperty(position=160, value="Determines whether signed requests are required for this client")
    public boolean isRequireSignedRequests() {
        return this.isRequireSignedRequests;
    }

    public void setRequireSignedRequests(boolean requireSignedRequests) {
        this.isRequireSignedRequests = requireSignedRequests;
    }

    @ApiModelProperty(position=161, value="The JSON Web Signature [JWS] algorithm that must be used to sign the Request Object. All signing algorithms are allowed if value is not present <br>RS256 - RSA using SHA-256<br>RS384 - RSA using SHA-384<br>RS512 - RSA using SHA-512<br>ES256 - ECDSA using P256 Curve and SHA-256<br>ES384 - ECDSA using P384 Curve and SHA-384<br>ES512 - ECDSA using P521 Curve and SHA-512<br>PS256 - RSASSA-PSS using SHA-256 and MGF1 padding with SHA-256<br>PS384 - RSASSA-PSS using SHA-384 and MGF1 padding with SHA-384<br>PS512 - RSASSA-PSS using SHA-512 and MGF1 padding with SHA-512<br>RSASSA-PSS is only supported with Thales Luna, Entrust nShield Connect or Java 11.")
    public RequestObjectSigningAlgorithm getRequestObjectSigningAlgorithm() {
        return this.requestObjectSigningAlgorithm;
    }

    public void setRequestObjectSigningAlgorithm(RequestObjectSigningAlgorithm requestObjectSigningAlgorithm) {
        this.requestObjectSigningAlgorithm = requestObjectSigningAlgorithm;
    }

    @ApiModelProperty(position=170, value="Open ID Connect Policy settings.  This is included in the message only when OIDC is enabled.")
    public ClientOIDCPolicy getOidcPolicy() {
        return this.oidcPolicy;
    }

    public void setOidcPolicy(ClientOIDCPolicy oidcPolicy) {
        this.oidcPolicy = oidcPolicy;
    }

    @ApiModelProperty(position=180, value="Client authentication settings.  If this model is null, it indicates that no client authentication will be used.")
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    @ApiModelProperty(position=190, value="JSON Web Key Set Settings of the OAuth client. Required if private key JWT client authentication or signed requests is enabled.")
    public JwksSettings getJwksSettings() {
        return this.jwksSettings;
    }

    public void setJwksSettings(JwksSettings jwksSettings) {
        this.jwksSettings = jwksSettings;
    }

    @ApiModelProperty(position=200, value="OAuth Client Metadata can be extended to use custom Client Metadata Parameters. The names of these custom parameters should be defined in /extendedProperties.")
    public Map<String, ParameterValues> getExtendedParameters() {
        return this.extendedParameters;
    }

    public void setExtendedParameters(Map<String, ParameterValues> extendedParameters) {
        this.extendedParameters = extendedParameters;
    }

    @ApiModelProperty(position=300, value="Allows an administrator to override the Device Authorization Settings set globally for the OAuth AS. Defaults to SERVER_DEFAULT.")
    public DeviceFlowSettingType getDeviceFlowSettingType() {
        return this.deviceFlowSettingType;
    }

    public void setDeviceFlowSettingType(DeviceFlowSettingType deviceFlowSettingType) {
        this.deviceFlowSettingType = deviceFlowSettingType;
    }

    @ApiModelProperty(position=310, value="The URL used as 'verification_url' and 'verification_url_complete' values in a Device Authorization request. This property overrides the 'userAuthorizationUrl' value present in Authorization Server Settings.")
    public String getUserAuthorizationUrlOverride() {
        return this.userAuthorizationUrlOverride;
    }

    public void setUserAuthorizationUrlOverride(String userAuthorizationUrlOverride) {
        this.userAuthorizationUrlOverride = userAuthorizationUrlOverride;
    }

    @ApiModelProperty(position=320, value="The 'device_code' and 'user_code' timeout, in seconds. This overrides the 'pendingAuthorizationTimeout' value present in Authorization Server Settings.")
    public Integer getPendingAuthorizationTimeoutOverride() {
        return this.pendingAuthorizationTimeoutOverride;
    }

    public void setPendingAuthorizationTimeoutOverride(Integer pendingAuthorizationTimeoutOverride) {
        this.pendingAuthorizationTimeoutOverride = pendingAuthorizationTimeoutOverride;
    }

    @ApiModelProperty(position=330, value="The amount of time client should wait between polling requests, in seconds. This overrides the 'devicePollingInterval' value present in Authorization Server Settings.")
    public Integer getDevicePollingIntervalOverride() {
        return this.devicePollingIntervalOverride;
    }

    public void setDevicePollingIntervalOverride(Integer devicePollingIntervalOverride) {
        this.devicePollingIntervalOverride = devicePollingIntervalOverride;
    }

    @ApiModelProperty(position=340, value="Indicates if the Activation Code Confirmation page should be bypassed if 'verification_url_complete' is used by the end user to authorize a device. This overrides the 'bypassUseCodeConfirmation' value present in Authorization Server Settings.")
    public Boolean getBypassActivationCodeConfirmationOverride() {
        return this.bypassActivationCodeConfirmationOverride;
    }

    public void setBypassActivationCodeConfirmationOverride(Boolean bypassActivationCodeConfirmationOverride) {
        this.bypassActivationCodeConfirmationOverride = bypassActivationCodeConfirmationOverride;
    }

    @ApiModelProperty(position=400, value="Determines whether Proof Key for Code Exchange (PKCE) is required for this client.")
    public Boolean getRequireProofKeyForCodeExchange() {
        return this.requireProofKeyForCodeExchange;
    }

    public void setRequireProofKeyForCodeExchange(Boolean requireProofKeyForCodeExchange) {
        this.requireProofKeyForCodeExchange = requireProofKeyForCodeExchange;
    }

    @ApiModelProperty(position=410, value="The token delivery mode for the client.  The default value is 'POLL'.")
    public CibaDeliveryMode getCibaDeliveryMode() {
        return this.cibaDeliveryMode;
    }

    public void setCibaDeliveryMode(CibaDeliveryMode cibaDeliveryMode) {
        this.cibaDeliveryMode = cibaDeliveryMode;
    }

    @ApiModelProperty(position=420, value="The endpoint the OP will call after a successful or failed end-user authentication.")
    public String getCibaNotificationEndpoint() {
        return this.cibaNotificationEndpoint;
    }

    public void setCibaNotificationEndpoint(String cibaNotificationEndpoint) {
        this.cibaNotificationEndpoint = cibaNotificationEndpoint;
    }

    @ApiModelProperty(position=430, value="The minimum amount of time in seconds that the Client must wait between polling requests to the token endpoint. The default is 3 seconds.")
    public Integer getCibaPollingInterval() {
        return this.cibaPollingInterval;
    }

    public void setCibaPollingInterval(Integer cibaPollingInterval) {
        this.cibaPollingInterval = cibaPollingInterval;
    }

    @ApiModelProperty(position=440, value="Determines whether CIBA signed requests are required for this client.")
    public Boolean isCibaRequireSignedRequests() {
        return this.cibaRequireSignedRequests;
    }

    public void setCibaRequireSignedRequests(Boolean cibaRequireSignedRequests) {
        this.cibaRequireSignedRequests = cibaRequireSignedRequests;
    }

    @ApiModelProperty(position=441, value="The JSON Web Signature [JWS] algorithm that must be used to sign the CIBA Request Object. All signing algorithms are allowed if value is not present <br>RS256 - RSA using SHA-256<br>RS384 - RSA using SHA-384<br>RS512 - RSA using SHA-512<br>ES256 - ECDSA using P256 Curve and SHA-256<br>ES384 - ECDSA using P384 Curve and SHA-384<br>ES512 - ECDSA using P521 Curve and SHA-512<br>PS256 - RSASSA-PSS using SHA-256 and MGF1 padding with SHA-256<br>PS384 - RSASSA-PSS using SHA-384 and MGF1 padding with SHA-384<br>PS512 - RSASSA-PSS using SHA-512 and MGF1 padding with SHA-512<br>RSASSA-PSS is only supported with Thales Luna, Entrust nShield Connect or Java 11.")
    public CibaRequestObjectSigningAlgorithm getCibaRequestObjectSigningAlgorithm() {
        return this.cibaRequestObjectSigningAlgorithm;
    }

    public void setCibaRequestObjectSigningAlgorithm(CibaRequestObjectSigningAlgorithm cibaRequestObjectSigningAlgorithm) {
        this.cibaRequestObjectSigningAlgorithm = cibaRequestObjectSigningAlgorithm;
    }

    @ApiModelProperty(position=450, value="Determines whether CIBA user code is supported for this client.")
    public Boolean isCibaUserCodeSupported() {
        return this.cibaUserCodeSupported;
    }

    public void setCibaUserCodeSupported(Boolean cibaUserCodeSupported) {
        this.cibaUserCodeSupported = cibaUserCodeSupported;
    }

    @ApiModelProperty(position=451, value="The CIBA request policy.")
    public ResourceLink getRequestPolicyRef() {
        return this.requestPolicyRef;
    }

    public void setRequestPolicyRef(ResourceLink requestPolicyRef) {
        this.requestPolicyRef = requestPolicyRef;
    }

    @ApiModelProperty(position=460, value="The Token Exchange Processor policy.")
    public ResourceLink getTokenExchangeProcessorPolicyRef() {
        return this.TokenExchangeProcessorPolicyRef;
    }

    public void setTokenExchangeProcessorPolicyRef(ResourceLink tokenExchangeProcessorPolicyRef) {
        this.TokenExchangeProcessorPolicyRef = tokenExchangeProcessorPolicyRef;
    }

    @ApiModelProperty(position=470, value="When specified, it overrides the global Refresh Token Grace Period defined in the Authorization Server Settings. The default value is SERVER_DEFAULT")
    public RefreshTokenRollingGracePeriodType getRefreshTokenRollingGracePeriodType() {
        return this.refreshTokenRollingGracePeriodType;
    }

    public void setRefreshTokenRollingGracePeriodType(RefreshTokenRollingGracePeriodType refreshTokenRollingGracePeriodType) {
        this.refreshTokenRollingGracePeriodType = refreshTokenRollingGracePeriodType;
    }

    @ApiModelProperty(position=471, value="The grace period that a rolled refresh token remains valid in seconds.")
    public Integer getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(Integer refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    @ApiModelProperty(position=480, value="Use OVERRIDE_SERVER_DEFAULT to override the Client Secret Retention Period value on the Authorization Server Settings. SERVER_DEFAULT will default to the Client Secret Retention Period value on the Authorization Server Setting. Defaults to SERVER_DEFAULT.")
    public ClientSecretRetentionPeriodType getClientSecretRetentionPeriodType() {
        return this.clientSecretRetentionPeriodType;
    }

    public void setClientSecretRetentionPeriodType(ClientSecretRetentionPeriodType clientSecretRetentionPeriodType) {
        this.clientSecretRetentionPeriodType = clientSecretRetentionPeriodType;
    }

    @ApiModelProperty(position=481, value="The length of time in minutes that client secrets will be retained as secondary secrets after secret change. The default value is 0, which will disable secondary client secret retention. This value will override the Client Secret Retention Period value on the Authorization Server Settings.")
    public Integer getClientSecretRetentionPeriod() {
        return this.clientSecretRetentionPeriod;
    }

    public void setClientSecretRetentionPeriod(Integer clientSecretRetentionPeriod) {
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
    }

    @ApiModelProperty(position=490, value="The time at which the client secret was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getClientSecretChangedTime() {
        return this.clientSecretChangedTime == null ? null : new Date(this.clientSecretChangedTime.getTime());
    }

    public void setClientSecretChangedTime(Date clientSecretChangedTime) {
        this.clientSecretChangedTime = clientSecretChangedTime == null ? null : new Date(clientSecretChangedTime.getTime());
    }

    @ApiModelProperty(position=500, value="The JSON Web Signature [JWS] algorithm required to sign the Token Introspection Response.<br>HS256 - HMAC using SHA-256<br>HS384 - HMAC using SHA-384<br>HS512 - HMAC using SHA-512<br>RS256 - RSA using SHA-256<br>RS384 - RSA using SHA-384<br>RS512 - RSA using SHA-512<br>ES256 - ECDSA using P256 Curve and SHA-256<br>ES384 - ECDSA using P384 Curve and SHA-384<br>ES512 - ECDSA using P521 Curve and SHA-512<br>PS256 - RSASSA-PSS using SHA-256 and MGF1 padding with SHA-256<br>PS384 - RSASSA-PSS using SHA-384 and MGF1 padding with SHA-384<br>PS512 - RSASSA-PSS using SHA-512 and MGF1 padding with SHA-512<br>A null value will represent the default algorithm which is RS256.<br>RSASSA-PSS is only supported with Thales Luna, Entrust nShield Connect or Java 11.")
    public TokenIntrospectionSigningAlgorithm getTokenIntrospectionSigningAlgorithm() {
        return this.tokenIntrospectionSigningAlgorithm;
    }

    public void setTokenIntrospectionSigningAlgorithm(TokenIntrospectionSigningAlgorithm tokenIntrospectionSigningAlgorithm) {
        this.tokenIntrospectionSigningAlgorithm = tokenIntrospectionSigningAlgorithm;
    }

    @ApiModelProperty(position=501, value="The JSON Web Encryption [JWE] encryption algorithm used to encrypt the content-encryption key of the Token Introspection Response.<br>DIR - Direct Encryption with symmetric key<br>A128KW - AES-128 Key Wrap<br>A192KW - AES-192 Key Wrap<br>A256KW - AES-256 Key Wrap<br>A128GCMKW - AES-GCM-128 key encryption<br>A192GCMKW - AES-GCM-192 key encryption<br>A256GCMKW - AES-GCM-256 key encryption<br>ECDH_ES - ECDH-ES<br>ECDH_ES_A128KW - ECDH-ES with AES-128 Key Wrap<br>ECDH_ES_A192KW - ECDH-ES with AES-192 Key Wrap<br>ECDH_ES_A256KW - ECDH-ES with AES-256 Key Wrap<br>RSA_OAEP - RSAES OAEP<br>RSA_OAEP_256 - RSAES OAEP using SHA-256 and MGF1 with SHA-256")
    public EncryptionAlgorithm getTokenIntrospectionEncryptionAlgorithm() {
        return this.tokenIntrospectionEncryptionAlgorithm;
    }

    public void setTokenIntrospectionEncryptionAlgorithm(EncryptionAlgorithm tokenIntrospectionEncryptionAlgorithm) {
        this.tokenIntrospectionEncryptionAlgorithm = tokenIntrospectionEncryptionAlgorithm;
    }

    @ApiModelProperty(position=502, value="The JSON Web Encryption [JWE] content-encryption algorithm for the Token Introspection Response.<br>AES_128_CBC_HMAC_SHA_256 - Composite AES-CBC-128 HMAC-SHA-256<br>AES_192_CBC_HMAC_SHA_384 - Composite AES-CBC-192 HMAC-SHA-384<br>AES_256_CBC_HMAC_SHA_512 - Composite AES-CBC-256 HMAC-SHA-512<br>AES_128_GCM - AES-GCM-128<br>AES_192_GCM - AES-GCM-192<br>AES_256_GCM - AES-GCM-256")
    public ContentEncryptionAlgorithm getTokenIntrospectionContentEncryptionAlgorithm() {
        return this.tokenIntrospectionContentEncryptionAlgorithm;
    }

    public void setTokenIntrospectionContentEncryptionAlgorithm(ContentEncryptionAlgorithm tokenIntrospectionContentEncryptionAlgorithm) {
        this.tokenIntrospectionContentEncryptionAlgorithm = tokenIntrospectionContentEncryptionAlgorithm;
    }

    @ApiModelProperty(position=510, value="The JSON Web Signature [JWS] algorithm required to sign the JWT Secured Authorization Response.<br>HS256 - HMAC using SHA-256<br>HS384 - HMAC using SHA-384<br>HS512 - HMAC using SHA-512<br>RS256 - RSA using SHA-256<br>RS384 - RSA using SHA-384<br>RS512 - RSA using SHA-512<br>ES256 - ECDSA using P256 Curve and SHA-256<br>ES384 - ECDSA using P384 Curve and SHA-384<br>ES512 - ECDSA using P521 Curve and SHA-512<br>PS256 - RSASSA-PSS using SHA-256 and MGF1 padding with SHA-256<br>PS384 - RSASSA-PSS using SHA-384 and MGF1 padding with SHA-384<br>PS512 - RSASSA-PSS using SHA-512 and MGF1 padding with SHA-512<br>A null value will represent the default algorithm which is RS256.<br>RSASSA-PSS is only supported with Thales Luna, Entrust nShield Connect or Java 11.")
    public JwtSecuredAuthorizationResponseModeSigningAlgorithm getJwtSecuredAuthorizationResponseModeSigningAlgorithm() {
        return this.jwtSecuredAuthorizationResponseModeSigningAlgorithm;
    }

    public void setJwtSecuredAuthorizationResponseModeSigningAlgorithm(JwtSecuredAuthorizationResponseModeSigningAlgorithm jwtSecuredAuthorizationResponseModeSigningAlgorithm) {
        this.jwtSecuredAuthorizationResponseModeSigningAlgorithm = jwtSecuredAuthorizationResponseModeSigningAlgorithm;
    }

    @ApiModelProperty(position=511, value="The JSON Web Encryption [JWE] encryption algorithm used to encrypt the content-encryption key of the JWT Secured Authorization Response.<br>DIR - Direct Encryption with symmetric key<br>A128KW - AES-128 Key Wrap<br>A192KW - AES-192 Key Wrap<br>A256KW - AES-256 Key Wrap<br>A128GCMKW - AES-GCM-128 key encryption<br>A192GCMKW - AES-GCM-192 key encryption<br>A256GCMKW - AES-GCM-256 key encryption<br>ECDH_ES - ECDH-ES<br>ECDH_ES_A128KW - ECDH-ES with AES-128 Key Wrap<br>ECDH_ES_A192KW - ECDH-ES with AES-192 Key Wrap<br>ECDH_ES_A256KW - ECDH-ES with AES-256 Key Wrap<br>RSA_OAEP - RSAES OAEP<br>RSA_OAEP_256 - RSAES OAEP using SHA-256 and MGF1 with SHA-256")
    public EncryptionAlgorithm getJwtSecuredAuthorizationResponseModeEncryptionAlgorithm() {
        return this.jwtSecuredAuthorizationResponseModeEncryptionAlgorithm;
    }

    public void setJwtSecuredAuthorizationResponseModeEncryptionAlgorithm(EncryptionAlgorithm jwtSecuredAuthorizationResponseModeEncryptionAlgorithm) {
        this.jwtSecuredAuthorizationResponseModeEncryptionAlgorithm = jwtSecuredAuthorizationResponseModeEncryptionAlgorithm;
    }

    @ApiModelProperty(position=512, value="The JSON Web Encryption [JWE] content-encryption algorithm for the JWT Secured Authorization Response.<br>AES_128_CBC_HMAC_SHA_256 - Composite AES-CBC-128 HMAC-SHA-256<br>AES_192_CBC_HMAC_SHA_384 - Composite AES-CBC-192 HMAC-SHA-384<br>AES_256_CBC_HMAC_SHA_512 - Composite AES-CBC-256 HMAC-SHA-512<br>AES_128_GCM - AES-GCM-128<br>AES_192_GCM - AES-GCM-192<br>AES_256_GCM - AES-GCM-256")
    public ContentEncryptionAlgorithm getJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm() {
        return this.jwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm;
    }

    public void setJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm(ContentEncryptionAlgorithm jwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm) {
        this.jwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm = jwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm;
    }

    @ApiModelProperty(position=520, value="Determines whether Demonstrating Proof-of-Possession (DPoP) is required for this client.")
    public boolean getRequireDpop() {
        return this.requireDpop;
    }

    public void setRequireDpop(boolean requireDpop) {
        this.requireDpop = requireDpop;
    }

    @ApiModelProperty(position=530, value="Determines whether offline_access scope is required to issue refresh tokens by this client or not. 'SERVER_DEFAULT' is the default value. ")
    public RequireOfflineAccessScopeToIssueRefreshTokensType getRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    @ApiModelProperty(position=531, value="Determines whether offline_access requires the prompt parameter value to be set to 'consent' by this client or not. The value will be reset to default if the 'requireOfflineAccessScopeToIssueRefreshTokens' attribute is set to 'SERVER_DEFAULT' or 'false'. 'SERVER_DEFAULT' is the default value.")
    public OfflineAccessRequireConsentPromptType getOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }

    @ApiModelProperty(position=540, value="Allows an administrator to override the Max Malicious Actions configuration set globally in AccountLockingService. Defaults to SERVER_DEFAULT.")
    public LockoutMaxMaliciousActionsType getLockoutMaxMaliciousActionsType() {
        return this.lockoutMaxMaliciousActionsType;
    }

    public void setLockoutMaxMaliciousActionsType(LockoutMaxMaliciousActionsType lockoutMaxMaliciousActionsType) {
        this.lockoutMaxMaliciousActionsType = lockoutMaxMaliciousActionsType;
    }

    @ApiModelProperty(position=541, value="The number of malicious actions allowed before an OAuth client is locked out. Currently, the only operation that is tracked as a malicious action is an attempt to revoke an invalid access token or refresh token. This value will override the global MaxMaliciousActions value on the AccountLockingService in the config-store.")
    public Integer getLockoutMaxMaliciousActions() {
        return this.lockoutMaxMaliciousActions;
    }

    public void setLockoutMaxMaliciousActions(Integer lockoutMaxMaliciousActions) {
        this.lockoutMaxMaliciousActions = lockoutMaxMaliciousActions;
    }
}

