/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.oauth.ClientAuthType;
import com.pingidentity.admin.api.model.oauth.SecondarySecret;
import com.pingidentity.admin.api.model.oauth.TokenEndpointAuthSigningAlgorithm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Client Authentication.")
public class ClientAuth {
    private ClientAuthType type;
    private String secret;
    private String encryptedSecret;
    private List<SecondarySecret> secondarySecrets;
    private String clientCertIssuerDn;
    private String clientCertSubjectDn;
    private Boolean enforceReplayPrevention;
    private TokenEndpointAuthSigningAlgorithm tokenEndpointAuthSigningAlgorithm;

    public ClientAuth() {
    }

    public ClientAuth(ClientAuthType type) {
        this.type = type;
    }

    @ApiModelProperty(position=10, value="Client authentication type.<br>The required field for type SECRET is secret.<br>The required fields for type CERTIFICATE are clientCertIssuerDn and clientCertSubjectDn.<br>The required field for type PRIVATE_KEY_JWT is: either jwks or jwksUrl.")
    public ClientAuthType getType() {
        return this.type;
    }

    public void setType(ClientAuthType type) {
        this.type = type;
    }

    @ApiModelProperty(position=20, value="Client secret for Basic Authentication.  To update the client secret, specify the plaintext value in this field.  This field will not be populated for GET requests.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    @ApiModelProperty(position=25, value="For GET requests, this field contains the encrypted client secret, if one exists.  For POST and PUT requests, if you wish to reuse the existing secret, this field should be passed back unchanged.")
    public String getEncryptedSecret() {
        return this.encryptedSecret;
    }

    public void setEncryptedSecret(String secret) {
        this.encryptedSecret = secret;
    }

    @ApiModelProperty(position=26, value="The list of secondary client secrets that are temporarily retained.")
    public List<SecondarySecret> getSecondarySecrets() {
        return this.secondarySecrets;
    }

    public void setSecondarySecrets(List<SecondarySecret> secondarySecrets) {
        this.secondarySecrets = secondarySecrets;
    }

    @ApiModelProperty(position=30, value="Client TLS Certificate Issuer DN.")
    public String getClientCertIssuerDn() {
        return this.clientCertIssuerDn;
    }

    public void setClientCertIssuerDn(String clientCertIssuerDn) {
        this.clientCertIssuerDn = clientCertIssuerDn;
    }

    @ApiModelProperty(position=40, value="Client TLS Certificate Subject DN.")
    public String getClientCertSubjectDn() {
        return this.clientCertSubjectDn;
    }

    public void setClientCertSubjectDn(String clientCertSubjectDn) {
        this.clientCertSubjectDn = clientCertSubjectDn;
    }

    @ApiModelProperty(position=50, value="Enforce replay prevention on JSON Web Tokens. This field is applicable only for Private Key JWT Client and Client Secret JWT Authentication.")
    public Boolean isEnforceReplayPrevention() {
        return this.enforceReplayPrevention;
    }

    public void setEnforceReplayPrevention(Boolean enforceReplayPrevention) {
        this.enforceReplayPrevention = enforceReplayPrevention;
    }

    @ApiModelProperty(position=60, value="The JSON Web Signature [JWS] algorithm that must be used to sign the JSON Web Tokens. This field is applicable only for Private Key JWT and Client Secret JWT Client Authentication. All asymmetric signing algorithms are allowed for Private Key JWT if value is not present.All symmetric signing algorithms are allowed for Client Secret JWT if value is not present <br>RS256 - RSA using SHA-256<br>RS384 - RSA using SHA-384<br>RS512 - RSA using SHA-512<br>ES256 - ECDSA using P256 Curve and SHA-256<br>ES384 - ECDSA using P384 Curve and SHA-384<br>ES512 - ECDSA using P521 Curve and SHA-512<br>PS256 - RSASSA-PSS using SHA-256 and MGF1 padding with SHA-256<br>PS384 - RSASSA-PSS using SHA-384 and MGF1 padding with SHA-384<br>PS512 - RSASSA-PSS using SHA-512 and MGF1 padding with SHA-512<br>RSASSA-PSS is only supported with Thales Luna, Entrust nShield Connect or Java 11.<br>HS256 - HMAC using SHA-256<br>HS384 - HMAC using SHA-384<br>HS512 - HMAC using SHA-512.")
    public TokenEndpointAuthSigningAlgorithm getTokenEndpointAuthSigningAlgorithm() {
        return this.tokenEndpointAuthSigningAlgorithm;
    }

    public void setTokenEndpointAuthSigningAlgorithm(TokenEndpointAuthSigningAlgorithm tokenEndpointAuthSigningAlgorithm) {
        this.tokenEndpointAuthSigningAlgorithm = tokenEndpointAuthSigningAlgorithm;
    }
}

