/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.oauth.BaseOIDCPolicy;
import com.pingidentity.admin.api.model.oauth.ContentEncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.EncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.SigningAlgorithm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.sourceid.oauth20.domain.ClientLogoutMode;

@ApiModel(description="OAuth Client Open ID Connect Policy.")
public class ClientOIDCPolicy
extends BaseOIDCPolicy {
    private boolean grantAccessSessionRevocationApi;
    private boolean grantAccessSessionSessionManagementApi;
    private ClientLogoutMode logoutMode;
    private List<String> logoutUris;
    private String backChannelLogoutUri;
    private List<String> postLogoutRedirectUris;
    private boolean pingAccessLogoutCapable;
    private boolean pairwiseIdentifierUserType;
    private String sectorIdentifierUri;
    private SigningAlgorithm userInfoResponseSigningAlgorithm;
    private EncryptionAlgorithm userInfoResponseEncryptionAlgorithm;
    private ContentEncryptionAlgorithm userInfoResponseContentEncryptionAlgorithm;

    @ApiModelProperty(position=30, value="Determines whether this client is allowed to access the Session Revocation API.")
    public boolean isGrantAccessSessionRevocationApi() {
        return this.grantAccessSessionRevocationApi;
    }

    public void setGrantAccessSessionRevocationApi(boolean canAccess) {
        this.grantAccessSessionRevocationApi = canAccess;
    }

    @ApiModelProperty(position=40, value="Determines whether this client is allowed to access the Session Management API.")
    public boolean isGrantAccessSessionSessionManagementApi() {
        return this.grantAccessSessionSessionManagementApi;
    }

    public void setGrantAccessSessionSessionManagementApi(boolean grantAccessSessionSessionManagementApi) {
        this.grantAccessSessionSessionManagementApi = grantAccessSessionSessionManagementApi;
    }

    @ApiModelProperty(position=45, value="The logout mode for this client. The default is 'NONE'.")
    public ClientLogoutMode getLogoutMode() {
        return this.logoutMode;
    }

    public void setLogoutMode(ClientLogoutMode logoutMode) {
        this.logoutMode = logoutMode;
    }

    @ApiModelProperty(position=50, value="Set this value to true if you wish to enable client application logout, and the client is PingAccess, or its logout endpoints follow the PingAccess path convention.")
    public boolean isPingAccessLogoutCapable() {
        return this.pingAccessLogoutCapable;
    }

    public void setPingAccessLogoutCapable(boolean pingAccessLogoutCapable) {
        this.pingAccessLogoutCapable = pingAccessLogoutCapable;
    }

    @ApiModelProperty(position=60, value="A list of front-channel logout URIs for this client.")
    public List<String> getLogoutUris() {
        return this.logoutUris;
    }

    public void setLogoutUris(List<String> endpoints) {
        this.logoutUris = endpoints;
    }

    @ApiModelProperty(position=65, value="The back-channel logout URI for this client.")
    public String getBackChannelLogoutUri() {
        return this.backChannelLogoutUri;
    }

    public void setBackChannelLogoutUri(String backChannelLogoutUri) {
        this.backChannelLogoutUri = backChannelLogoutUri;
    }

    @ApiModelProperty(position=68, value="URIs to which the OIDC OP may redirect the resource owner's user agent after RP-initiated logout has completed. Wildcards are allowed. However, for security reasons, make the URL as restrictive as possible.")
    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> redirectUris) {
        this.postLogoutRedirectUris = redirectUris;
    }

    @ApiModelProperty(position=70, value="Determines whether the subject identifier type is pairwise.")
    public boolean isPairwiseIdentifierUserType() {
        return this.pairwiseIdentifierUserType;
    }

    public void setPairwiseIdentifierUserType(boolean pairwiseIdentifierUserType) {
        this.pairwiseIdentifierUserType = pairwiseIdentifierUserType;
    }

    @ApiModelProperty(position=80, value="The URI references a file with a single JSON array of Redirect URI and JWKS URL values.")
    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    @ApiModelProperty(position=90, value="The JSON Web Signature [JWS] algorithm required to sign the UserInfo response.")
    public SigningAlgorithm getUserInfoResponseSigningAlgorithm() {
        return this.userInfoResponseSigningAlgorithm;
    }

    public void setUserInfoResponseSigningAlgorithm(SigningAlgorithm userInfoResponseSigningAlgorithm) {
        this.userInfoResponseSigningAlgorithm = userInfoResponseSigningAlgorithm;
    }

    @ApiModelProperty(position=91, value="The JSON Web Encryption [JWE] encryption algorithm used to encrypt the content-encryption key of the UserInfo response.")
    public EncryptionAlgorithm getUserInfoResponseEncryptionAlgorithm() {
        return this.userInfoResponseEncryptionAlgorithm;
    }

    public void setUserInfoResponseEncryptionAlgorithm(EncryptionAlgorithm userInfoResponseEncryptionAlgorithm) {
        this.userInfoResponseEncryptionAlgorithm = userInfoResponseEncryptionAlgorithm;
    }

    @ApiModelProperty(position=92, value="The JSON Web Encryption [JWE] content-encryption algorithm for the UserInfo Response.")
    public ContentEncryptionAlgorithm getUserInfoResponseContentEncryptionAlgorithm() {
        return this.userInfoResponseContentEncryptionAlgorithm;
    }

    public void setUserInfoResponseContentEncryptionAlgorithm(ContentEncryptionAlgorithm userInfoResponseContentEncryptionAlgorithm) {
        this.userInfoResponseContentEncryptionAlgorithm = userInfoResponseContentEncryptionAlgorithm;
    }
}

