/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum ContentEncryptionAlgorithm {
    AES_128_CBC_HMAC_SHA_256("A128CBC-HS256"),
    AES_192_CBC_HMAC_SHA_384("A192CBC-HS384"),
    AES_256_CBC_HMAC_SHA_512("A256CBC-HS512"),
    AES_128_GCM("A128GCM"),
    AES_192_GCM("A192GCM"),
    AES_256_GCM("A256GCM");

    private static final Map<String, ContentEncryptionAlgorithm> ID_TO_TYPE_MAP;
    private String id;

    private ContentEncryptionAlgorithm(String encAlg) {
        this.id = encAlg;
    }

    public static Set<String> getKeys() {
        return ID_TO_TYPE_MAP.keySet();
    }

    public String getId() {
        return this.id;
    }

    public static ContentEncryptionAlgorithm getType(String id) {
        return ID_TO_TYPE_MAP.get(id);
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<String, ContentEncryptionAlgorithm>();
        for (ContentEncryptionAlgorithm alg : ContentEncryptionAlgorithm.values()) {
            ID_TO_TYPE_MAP.put(alg.getId(), alg);
        }
    }
}

