/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.ClientCertificateIssuerType;
import com.pingidentity.admin.api.model.oauth.ClientRegistrationOIDCPolicy;
import com.pingidentity.admin.api.model.oauth.DeviceFlowSettingType;
import com.pingidentity.admin.api.model.oauth.LockoutMaxMaliciousActionsType;
import com.pingidentity.admin.api.model.oauth.OfflineAccessRequireConsentPromptType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshRollingType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingGracePeriodType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalTimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalType;
import com.pingidentity.admin.api.model.oauth.RequireOfflineAccessScopeToIssueRefreshTokensType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description="Dynamic client registration settings.")
public class DynamicClientRegistration {
    private String initialAccessTokenScope;
    private boolean restrictCommonScopes;
    private List<String> restrictedCommonScopes = new ArrayList<String>();
    private List<String> allowedExclusiveScopes = new ArrayList<String>();
    private List<String> allowedAuthorizationDetailTypes = new ArrayList<String>();
    private boolean enforceReplayPrevention;
    private boolean requireSignedRequests;
    private ResourceLink defaultAccessTokenManagerRef;
    private boolean restrictToDefaultAccessTokenManager;
    private PersistentGrantLifetimeType persistentGrantExpirationType = PersistentGrantLifetimeType.SERVER_DEFAULT;
    private Long persistentGrantExpirationTime;
    private PersistentGrantLifetimeUnit persistentGrantExpirationTimeUnit;
    private PersistentGrantLifetimeType persistentGrantIdleTimeoutType = PersistentGrantLifetimeType.SERVER_DEFAULT;
    private Long persistentGrantIdleTimeout;
    private PersistentGrantLifetimeUnit persistentGrantIdleTimeoutTimeUnit;
    private ClientCertificateIssuerType clientCertIssuerType;
    private ResourceLink clientCertIssuerRef;
    private RefreshRollingType refreshRolling = RefreshRollingType.SERVER_DEFAULT;
    private RefreshTokenRollingIntervalType refreshTokenRollingIntervalType = RefreshTokenRollingIntervalType.SERVER_DEFAULT;
    private Long refreshTokenRollingInterval;
    private RefreshTokenRollingIntervalTimeUnit refreshTokenRollingIntervalTimeUnit;
    private ClientRegistrationOIDCPolicy oidcPolicy;
    private List<ResourceLink> policyRefs = new ArrayList<ResourceLink>();
    private DeviceFlowSettingType deviceFlowSettingType = DeviceFlowSettingType.SERVER_DEFAULT;
    private String userAuthorizationUrlOverride;
    private Integer pendingAuthorizationTimeoutOverride;
    private Integer devicePollingIntervalOverride;
    private Boolean bypassActivationCodeConfirmationOverride;
    private Boolean requireProofKeyForCodeExchange;
    private Boolean cibaRequireSignedRequests;
    private int cibaPollingInterval = 3;
    private ResourceLink requestPolicyRef;
    private ResourceLink TokenExchangeProcessorPolicyRef;
    private Boolean rotateRegistrationAccessToken;
    private Boolean rotateClientSecret;
    private Boolean allowClientDelete;
    private Boolean disableRegistrationAccessTokens = null;
    private RefreshTokenRollingGracePeriodType refreshTokenRollingGracePeriodType = RefreshTokenRollingGracePeriodType.SERVER_DEFAULT;
    private Integer refreshTokenRollingGracePeriod;
    private Boolean retainClientSecret;
    private String clientSecretRetentionPeriodType = "SERVER_DEFAULT";
    private Integer clientSecretRetentionPeriodOverride;
    private Boolean requireJwtSecuredAuthorizationResponseMode;
    private RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokens = RequireOfflineAccessScopeToIssueRefreshTokensType.SERVER_DEFAULT;
    private OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPrompt = OfflineAccessRequireConsentPromptType.SERVER_DEFAULT;
    private LockoutMaxMaliciousActionsType lockoutMaxMaliciousActionsType = LockoutMaxMaliciousActionsType.SERVER_DEFAULT;
    private Integer lockoutMaxMaliciousActions;

    @ApiModelProperty(position=10, value="The initial access token to prevent unwanted client registrations.")
    public String getInitialAccessTokenScope() {
        return this.initialAccessTokenScope;
    }

    public void setInitialAccessTokenScope(String initialAccessTokenScope) {
        this.initialAccessTokenScope = initialAccessTokenScope;
    }

    @ApiModelProperty(position=20, value="Restrict common scopes.")
    public boolean isRestrictCommonScopes() {
        return this.restrictCommonScopes;
    }

    public void setRestrictCommonScopes(boolean restrictCommonScopes) {
        this.restrictCommonScopes = restrictCommonScopes;
    }

    @ApiModelProperty(position=30, value="The common scopes to restrict.")
    public List<String> getRestrictedCommonScopes() {
        return this.restrictedCommonScopes;
    }

    public void setRestrictedCommonScopes(List<String> restrictedCommonScopes) {
        this.restrictedCommonScopes = restrictedCommonScopes;
    }

    @ApiModelProperty(position=40, value="The exclusive scopes to allow.")
    public List<String> getAllowedExclusiveScopes() {
        return this.allowedExclusiveScopes;
    }

    public void setAllowedExclusiveScopes(List<String> allowedExclusiveScopes) {
        this.allowedExclusiveScopes = allowedExclusiveScopes;
    }

    @ApiModelProperty(position=45, value="The authorization detail types to allow.")
    public List<String> getAllowedAuthorizationDetailTypes() {
        return this.allowedAuthorizationDetailTypes;
    }

    public void setAllowedAuthorizationDetailTypes(List<String> allowedAuthorizationDetailTypes) {
        this.allowedAuthorizationDetailTypes = allowedAuthorizationDetailTypes;
    }

    @ApiModelProperty(position=50, value="Enforce replay prevention.")
    public boolean isEnforceReplayPrevention() {
        return this.enforceReplayPrevention;
    }

    public void setEnforceReplayPrevention(boolean enforceReplayPrevention) {
        this.enforceReplayPrevention = enforceReplayPrevention;
    }

    @ApiModelProperty(position=60, value="Require signed requests.")
    public boolean isRequireSignedRequests() {
        return this.requireSignedRequests;
    }

    public void setRequireSignedRequests(boolean requireSignedRequests) {
        this.requireSignedRequests = requireSignedRequests;
    }

    @ApiModelProperty(position=70, value="The default access token manager for this client.")
    public ResourceLink getDefaultAccessTokenManagerRef() {
        return this.defaultAccessTokenManagerRef;
    }

    public void setDefaultAccessTokenManagerRef(ResourceLink defaultAccessTokenManagerRef) {
        this.defaultAccessTokenManagerRef = defaultAccessTokenManagerRef;
    }

    @ApiModelProperty(position=80, value="Determines whether the client is restricted to using only its default access token manager. The default is false.")
    public boolean isRestrictToDefaultAccessTokenManager() {
        return this.restrictToDefaultAccessTokenManager;
    }

    public void setRestrictToDefaultAccessTokenManager(boolean restrictToDefaultAccessTokenManager) {
        this.restrictToDefaultAccessTokenManager = restrictToDefaultAccessTokenManager;
    }

    @ApiModelProperty(position=90, value="Allows an administrator to override the Persistent Grant Lifetime set globally for the OAuth AS. Defaults to SERVER_DEFAULT.")
    public PersistentGrantLifetimeType getPersistentGrantExpirationType() {
        return this.persistentGrantExpirationType;
    }

    public void setPersistentGrantExpirationType(PersistentGrantLifetimeType persistentGrantExpirationType) {
        if (persistentGrantExpirationType != null) {
            this.persistentGrantExpirationType = persistentGrantExpirationType;
        }
    }

    @ApiModelProperty(position=100, value="The persistent grant expiration time.")
    public Long getPersistentGrantExpirationTime() {
        return this.persistentGrantExpirationTime;
    }

    public void setPersistentGrantExpirationTime(Long persistentGrantExpirationTime) {
        if (persistentGrantExpirationTime != null) {
            this.persistentGrantExpirationTime = persistentGrantExpirationTime;
        }
    }

    @ApiModelProperty(position=110, value="The persistent grant expiration time unit.")
    public PersistentGrantLifetimeUnit getPersistentGrantExpirationTimeUnit() {
        return this.persistentGrantExpirationTimeUnit;
    }

    public void setPersistentGrantExpirationTimeUnit(PersistentGrantLifetimeUnit persistentGrantExpirationTimeUnit) {
        this.persistentGrantExpirationTimeUnit = persistentGrantExpirationTimeUnit;
    }

    @ApiModelProperty(position=120, value="Allows an administrator to override the Persistent Grant Idle Timeout set globally for the OAuth AS. Defaults to SERVER_DEFAULT.")
    public PersistentGrantLifetimeType getPersistentGrantIdleTimeoutType() {
        return this.persistentGrantIdleTimeoutType;
    }

    public void setPersistentGrantIdleTimeoutType(PersistentGrantLifetimeType persistentGrantIdleTimeoutType) {
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
    }

    @ApiModelProperty(position=130, value="The persistent grant idle timeout.")
    public Long getPersistentGrantIdleTimeout() {
        return this.persistentGrantIdleTimeout;
    }

    public void setPersistentGrantIdleTimeout(Long persistentGrantIdleTimeout) {
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
    }

    @ApiModelProperty(position=140, value="The persistent grant idle timeout time unit.")
    public PersistentGrantLifetimeUnit getPersistentGrantIdleTimeoutTimeUnit() {
        return this.persistentGrantIdleTimeoutTimeUnit;
    }

    public void setPersistentGrantIdleTimeoutTimeUnit(PersistentGrantLifetimeUnit persistentGrantIdleTimeoutTimeUnit) {
        this.persistentGrantIdleTimeoutTimeUnit = persistentGrantIdleTimeoutTimeUnit;
    }

    @ApiModelProperty(position=150, value="Client TLS Certificate Issuer Type.")
    public ClientCertificateIssuerType getClientCertIssuerType() {
        return this.clientCertIssuerType;
    }

    public void setClientCertIssuerType(ClientCertificateIssuerType clientCertIssuerType) {
        this.clientCertIssuerType = clientCertIssuerType;
    }

    @ApiModelProperty(position=160, value="Client TLS Certificate Issuer DN.")
    public ResourceLink getClientCertIssuerRef() {
        return this.clientCertIssuerRef;
    }

    public void setClientCertIssuerRef(ResourceLink clientCertIssuer) {
        this.clientCertIssuerRef = clientCertIssuer;
    }

    @ApiModelProperty(position=170, value="Use ROLL or DONT_ROLL to override the Roll Refresh Token Values setting on the Authorization Server Settings. SERVER_DEFAULT will default to the Roll Refresh Token Values setting on the Authorization Server Setting screen. Defaults to SERVER_DEFAULT.")
    public RefreshRollingType getRefreshRolling() {
        return this.refreshRolling;
    }

    public void setRefreshRolling(RefreshRollingType refreshRolling) {
        if (refreshRolling != null) {
            this.refreshRolling = refreshRolling;
        }
    }

    @ApiModelProperty(position=180, value="Use OVERRIDE_SERVER_DEFAULT to override the Refresh Token Rolling Interval value on the Authorization Server Settings. SERVER_DEFAULT will default to the Refresh Token Rolling Interval value on the Authorization Server Setting. Defaults to SERVER_DEFAULT.")
    public RefreshTokenRollingIntervalType getRefreshTokenRollingIntervalType() {
        return this.refreshTokenRollingIntervalType;
    }

    public void setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType refreshTokenRollingIntervalType) {
        this.refreshTokenRollingIntervalType = refreshTokenRollingIntervalType;
    }

    @ApiModelProperty(position=190, value="The minimum interval to roll refresh tokens. This value will override the Refresh Token Rolling Interval Value on the Authorization Server Settings.")
    public Long getRefreshTokenRollingInterval() {
        return this.refreshTokenRollingInterval;
    }

    public void setRefreshTokenRollingInterval(Long refreshTokenRollingInterval) {
        this.refreshTokenRollingInterval = refreshTokenRollingInterval;
    }

    @ApiModelProperty(position=195, value="The refresh token rolling interval time unit. Defaults to HOURS.")
    public RefreshTokenRollingIntervalTimeUnit getRefreshTokenRollingIntervalTimeUnit() {
        return this.refreshTokenRollingIntervalTimeUnit;
    }

    public void setRefreshTokenRollingIntervalTimeUnit(RefreshTokenRollingIntervalTimeUnit refreshTokenRollingIntervalTimeUnit) {
        this.refreshTokenRollingIntervalTimeUnit = refreshTokenRollingIntervalTimeUnit;
    }

    @ApiModelProperty(position=200, value="Open ID Connect Policy settings.  This is included in the message only when OIDC is enabled.")
    public ClientRegistrationOIDCPolicy getOidcPolicy() {
        return this.oidcPolicy;
    }

    public void setOidcPolicy(ClientRegistrationOIDCPolicy oidcPolicy) {
        this.oidcPolicy = oidcPolicy;
    }

    @ApiModelProperty(position=210, value="The client registration policies.")
    public List<ResourceLink> getPolicyRefs() {
        return this.policyRefs;
    }

    public void setPolicyRefs(List<ResourceLink> policyRefs) {
        this.policyRefs = policyRefs;
    }

    @ApiModelProperty(position=220, value="Allows an administrator to override the Device Authorization Settings set globally for the OAuth AS. Defaults to SERVER_DEFAULT.")
    public DeviceFlowSettingType getDeviceFlowSettingType() {
        return this.deviceFlowSettingType;
    }

    public void setDeviceFlowSettingType(DeviceFlowSettingType deviceFlowSettingType) {
        this.deviceFlowSettingType = deviceFlowSettingType;
    }

    @ApiModelProperty(position=230, value="The URL is used as 'verification_url' and 'verification_url_complete' values in a Device Authorization request.")
    public String getUserAuthorizationUrlOverride() {
        return this.userAuthorizationUrlOverride;
    }

    public void setUserAuthorizationUrlOverride(String userAuthorizationUrlOverride) {
        this.userAuthorizationUrlOverride = userAuthorizationUrlOverride;
    }

    @ApiModelProperty(position=240, value="The 'device_code' and 'user_code' timeout, in seconds.")
    public Integer getPendingAuthorizationTimeoutOverride() {
        return this.pendingAuthorizationTimeoutOverride;
    }

    public void setPendingAuthorizationTimeoutOverride(Integer pendingAuthorizationTimeoutOverride) {
        this.pendingAuthorizationTimeoutOverride = pendingAuthorizationTimeoutOverride;
    }

    @ApiModelProperty(position=250, value="The amount of time client should wait between polling requests, in seconds.")
    public Integer getDevicePollingIntervalOverride() {
        return this.devicePollingIntervalOverride;
    }

    public void setDevicePollingIntervalOverride(Integer devicePollingIntervalOverride) {
        this.devicePollingIntervalOverride = devicePollingIntervalOverride;
    }

    @ApiModelProperty(position=260, value="Indicates if the Activation Code Confirmation page should be bypassed if 'verification_url_complete' is used by the end user to authorize a device.")
    public Boolean getBypassActivationCodeConfirmationOverride() {
        return this.bypassActivationCodeConfirmationOverride;
    }

    public void setBypassActivationCodeConfirmationOverride(Boolean bypassActivationCodeConfirmationOverride) {
        this.bypassActivationCodeConfirmationOverride = bypassActivationCodeConfirmationOverride;
    }

    @ApiModelProperty(position=270, value="Determines whether Proof Key for Code Exchange (PKCE) is required for the dynamically created client.")
    public Boolean getRequireProofKeyForCodeExchange() {
        return this.requireProofKeyForCodeExchange;
    }

    public void setRequireProofKeyForCodeExchange(Boolean requireProofKeyForCodeExchange) {
        this.requireProofKeyForCodeExchange = requireProofKeyForCodeExchange;
    }

    @ApiModelProperty(position=280, value="The minimum amount of time in seconds that the Client must wait between polling requests to the token endpoint. The default is 3 seconds.")
    public int getCibaPollingInterval() {
        return this.cibaPollingInterval;
    }

    public void setCibaPollingInterval(int cibaPollingInterval) {
        this.cibaPollingInterval = cibaPollingInterval;
    }

    @ApiModelProperty(position=290, value="Determines whether CIBA signed requests are required for this client.")
    public Boolean isCibaRequireSignedRequests() {
        return this.cibaRequireSignedRequests;
    }

    public void setCibaRequireSignedRequests(Boolean cibaRequireSignedRequests) {
        this.cibaRequireSignedRequests = cibaRequireSignedRequests;
    }

    @ApiModelProperty(position=300, value="The CIBA request policy.")
    public ResourceLink getRequestPolicyRef() {
        return this.requestPolicyRef;
    }

    public void setRequestPolicyRef(ResourceLink requestPolicyRef) {
        this.requestPolicyRef = requestPolicyRef;
    }

    @ApiModelProperty(position=310, value="The Token Exchange Processor policy.")
    public ResourceLink getTokenExchangeProcessorPolicyRef() {
        return this.TokenExchangeProcessorPolicyRef;
    }

    public void setTokenExchangeProcessorPolicyRef(ResourceLink tokenExchangeProcessorPolicyRef) {
        this.TokenExchangeProcessorPolicyRef = tokenExchangeProcessorPolicyRef;
    }

    @ApiModelProperty(position=320, value="Rotate registration access token on dynamic client management requests.")
    public Boolean getRotateClientSecret() {
        return this.rotateClientSecret;
    }

    public void setRotateClientSecret(Boolean rotateClientSecret) {
        this.rotateClientSecret = rotateClientSecret;
    }

    @ApiModelProperty(position=330, value="Rotate client secret on dynamic client management requests.")
    public Boolean getRotateRegistrationAccessToken() {
        return this.rotateRegistrationAccessToken;
    }

    public void setRotateRegistrationAccessToken(Boolean rotateRegistrationAccessToken) {
        this.rotateRegistrationAccessToken = rotateRegistrationAccessToken;
    }

    @ApiModelProperty(position=340, value="Allow client deletion from dynamic client management.")
    public Boolean getAllowClientDelete() {
        return this.allowClientDelete;
    }

    public void setAllowClientDelete(Boolean allowClientDelete) {
        this.allowClientDelete = allowClientDelete;
    }

    @ApiModelProperty(position=350, value="Disable registration access tokens. Local standards may mandate different registration access token requirements. If applicable, implement custom validation and enforcement rules using the DynamicClientRegistrationPlugin interface from the PingFederate SDK, configure the client registration policies (policyRefs), and set this property (disableRegistrationAccessTokens) to true. CAUTION: When the disableRegistrationAccessTokens property is set to true, all clients, not just the ones created using the Dynamic Client Registration protocol, are vulnerable to unrestricted retrievals, updates (including modifications to the client authentication scheme and redirect URIs), and deletes at the /as/clients.oauth2 endpoint unless one or more client registration policies are in place to protect against unauthorized attempts.")
    public Boolean getDisableRegistrationAccessTokens() {
        return this.disableRegistrationAccessTokens;
    }

    public void setDisableRegistrationAccessTokens(Boolean disableRegistrationAccessTokens) {
        this.disableRegistrationAccessTokens = disableRegistrationAccessTokens;
    }

    @ApiModelProperty(position=360, value="When specified, it overrides the global Refresh Token Grace Period defined in the Authorization Server Settings. The default value is SERVER_DEFAULT")
    public RefreshTokenRollingGracePeriodType getRefreshTokenRollingGracePeriodType() {
        return this.refreshTokenRollingGracePeriodType;
    }

    public void setRefreshTokenRollingGracePeriodType(RefreshTokenRollingGracePeriodType refreshTokenRollingGracePeriodType) {
        this.refreshTokenRollingGracePeriodType = refreshTokenRollingGracePeriodType;
    }

    @ApiModelProperty(position=361, value="The grace period that a rolled refresh token remains valid in seconds.")
    public Integer getRefreshTokenRollingGracePeriod() {
        return this.refreshTokenRollingGracePeriod;
    }

    public void setRefreshTokenRollingGracePeriod(Integer refreshTokenRollingGracePeriod) {
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
    }

    @ApiModelProperty(position=370, value="Temporarily retain the old client secret on client secret change.")
    public Boolean getRetainClientSecret() {
        return this.retainClientSecret;
    }

    public void setRetainClientSecret(Boolean retainClientSecret) {
        this.retainClientSecret = retainClientSecret;
    }

    @ApiModelProperty(position=380, value="Use OVERRIDE_SERVER_DEFAULT to override the Client Secret Retention Period value on the Authorization Server Settings. SERVER_DEFAULT will default to the Client Secret Retention Period value on the Authorization Server Setting. Defaults to SERVER_DEFAULT.")
    public String getClientSecretRetentionPeriodType() {
        return this.clientSecretRetentionPeriodType;
    }

    public void setClientSecretRetentionPeriodType(String clientSecretRetentionPeriodType) {
        this.clientSecretRetentionPeriodType = clientSecretRetentionPeriodType;
    }

    @ApiModelProperty(position=390, value="The length of time in minutes that client secrets will be retained as secondary secrets after secret change. The default value is 0, which will disable secondary client secret retention. This value will override the Client Secret Retention Period value on the Authorization Server Settings.")
    public Integer getClientSecretRetentionPeriodOverride() {
        return this.clientSecretRetentionPeriodOverride;
    }

    public void setClientSecretRetentionPeriodOverride(Integer clientSecretRetentionPeriodOverride) {
        this.clientSecretRetentionPeriodOverride = clientSecretRetentionPeriodOverride;
    }

    @ApiModelProperty(position=400, value="Determines whether JWT Secured authorization response mode is required when initiating an authorization request. The default is false.")
    public Boolean getRequireJwtSecuredAuthorizationResponseMode() {
        return this.requireJwtSecuredAuthorizationResponseMode;
    }

    public void setRequireJwtSecuredAuthorizationResponseMode(Boolean requireJwtSecuredAuthorizationResponseMode) {
        this.requireJwtSecuredAuthorizationResponseMode = requireJwtSecuredAuthorizationResponseMode;
    }

    @ApiModelProperty(position=410, value="Determines whether offline_access scope is required to issue refresh tokens or not. 'SERVER_DEFAULT' is the default value. ")
    public RequireOfflineAccessScopeToIssueRefreshTokensType getRequireOfflineAccessScopeToIssueRefreshTokens() {
        return this.requireOfflineAccessScopeToIssueRefreshTokens;
    }

    public void setRequireOfflineAccessScopeToIssueRefreshTokens(RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokens) {
        this.requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokens;
    }

    @ApiModelProperty(position=531, value="Determines whether offline_access requires the prompt parameter value to be set to 'consent' or not. The value will be reset to default if the 'requireOfflineAccessScopeToIssueRefreshTokens' attribute is set to 'SERVER_DEFAULT' or 'false'. 'SERVER_DEFAULT' is the default value.")
    public OfflineAccessRequireConsentPromptType getOfflineAccessRequireConsentPrompt() {
        return this.offlineAccessRequireConsentPrompt;
    }

    public void setOfflineAccessRequireConsentPrompt(OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPrompt) {
        this.offlineAccessRequireConsentPrompt = offlineAccessRequireConsentPrompt;
    }

    @ApiModelProperty(position=540, value="Allows an administrator to override the Max Malicious Actions configuration set globally in AccountLockingService. Defaults to SERVER_DEFAULT.")
    public LockoutMaxMaliciousActionsType getLockoutMaxMaliciousActionsType() {
        return this.lockoutMaxMaliciousActionsType;
    }

    public void setLockoutMaxMaliciousActionsType(LockoutMaxMaliciousActionsType lockoutMaxMaliciousActionsType) {
        this.lockoutMaxMaliciousActionsType = lockoutMaxMaliciousActionsType;
    }

    @ApiModelProperty(position=541, value="The number of malicious actions allowed before an OAuth client is locked out. Currently, the only operation that is tracked as a malicious action is an attempt to revoke an invalid access token or refresh token. This value will override the global MaxMaliciousActions value on the AccountLockingService in the config-store.")
    public Integer getLockoutMaxMaliciousActions() {
        return this.lockoutMaxMaliciousActions;
    }

    public void setLockoutMaxMaliciousActions(Integer lockoutMaxMaliciousActions) {
        this.lockoutMaxMaliciousActions = lockoutMaxMaliciousActions;
    }
}

