/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.oauth.OpenIdConnectAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="A set of attributes that will be returned to OAuth clients in response to requests received at the PingFederate UserInfo endpoint.")
public class OpenIdConnectAttributeContract {
    private List<OpenIdConnectAttribute> coreAttributes = new LinkedList<OpenIdConnectAttribute>();
    private List<OpenIdConnectAttribute> extendedAttributes = new LinkedList<OpenIdConnectAttribute>();

    @ApiModelProperty(position=10, value="A list of read-only attributes (for example, sub) that are automatically populated by PingFederate.")
    public List<OpenIdConnectAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    @ApiModelProperty(position=20, value="A list of additional attributes.")
    public List<OpenIdConnectAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<OpenIdConnectAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes == null ? Collections.emptyList() : extendedAttributes;
    }

    public void addCoreAttribute(OpenIdConnectAttribute coreAttribute) {
        this.coreAttributes.add(coreAttribute);
    }

    public void addExtendedAttribute(OpenIdConnectAttribute extendedAttribute) {
        this.extendedAttributes.add(extendedAttribute);
    }
}

