/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.plugin;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.plugin.AccessTokenManager;
import com.pingidentity.admin.api.model.plugin.AuthenticationSelector;
import com.pingidentity.admin.api.model.plugin.AuthorizationDetailProcessor;
import com.pingidentity.admin.api.model.plugin.ClientRegistrationPolicy;
import com.pingidentity.admin.api.model.plugin.IdpAdapter;
import com.pingidentity.admin.api.model.plugin.NotificationPublisher;
import com.pingidentity.admin.api.model.plugin.OutOfBandAuthenticator;
import com.pingidentity.admin.api.model.plugin.PasswordCredentialValidator;
import com.pingidentity.admin.api.model.plugin.PluginConfiguration;
import com.pingidentity.admin.api.model.plugin.SecretManager;
import com.pingidentity.admin.api.model.plugin.SpAdapter;
import com.pingidentity.admin.api.model.plugin.TokenGenerator;
import com.pingidentity.admin.api.model.plugin.TokenProcessor;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="A plugin instance.", subTypes={AccessTokenManager.class, AuthenticationSelector.class, AuthorizationDetailProcessor.class, ClientRegistrationPolicy.class, IdpAdapter.class, NotificationPublisher.class, OutOfBandAuthenticator.class, SecretManager.class, PasswordCredentialValidator.class, SpAdapter.class, TokenGenerator.class, TokenProcessor.class})
public class PluginInstance {
    private String id;
    private String name;
    private ResourceLink pluginDescriptorRef;
    private ResourceLink parentRef;
    private PluginConfiguration configuration;
    private Date lastModified;

    @ApiModelProperty(position=10, value="The ID of the plugin instance. The ID cannot be modified once the instance is created.<br>Note: Ignored when specifying a connection's adapter override.", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The plugin instance name. The name can be modified once the instance is created.<br>Note: Ignored when specifying a connection's adapter override.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="Reference to the plugin descriptor for this instance. The plugin descriptor cannot be modified once the instance is created.<br>Note: Ignored when specifying a connection's adapter override.", required=true)
    public ResourceLink getPluginDescriptorRef() {
        return this.pluginDescriptorRef;
    }

    public void setPluginDescriptorRef(ResourceLink pluginDescriptorRef) {
        this.pluginDescriptorRef = pluginDescriptorRef;
    }

    @ApiModelProperty(position=40, value="The reference to this plugin's parent instance. The parent reference is only accepted if the plugin type supports parent instances.<br>Note: This parent reference is required if this plugin instance is used as an overriding plugin (e.g. connection adapter overrides)")
    public ResourceLink getParentRef() {
        return this.parentRef;
    }

    public void setParentRef(ResourceLink parentRef) {
        this.parentRef = parentRef;
    }

    @ApiModelProperty(position=50, value="Plugin instance configuration.", required=true)
    public PluginConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PluginConfiguration configuration) {
        this.configuration = configuration;
    }

    @ApiModelProperty(position=60, value="The time at which the plugin instance was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

