/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.plugin;

import com.pingidentity.admin.api.model.plugin.TokenProcessorAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ApiModel(description="A set of attributes exposed by a token processor.")
public class TokenProcessorAttributeContract {
    private List<TokenProcessorAttribute> coreAttributes = new ArrayList<TokenProcessorAttribute>();
    private List<TokenProcessorAttribute> extendedAttributes;
    private boolean maskOgnlValues;
    private Boolean inherited;

    @ApiModelProperty(position=10, value="A list of token processor attributes that correspond to the attributes exposed by the token processor type.", required=true)
    public List<TokenProcessorAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(List<TokenProcessorAttribute> coreAttributes) {
        this.coreAttributes = coreAttributes == null ? Collections.emptyList() : coreAttributes;
    }

    @ApiModelProperty(position=20, value="A list of additional attributes that can be returned by the token processor. The extended attributes are only used if the token processor supports them.")
    public List<TokenProcessorAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<TokenProcessorAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    @ApiModelProperty(position=30, value="Whether or not all OGNL expressions used to fulfill an outgoing assertion contract should be masked in the logs. Defaults to false.")
    public boolean isMaskOgnlValues() {
        return this.maskOgnlValues;
    }

    public void setMaskOgnlValues(boolean maskOgnlValues) {
        this.maskOgnlValues = maskOgnlValues;
    }

    @ApiModelProperty(position=40, value="Whether this attribute contract is inherited from its parent instance. If true, the rest of the properties in this model become read-only. The default value is false.")
    public Boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(Boolean inherited) {
        this.inherited = inherited;
    }
}

