/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.sso.idp;

import com.google.common.collect.ImmutableMap;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.DataStoreRepositoryType;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.sso.idp.DataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.SqlMethod;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;

@ApiModel(description="JDBC data store user repository.")
public class JdbcDataStoreRepository
implements DataStoreRepository {
    private ResourceLink dataStoreRef;
    private SqlMethod sqlMethod;
    private Map<String, AttributeFulfillmentValue> jitRepositoryAttributeMapping = new HashMap<String, AttributeFulfillmentValue>();

    @Override
    @ApiModelProperty(position=10, value="The data store repository type.", required=true)
    public DataStoreRepositoryType getType() {
        return DataStoreRepositoryType.JDBC;
    }

    @Override
    @ApiModelProperty(position=20, value="Reference to the associated data store.", required=true)
    public ResourceLink getDataStoreRef() {
        return this.dataStoreRef;
    }

    @Override
    public void setDataStoreRef(ResourceLink dataStoreRef) {
        this.dataStoreRef = dataStoreRef;
    }

    @ApiModelProperty(position=30, value="The method to map attributes from the assertion directly to database table columns or to stored-procedure parameters.", required=true)
    public SqlMethod getSqlMethod() {
        return this.sqlMethod;
    }

    public void setSqlMethod(SqlMethod sqlMethod) {
        this.sqlMethod = sqlMethod;
    }

    @Override
    @ApiModelProperty(position=40, value="A list of user repository mappings from attribute names to their fulfillment values.", required=true)
    public Map<String, AttributeFulfillmentValue> getJitRepositoryAttributeMapping() {
        return ImmutableMap.copyOf(this.jitRepositoryAttributeMapping);
    }

    @Override
    public void setJitRepositoryAttributeMapping(Map<String, AttributeFulfillmentValue> attributeContractFulfillment) {
        this.jitRepositoryAttributeMapping = new HashMap<String, AttributeFulfillmentValue>(attributeContractFulfillment);
    }
}

