/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.systemsettings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.systemsettings.BulkheadAlertNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.CertificateExpirationNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.LicenseEventNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.MetadataEventNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.ThreadPoolExhaustionNotificationSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Settings for notifications relating to licensing and certificate expiration.")
public class NotificationSettings {
    private CertificateExpirationNotificationSettings certificateExpirations;
    private LicenseEventNotificationSettings licenseEvents;
    private boolean notifyAdminUserPasswordChanges;
    private ResourceLink accountChangesNotificationPublisherRef;
    private MetadataEventNotificationSettings metadataNotificationSettings;
    private Integer expiringCertificateAdministrativeConsoleWarningDays;
    private Integer expiredCertificateAdministrativeConsoleWarningDays;
    private ThreadPoolExhaustionNotificationSettings threadPoolExhaustionNotificationSettings;
    private BulkheadAlertNotificationSettings bulkheadAlertNotificationSettings;

    @ApiModelProperty(position=10, value="Settings for license event notifications.")
    public LicenseEventNotificationSettings getLicenseEvents() {
        return this.licenseEvents;
    }

    public void setLicenseEventSettings(LicenseEventNotificationSettings licenseEventSettings) {
        this.licenseEvents = licenseEventSettings;
    }

    @ApiModelProperty(position=20, value="Settings for certificate expiration notifications.")
    public CertificateExpirationNotificationSettings getCertificateExpirations() {
        return this.certificateExpirations;
    }

    public void setCertificateExpirations(CertificateExpirationNotificationSettings certificateExpirationSettings) {
        this.certificateExpirations = certificateExpirationSettings;
    }

    @JsonIgnore
    public boolean isNotificationDisabled() {
        return !this.notifyAdminUserPasswordChanges && this.certificateExpirations == null && this.licenseEvents == null && this.metadataNotificationSettings == null && this.threadPoolExhaustionNotificationSettings == null;
    }

    @JsonIgnore
    public boolean isAtLeastOneNotificationEnabled() {
        return this.notifyAdminUserPasswordChanges || this.certificateExpirations != null || this.licenseEvents != null || this.metadataNotificationSettings != null || this.threadPoolExhaustionNotificationSettings != null;
    }

    @ApiModelProperty(position=30, value="Determines whether admin users are notified through email when their account is changed.")
    public boolean isNotifyAdminUserPasswordChanges() {
        return this.notifyAdminUserPasswordChanges;
    }

    public void setNotifyAdminUserPasswordChanges(boolean notifyAdminUserPasswordChanges) {
        this.notifyAdminUserPasswordChanges = notifyAdminUserPasswordChanges;
    }

    @ApiModelProperty(position=40, value="Reference to the associated notification publisher for admin user account changes.")
    public ResourceLink getAccountChangesNotificationPublisherRef() {
        return this.accountChangesNotificationPublisherRef;
    }

    public void setAccountChangesNotificationPublisherRef(ResourceLink accountChangesNotificationPublisherRef) {
        this.accountChangesNotificationPublisherRef = accountChangesNotificationPublisherRef;
    }

    @ApiModelProperty(position=50, value="Settings for metadata update event notifications.")
    public MetadataEventNotificationSettings getMetadataNotificationSettings() {
        return this.metadataNotificationSettings;
    }

    public void setMetadataNotificationSettings(MetadataEventNotificationSettings metadataNotificationSettings) {
        this.metadataNotificationSettings = metadataNotificationSettings;
    }

    @ApiModelProperty(position=60, value="Indicates the number of days prior to certificate expiry date, the administrative console warning starts. The default value is 14 days.")
    public Integer getExpiringCertificateAdministrativeConsoleWarningDays() {
        return this.expiringCertificateAdministrativeConsoleWarningDays;
    }

    public void setExpiringCertificateAdministrativeConsoleWarningDays(Integer expiringCertificateAdministrativeConsoleWarningDays) {
        this.expiringCertificateAdministrativeConsoleWarningDays = expiringCertificateAdministrativeConsoleWarningDays;
    }

    @ApiModelProperty(position=70, value="Indicates the number of days past the certificate expiry date, the administrative console warning ends. The default value is 14 days.")
    public Integer getExpiredCertificateAdministrativeConsoleWarningDays() {
        return this.expiredCertificateAdministrativeConsoleWarningDays;
    }

    public void setExpiredCertificateAdministrativeConsoleWarningDays(Integer expiredCertificateAdministrativeConsoleWarningDays) {
        this.expiredCertificateAdministrativeConsoleWarningDays = expiredCertificateAdministrativeConsoleWarningDays;
    }

    @ApiModelProperty(position=80, value="Settings for thread pool exhaustion notifications")
    public ThreadPoolExhaustionNotificationSettings getThreadPoolExhaustionNotificationSettings() {
        return this.threadPoolExhaustionNotificationSettings;
    }

    public void setThreadPoolExhaustionNotificationSettings(ThreadPoolExhaustionNotificationSettings threadPoolExhaustionNotificationSettings) {
        this.threadPoolExhaustionNotificationSettings = threadPoolExhaustionNotificationSettings;
    }

    @ApiModelProperty(position=90, value="Settings for bulkhead notifications")
    public BulkheadAlertNotificationSettings getBulkheadAlertNotificationSettings() {
        return this.bulkheadAlertNotificationSettings;
    }

    public void setBulkheadAlertNotificationSettings(BulkheadAlertNotificationSettings bulkheadAlertNotificationSettings) {
        this.bulkheadAlertNotificationSettings = bulkheadAlertNotificationSettings;
    }
}

