/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.CibaRequestObjectSigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.ClientOIDCPolicy;
import com.pingidentity.admin.api.model.oauth.ClientSecretRetentionPeriodType;
import com.pingidentity.admin.api.model.oauth.Clients;
import com.pingidentity.admin.api.model.oauth.ContentEncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.DeviceFlowSettingType;
import com.pingidentity.admin.api.model.oauth.EncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.JwksSettings;
import com.pingidentity.admin.api.model.oauth.JwtSecuredAuthorizationResponseModeSigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.LockoutMaxMaliciousActionsType;
import com.pingidentity.admin.api.model.oauth.OfflineAccessRequireConsentPromptType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.model.oauth.PersistentGrantReuseType;
import com.pingidentity.admin.api.model.oauth.RefreshRollingType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingGracePeriodType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalTimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalType;
import com.pingidentity.admin.api.model.oauth.RequestObjectSigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.RequireOfflineAccessScopeToIssueRefreshTokensType;
import com.pingidentity.admin.api.model.oauth.SigningAlgorithm;
import com.pingidentity.admin.api.model.oauth.TokenIntrospectionSigningAlgorithm;
import com.pingidentity.admin.api.translator.ClientAuthTranslator;
import com.pingidentity.pf.admin.rest.translator.ExtendedPropertyValuesTranslator;
import com.pingidentity.pf.common.api.model.oauth.GrantType;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.DateUtil;
import java.sql.Date;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.ClusterSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthClientManagementTranslator {
    private static final OpenIdConnectProviderPolicyManager OIDC_POLICY_MGR = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
    private static final ClusterSettingsManager CLUSTER_SETTINGS_MANAGER = MgmtFactory.getClusterSettingsManager();
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    private ClientAuthTranslator clientAuthTranslator = new ClientAuthTranslator(this.validationErrors);
    private ExtendedPropertyValuesTranslator extendedPropertyTranslator = new ExtendedPropertyValuesTranslator();

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public Clients domainToApi(Collection<Client> domainClients) {
        ArrayList<com.pingidentity.admin.api.model.oauth.Client> apiClients = new ArrayList<com.pingidentity.admin.api.model.oauth.Client>();
        for (Client client : domainClients) {
            com.pingidentity.admin.api.model.oauth.Client apiClient = this.domainToApi(client);
            apiClients.add(apiClient);
        }
        return new Clients(apiClients);
    }

    public com.pingidentity.admin.api.model.oauth.Client domainToApi(Client domainClient) {
        String lockoutMaxMaliciousActionsType;
        LockoutMaxMaliciousActionsType apiMaliciousActionsType;
        String offlineAccessRequireConsentPrompt;
        OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPromptType;
        String tokenExchangeProcessorPolicyId;
        String href;
        com.pingidentity.admin.api.model.oauth.Client client = new com.pingidentity.admin.api.model.oauth.Client();
        client.setClientId(domainClient.getClientId());
        client.setModificationDate(DateUtil.calendarToDate((Calendar)domainClient.getLastModified()));
        client.setCreationDate(DateUtil.calendarToDate((Calendar)domainClient.getCreationTime()));
        client.setRedirectUris(domainClient.getRedirectUris());
        client.setEnabled(domainClient.isEnabled());
        if (CLUSTER_SETTINGS_MANAGER.isEnableSelectiveReplicationForClients()) {
            client.setReplicationStatus(domainClient.getReplicationStatus());
        }
        TreeSet<GrantType> apiGrantTypes = new TreeSet<GrantType>();
        for (String grantTypeId : domainClient.getGrantTypes()) {
            apiGrantTypes.add(GrantType.getType((String)grantTypeId));
        }
        client.setGrantTypes(apiGrantTypes);
        client.setName(domainClient.getName());
        client.setDescription(domainClient.getDescription());
        client.setLogoUrl(domainClient.getLogoUrl());
        RefreshRollingType apiRollingType = RefreshRollingType.getType(domainClient.getRefreshRolling());
        client.setRefreshRolling(apiRollingType);
        client.setRefreshTokenRollingInterval(domainClient.getRefreshTokenRollingInterval());
        if (domainClient.getRefreshTokenRollingInterval() != null) {
            RefreshTokenRollingIntervalTimeUnit refreshTokenRollingIntervalTimeUnit = domainClient.getRefreshTokenRollingIntervalTimeUnit() == null ? RefreshTokenRollingIntervalTimeUnit.HOURS : RefreshTokenRollingIntervalTimeUnit.getType(domainClient.getRefreshTokenRollingIntervalTimeUnit());
            client.setRefreshTokenRollingIntervalTimeUnit(refreshTokenRollingIntervalTimeUnit);
        }
        if (domainClient.getRefreshTokenRollingInterval() == null) {
            client.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.SERVER_DEFAULT);
        } else if (domainClient.getRefreshTokenRollingIntervalType() == null) {
            client.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.getType("OVERRIDE_SERVER_DEFAULT"));
        } else {
            client.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.getType(domainClient.getRefreshTokenRollingIntervalType()));
        }
        PersistentGrantLifetimeType apiPersistentType = PersistentGrantLifetimeType.getType(domainClient.getPersistentGrantExpirationType());
        client.setPersistentGrantExpirationType(apiPersistentType);
        client.setPersistentGrantExpirationTime(domainClient.getPersistentGrantExpirationTime());
        PersistentGrantLifetimeUnit apiPersistentUnit = PersistentGrantLifetimeUnit.getType(domainClient.getPersistentGrantExpirationTimeUnit());
        client.setPersistentGrantExpirationTimeUnit(apiPersistentUnit);
        client.setPersistentGrantIdleTimeoutType(PersistentGrantLifetimeType.getType(domainClient.getPersistentGrantIdleTimeoutType()));
        client.setPersistentGrantIdleTimeout(domainClient.getPersistentGrantIdleTimeout());
        client.setPersistentGrantIdleTimeoutTimeUnit(PersistentGrantLifetimeUnit.getType(domainClient.getPersistentGrantIdleTimeoutTimeUnit()));
        client.setPersistentGrantReuseType(PersistentGrantReuseType.getType(domainClient.getPersistentGrantReuseType()));
        if (domainClient.getPersistentGrantReuseGrantTypes() != null) {
            TreeSet<GrantType> grantTypesToReusePersistentGrants = new TreeSet<GrantType>();
            domainClient.getPersistentGrantReuseGrantTypes().forEach(grantType -> grantTypesToReusePersistentGrants.add(GrantType.getType((String)grantType)));
            client.setPersistentGrantReuseGrantTypes(grantTypesToReusePersistentGrants);
        } else {
            client.setPersistentGrantReuseGrantTypes(null);
        }
        client.setAllowAuthenticationApiInit(domainClient.getAllowAuthenticationApiInit());
        client.setEnableCookielessAuthenticationApi(domainClient.getEnableCookielessAuthenticationApi());
        client.setBypassApprovalPage(domainClient.isBypassApprovalPage());
        client.setRestrictScopes(domainClient.isRestrictScopes());
        client.setRestrictedScopes(new TreeSet<String>(domainClient.getRestrictedScopes()));
        client.setAllowExclusiveScopes(new TreeSet<String>(domainClient.getExclusiveScopes()));
        client.setRestrictedResponseTypes(new TreeSet<String>(domainClient.getRestrictedResponseTypes()));
        client.setAuthorizationDetailTypes(new TreeSet<String>(domainClient.getAuthorizationDetailTypes()));
        client.setClientAuth(this.clientAuthTranslator.domainToApi(domainClient));
        if (StringUtils.isNotBlank((String)domainClient.getJwksUrl()) || StringUtils.isNotBlank((String)domainClient.getJwks())) {
            JwksSettings jwksSetting = new JwksSettings();
            if (StringUtils.isNotEmpty((String)domainClient.getJwksUrl())) {
                jwksSetting.setJwksUrl(domainClient.getJwksUrl());
            } else if (StringUtils.isNotEmpty((String)domainClient.getJwks())) {
                jwksSetting.setJwks(domainClient.getJwks());
            }
            client.setJwksSettings(jwksSetting);
        }
        if (domainClient.getDefaultAccessTokenManagerId() != null) {
            ResourceLink defaultAtmRef = new ResourceLink(domainClient.getDefaultAccessTokenManagerId(), ApiUtil.getResourceUrl("/oauth/accessTokenManagers", domainClient.getDefaultAccessTokenManagerId()));
            client.setDefaultAccessTokenManagerRef(defaultAtmRef);
        }
        client.setRestrictToDefaultAccessTokenManager(domainClient.isRestrictToDefaultAccessTokenManager());
        client.setValidateUsingAllEligibleAtms(domainClient.isValidateUsingAllEligibleAtms());
        client.setRequireSignedRequests(domainClient.isRequireSignedRequests());
        client.setRequirePushedAuthorizationRequests(domainClient.isRequirePushedAuthorizationRequests());
        client.setRequireJwtSecuredAuthorizationResponseMode(domainClient.isRequireJwtSecuredAuthorizationResponseMode());
        RequestObjectSigningAlgorithm algorithm = RequestObjectSigningAlgorithm.getType(domainClient.getRequestObjectSigningAlgorithm());
        client.setRequestObjectSigningAlgorithm(algorithm);
        if (OIDC_POLICY_MGR.getPolicy().isEnabled()) {
            SigningAlgorithm algo = SigningAlgorithm.getType(domainClient.getIdTokenSigningAlgorithm());
            ClientOIDCPolicy policy = new ClientOIDCPolicy();
            policy.setIdTokenSigningAlgorithm(algo);
            EncryptionAlgorithm encryptionAlgo = EncryptionAlgorithm.getType(domainClient.getIdTokenEncryptionAlgorithm());
            if (encryptionAlgo != null) {
                policy.setIdTokenEncryptionAlgorithm(encryptionAlgo);
                ContentEncryptionAlgorithm contentEncryptionAlgo = ContentEncryptionAlgorithm.getType(domainClient.getIdTokenContentEncryptionAlgorithm());
                if (contentEncryptionAlgo != null) {
                    policy.setIdTokenContentEncryptionAlgorithm(contentEncryptionAlgo);
                }
            } else {
                policy.setIdTokenContentEncryptionAlgorithm(null);
            }
            SigningAlgorithm userInfoSigningAlgo = SigningAlgorithm.getType(domainClient.getUserInfoResponseSigningAlgorithm());
            if (userInfoSigningAlgo != null) {
                policy.setUserInfoResponseSigningAlgorithm(userInfoSigningAlgo);
                EncryptionAlgorithm userInfoEncryptionAlgo = EncryptionAlgorithm.getType(domainClient.getUserInfoResponseEncryptionAlgorithm());
                if (userInfoEncryptionAlgo != null) {
                    policy.setUserInfoResponseEncryptionAlgorithm(userInfoEncryptionAlgo);
                    ContentEncryptionAlgorithm userInfoContentEncryptionAlgo = ContentEncryptionAlgorithm.getType(domainClient.getUserInfoResponseContentEncryptionAlgorithm());
                    policy.setUserInfoResponseContentEncryptionAlgorithm(userInfoContentEncryptionAlgo);
                }
            }
            ResourceLink link = this.getPolicyResourceLink(domainClient);
            policy.setPolicyGroup(link);
            policy.setGrantAccessSessionRevocationApi(domainClient.isGrantAccessSessionRevocationApi());
            policy.setGrantAccessSessionSessionManagementApi(domainClient.isGrantAccessSessionManagementApi());
            policy.setLogoutMode(domainClient.getLogoutMode());
            policy.setPingAccessLogoutCapable(domainClient.isPingAccessLogoutCapable());
            if (domainClient.getLogoutUris() != null && !domainClient.getLogoutUris().isEmpty()) {
                policy.setLogoutUris(domainClient.getLogoutUris());
            }
            policy.setBackChannelLogoutUri(domainClient.getBackChannelLogoutUri());
            if (domainClient.getPostLogoutRedirectUris() != null && !domainClient.getPostLogoutRedirectUris().isEmpty()) {
                policy.setPostLogoutRedirectUris(domainClient.getPostLogoutRedirectUris());
            }
            policy.setPairwiseIdentifierUserType(domainClient.isPairwiseUserType());
            policy.setSectorIdentifierUri(domainClient.getSectorIdentifierUri());
            client.setOidcPolicy(policy);
        }
        this.translateDomainExtendedParams(domainClient, client);
        DeviceFlowSettingType deviceFlowSetting = DeviceFlowSettingType.getType(domainClient.getDeviceFlowSettingType());
        client.setDeviceFlowSettingType(deviceFlowSetting);
        client.setUserAuthorizationUrlOverride(domainClient.getUserAuthzUrlOverride());
        client.setPendingAuthorizationTimeoutOverride(StringUtils.isNotBlank((String)domainClient.getPendingAuthzTimeoutOverride()) ? Integer.valueOf(Integer.parseInt(domainClient.getPendingAuthzTimeoutOverride())) : null);
        client.setDevicePollingIntervalOverride(StringUtils.isNotBlank((String)domainClient.getDevicePollingIntervalOverride()) ? Integer.valueOf(Integer.parseInt(domainClient.getDevicePollingIntervalOverride())) : null);
        client.setBypassActivationCodeConfirmationOverride(domainClient.getBypassActivationCodeConfirmationOverride());
        client.setRequireProofKeyForCodeExchange(domainClient.isRequireProofKeyForCodeExchange());
        if (domainClient.getGrantTypes().contains("urn:openid:params:grant-type:ciba")) {
            client.setCibaDeliveryMode(com.pingidentity.admin.api.model.oauth.CibaDeliveryMode.getApiType(domainClient.getCibaTokenDeliveryMode()));
            client.setCibaNotificationEndpoint(domainClient.getCibaNotificationEndpoint());
            client.setCibaRequireSignedRequests(domainClient.isCibaRequireSignedRequests());
            client.setCibaUserCodeSupported(domainClient.isCibaUserCodeSupported());
            client.setCibaPollingInterval(domainClient.getCibaPollingInterval());
            CibaRequestObjectSigningAlgorithm cibaRequestObjectSigningAlgorithm = CibaRequestObjectSigningAlgorithm.getType(domainClient.getCibaRequestObjectSigningAlgorithm());
            client.setCibaRequestObjectSigningAlgorithm(cibaRequestObjectSigningAlgorithm);
            if (StringUtils.isNotBlank((String)domainClient.getCibaPolicyId())) {
                href = ApiUtil.getResourceUrl("/oauth/cibaServerPolicy", domainClient.getCibaPolicyId());
                ResourceLink cibaPolicy = new ResourceLink(domainClient.getCibaPolicyId(), href);
                client.setRequestPolicyRef(cibaPolicy);
            }
        }
        if (domainClient.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:token-exchange") && StringUtils.isNotBlank((String)(tokenExchangeProcessorPolicyId = domainClient.getTokenExchangeProcessorPolicyId()))) {
            href = ApiUtil.getResourceUrl("/oauth/tokenExchange/processor/policies", tokenExchangeProcessorPolicyId);
            client.setTokenExchangeProcessorPolicyRef(new ResourceLink(tokenExchangeProcessorPolicyId, href));
        }
        RefreshTokenRollingGracePeriodType refreshTokenRollingGracePeriodType = RefreshTokenRollingGracePeriodType.getType(domainClient.getRefreshTokenRollingGracePeriodType());
        client.setRefreshTokenRollingGracePeriodType(refreshTokenRollingGracePeriodType);
        Integer refreshTokenRollingGracePeriodInt = domainClient.getRefreshTokenRollingGracePeriod() != null ? domainClient.getRefreshTokenRollingGracePeriod() : null;
        client.setRefreshTokenRollingGracePeriod(refreshTokenRollingGracePeriodInt);
        String clientSecretRetentionPeriodType = domainClient.getSecondarySecretRetentionPeriodType() != null ? domainClient.getSecondarySecretRetentionPeriodType() : null;
        client.setClientSecretRetentionPeriodType(ClientSecretRetentionPeriodType.getType(clientSecretRetentionPeriodType));
        Integer clientSecretRetentionPeriod = domainClient.getSecondarySecretRetentionPeriod() != null ? Integer.valueOf(Integer.parseInt(domainClient.getSecondarySecretRetentionPeriod())) : null;
        client.setClientSecretRetentionPeriod(clientSecretRetentionPeriod);
        client.setClientSecretChangedTime(domainClient.getClientSecretChangedTime() == null ? null : Date.from(Instant.ofEpochSecond(Long.parseLong(domainClient.getClientSecretChangedTime()))));
        TokenIntrospectionSigningAlgorithm signAlgo = TokenIntrospectionSigningAlgorithm.getType(domainClient.getIntrospectionSigningAlgorithm());
        client.setTokenIntrospectionSigningAlgorithm(signAlgo);
        EncryptionAlgorithm encryptionAlgo = EncryptionAlgorithm.getType(domainClient.getIntrospectionEncryptionAlgorithm());
        if (encryptionAlgo != null) {
            client.setTokenIntrospectionEncryptionAlgorithm(encryptionAlgo);
            ContentEncryptionAlgorithm contentEncryptionAlgo = ContentEncryptionAlgorithm.getType(domainClient.getIntrospectionContentEncryptionAlgorithm());
            if (contentEncryptionAlgo != null) {
                client.setTokenIntrospectionContentEncryptionAlgorithm(contentEncryptionAlgo);
            }
        } else {
            client.setTokenIntrospectionEncryptionAlgorithm(null);
            client.setTokenIntrospectionContentEncryptionAlgorithm(null);
        }
        JwtSecuredAuthorizationResponseModeSigningAlgorithm jarmSigningAlgorithm = JwtSecuredAuthorizationResponseModeSigningAlgorithm.getType(domainClient.getAuthorizationResponseSigningAlgorithm());
        client.setJwtSecuredAuthorizationResponseModeSigningAlgorithm(jarmSigningAlgorithm);
        EncryptionAlgorithm jarmEncryptionAlgorithm = EncryptionAlgorithm.getType(domainClient.getAuthorizationResponseEncryptionAlgorithm());
        if (jarmEncryptionAlgorithm != null) {
            client.setJwtSecuredAuthorizationResponseModeEncryptionAlgorithm(jarmEncryptionAlgorithm);
            ContentEncryptionAlgorithm jarmContentEncryptionAlgorithm = ContentEncryptionAlgorithm.getType(domainClient.getAuthorizationResponseContentEncryptionAlgorithm());
            if (jarmContentEncryptionAlgorithm != null) {
                client.setJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm(jarmContentEncryptionAlgorithm);
            }
        } else {
            client.setJwtSecuredAuthorizationResponseModeEncryptionAlgorithm(null);
            client.setJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm(null);
        }
        client.setRequireDpop(domainClient.isRequireDpop());
        String requireOfflineAccessScopeToIssueRefreshTokens = domainClient.getRequireOfflineAccessScopeToIssueRefreshTokens();
        RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokensType = RequireOfflineAccessScopeToIssueRefreshTokensType.getType(requireOfflineAccessScopeToIssueRefreshTokens);
        if (requireOfflineAccessScopeToIssueRefreshTokensType != null) {
            client.setRequireOfflineAccessScopeToIssueRefreshTokens(requireOfflineAccessScopeToIssueRefreshTokensType);
        }
        if ((offlineAccessRequireConsentPromptType = OfflineAccessRequireConsentPromptType.getType(offlineAccessRequireConsentPrompt = domainClient.getOfflineAccessRequireConsentPrompt())) != null) {
            client.setOfflineAccessRequireConsentPrompt(offlineAccessRequireConsentPromptType);
        }
        if ((apiMaliciousActionsType = LockoutMaxMaliciousActionsType.getType(lockoutMaxMaliciousActionsType = domainClient.getLockoutMaxMaliciousActionsType())) != null) {
            client.setLockoutMaxMaliciousActionsType(apiMaliciousActionsType);
        }
        Integer lockoutMaxMaliciousActions = domainClient.getLockoutMaxMaliciousActions() != null ? domainClient.getLockoutMaxMaliciousActions() : null;
        client.setLockoutMaxMaliciousActions(lockoutMaxMaliciousActions);
        return client;
    }

    private void translateDomainExtendedParams(Client domainClient, com.pingidentity.admin.api.model.oauth.Client apiClient) {
        Map params = domainClient.getExtendedParams();
        Map<String, ParameterValues> apiParams = this.extendedPropertyTranslator.domainToApi(params);
        apiClient.setExtendedParameters(apiParams);
    }

    public void apiToDomain(com.pingidentity.admin.api.model.oauth.Client client, Client domainClient) {
        domainClient.setClientId(client.getClientId());
        domainClient.setDescription(client.getDescription());
        XmlCalendar now = new XmlCalendar(new java.util.Date());
        domainClient.setLastModified((Calendar)now);
        if (domainClient.getCreationDate() == null) {
            domainClient.setCreationTime((Calendar)now);
        }
        HashSet<String> domainGrantTypes = new HashSet<String>();
        for (GrantType apiGrantType : client.getGrantTypes()) {
            domainGrantTypes.add(apiGrantType.getId());
        }
        domainClient.setGrantTypes(domainGrantTypes);
        domainClient.setLogoUrl(client.getLogoUrl());
        domainClient.setName(client.getName());
        if (client.getOidcPolicy() != null) {
            ClientOIDCPolicy policy = client.getOidcPolicy();
            String domainAlg = policy.getIdTokenSigningAlgorithm() == null ? null : policy.getIdTokenSigningAlgorithm().getId();
            domainClient.setIdTokenSigningAlgorithm(domainAlg);
            String domainEncryptionAlg = policy.getIdTokenEncryptionAlgorithm() == null ? null : policy.getIdTokenEncryptionAlgorithm().getId();
            domainClient.setIdTokenEncryptionAlgorithm(domainEncryptionAlg);
            String domainContentEncryptionAlg = policy.getIdTokenContentEncryptionAlgorithm() == null ? null : policy.getIdTokenContentEncryptionAlgorithm().getId();
            domainClient.setIdTokenContentEncryptionAlgorithm(domainContentEncryptionAlg);
            String domainUserInfoSigningAlgorithm = policy.getUserInfoResponseSigningAlgorithm() == null ? null : policy.getUserInfoResponseSigningAlgorithm().getId();
            domainClient.setUserInfoResponseSigningAlgorithm(domainUserInfoSigningAlgorithm);
            String domainUserInfoEncryptionAlgorithm = policy.getUserInfoResponseEncryptionAlgorithm() == null ? null : policy.getUserInfoResponseEncryptionAlgorithm().getId();
            domainClient.setUserInfoResponseEncryptionAlgorithm(domainUserInfoEncryptionAlgorithm);
            String domainUserInfoContentEncryptionAlgorithm = policy.getUserInfoResponseContentEncryptionAlgorithm() == null ? null : policy.getUserInfoResponseContentEncryptionAlgorithm().getId();
            domainClient.setUserInfoResponseContentEncryptionAlgorithm(domainUserInfoContentEncryptionAlgorithm);
            String domainPolicyId = policy.getPolicyGroup() == null ? null : policy.getPolicyGroup().getId();
            domainClient.setPolicyGroupId(domainPolicyId);
            domainClient.setGrantAccessSessionRevocationApi(policy.isGrantAccessSessionRevocationApi());
            domainClient.setGrantAccessSessionManagementApi(policy.isGrantAccessSessionSessionManagementApi());
            if (policy.getLogoutMode() == null) {
                if (!policy.isPingAccessLogoutCapable() && Util.isEmpty(policy.getLogoutUris())) {
                    domainClient.setLogoutMode(ClientLogoutMode.NONE);
                } else {
                    domainClient.setLogoutMode(ClientLogoutMode.PING_FRONT_CHANNEL);
                }
            } else {
                domainClient.setLogoutMode(policy.getLogoutMode());
            }
            domainClient.setPingAccessLogoutCapable(policy.isPingAccessLogoutCapable());
            if (policy.getLogoutUris() != null) {
                domainClient.setLogoutUris(policy.getLogoutUris());
            }
            domainClient.setBackChannelLogoutUri(policy.getBackChannelLogoutUri());
            if (policy.getPostLogoutRedirectUris() != null) {
                domainClient.setPostLogoutRedirectUris(policy.getPostLogoutRedirectUris());
            }
            domainClient.setPairwiseUserType(policy.isPairwiseIdentifierUserType());
            domainClient.setSectorIdentifierUri(policy.getSectorIdentifierUri());
        }
        domainClient.setRequireSignedRequests(client.isRequireSignedRequests());
        domainClient.setRequirePushedAuthorizationRequests(client.isRequirePushedAuthorizationRequests());
        domainClient.setRequireJwtSecuredAuthorizationResponseMode(client.isRequireJwtSecuredAuthorizationResponseMode());
        String requestObjectSigningAlgorithm = client.getRequestObjectSigningAlgorithm() != null ? client.getRequestObjectSigningAlgorithm().getId() : null;
        domainClient.setRequestObjectSigningAlgorithm(requestObjectSigningAlgorithm);
        domainClient.setEnabled(client.isEnabled() == null ? true : client.isEnabled());
        String domainExpirationType = client.getPersistentGrantExpirationType() == null ? null : client.getPersistentGrantExpirationType().getId();
        domainClient.setPersistentGrantExpirationType(domainExpirationType);
        if (PersistentGrantLifetimeType.OVERRIDE_SERVER_DEFAULT.equals((Object)client.getPersistentGrantExpirationType())) {
            domainClient.setPersistentGrantExpirationTime(client.getPersistentGrantExpirationTime());
            String domainUnit = client.getPersistentGrantExpirationTimeUnit() == null ? null : client.getPersistentGrantExpirationTimeUnit().getId();
            domainClient.setPersistentGrantExpirationTimeUnit(domainUnit);
        }
        String domainIdleTimeoutSettingType = client.getPersistentGrantIdleTimeoutType() == null ? null : client.getPersistentGrantIdleTimeoutType().getId();
        domainClient.setPersistentGrantIdleTimeoutType(domainIdleTimeoutSettingType);
        if (PersistentGrantLifetimeType.OVERRIDE_SERVER_DEFAULT.equals((Object)client.getPersistentGrantIdleTimeoutType())) {
            domainClient.setPersistentGrantIdleTimeout(client.getPersistentGrantIdleTimeout());
            String domainIdleTimeoutTimeUnit = client.getPersistentGrantIdleTimeoutTimeUnit() == null ? null : client.getPersistentGrantIdleTimeoutTimeUnit().getId();
            domainClient.setPersistentGrantIdleTimeoutTimeUnit(domainIdleTimeoutTimeUnit);
        }
        String domainReuseExistingPersistentGrantType = client.getPersistentGrantReuseType() == null ? "SERVER_DEFAULT" : client.getPersistentGrantReuseType().getId();
        domainClient.setPersistentGrantReuseType(domainReuseExistingPersistentGrantType);
        if (domainClient.isOverrideReusePersistentGrantType()) {
            TreeSet grantTypesForPersistentGrantsToReuse = new TreeSet();
            if (client.getPersistentGrantReuseGrantTypes() != null) {
                client.getPersistentGrantReuseGrantTypes().forEach(grantType -> grantTypesForPersistentGrantsToReuse.add(grantType.getId()));
            }
            domainClient.setPersistentGrantReuseGrantTypes(grantTypesForPersistentGrantsToReuse);
        }
        domainClient.setRedirectUris(client.getRedirectUris());
        String domainRefreshRolling = client.getRefreshRolling() == null ? null : client.getRefreshRolling().getId();
        domainClient.setRefreshRolling(domainRefreshRolling);
        if (client.getRefreshTokenRollingInterval() == null && client.getRefreshTokenRollingIntervalType() == null) {
            domainClient.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.SERVER_DEFAULT.getId());
        } else if (client.getRefreshTokenRollingIntervalType() != null) {
            domainClient.setRefreshTokenRollingIntervalType(client.getRefreshTokenRollingIntervalType().getId());
        }
        domainClient.setRefreshTokenRollingInterval(client.getRefreshTokenRollingInterval());
        if (client.getRefreshTokenRollingInterval() != null) {
            String refreshTokenRollingIntervalTimeUnit = client.getRefreshTokenRollingIntervalTimeUnit() == null ? "h" : client.getRefreshTokenRollingIntervalTimeUnit().getId();
            domainClient.setRefreshTokenRollingIntervalTimeUnit(refreshTokenRollingIntervalTimeUnit);
        }
        domainClient.setRestrictedScopes(new ArrayList<String>(client.getRestrictedScopes()));
        domainClient.setExclusiveScopes((List)(client.getExclusiveScopes() != null ? new ArrayList<String>(client.getExclusiveScopes()) : null));
        domainClient.setAuthorizationDetailTypes((List)(client.getAuthorizationDetailTypes() != null ? new ArrayList<String>(client.getAuthorizationDetailTypes()) : null));
        domainClient.setRestrictedResponseTypes((List)(client.getRestrictedResponseTypes() != null ? new ArrayList<String>(client.getRestrictedResponseTypes()) : null));
        domainClient.setRestrictResponseTypes(client.getRestrictedResponseTypes() != null && client.getRestrictedResponseTypes().size() > 0);
        domainClient.setAllowAuthenticationApiInit(client.isAllowAuthenticationApiInit());
        domainClient.setEnableCookielessAuthenticationApi(client.isEnableCookielessAuthenticationApi());
        domainClient.setBypassApprovalPage(client.isBypassApprovalPage());
        domainClient.setRestrictScopes(client.isRestrictScopes());
        if (client.getRequestPolicyRef() != null) {
            domainClient.setCibaPolicyId(client.getRequestPolicyRef().getId());
        }
        if (client.getTokenExchangeProcessorPolicyRef() != null) {
            domainClient.setTokenExchangeProcessorPolicyId(client.getTokenExchangeProcessorPolicyRef().getId());
        }
        String clientSecretRetentionPeriodType = client.getClientSecretRetentionPeriodType() != null ? client.getClientSecretRetentionPeriodType().getId() : null;
        domainClient.setSecondarySecretRetentionPeriodType(clientSecretRetentionPeriodType);
        String retentionPeriod = client.getClientSecretRetentionPeriod() == null ? null : client.getClientSecretRetentionPeriod().toString();
        domainClient.setSecondarySecretRetentionPeriod(retentionPeriod);
        this.clientAuthTranslator.apiToDomain(client.getClientAuth(), domainClient, client.getClientId());
        this.translateApiJwtAuthnSettings(client, domainClient);
        if (client.getDefaultAccessTokenManagerRef() != null) {
            domainClient.setDefaultAccessTokenManagerId(client.getDefaultAccessTokenManagerRef().getId());
        }
        domainClient.setRestrictToDefaultAccessTokenManager(client.isRestrictToDefaultAccessTokenManager());
        domainClient.setValidateUsingAllEligibleAtms(client.isValidateUsingAllEligibleAtms());
        this.translateApiExtendedParams(client, domainClient);
        domainClient.setDeviceFlowSettingType(client.getDeviceFlowSettingType() != null ? client.getDeviceFlowSettingType().getId() : null);
        domainClient.setUserAuthzUrlOverride(client.getUserAuthorizationUrlOverride());
        domainClient.setPendingAuthzTimeoutOverride(client.getPendingAuthorizationTimeoutOverride() != null ? String.valueOf(client.getPendingAuthorizationTimeoutOverride()) : null);
        domainClient.setDevicePollingIntervalOverride(client.getDevicePollingIntervalOverride() != null ? String.valueOf(client.getDevicePollingIntervalOverride()) : null);
        domainClient.setBypassActivationCodeConfirmationOverride(client.getBypassActivationCodeConfirmationOverride());
        boolean requireProofKeyForCodeExchange = client.getRequireProofKeyForCodeExchange() != null ? client.getRequireProofKeyForCodeExchange() : false;
        domainClient.setRequireProofKeyForCodeExchange(requireProofKeyForCodeExchange);
        CibaDeliveryMode cibaDeliveryMode = null;
        boolean isCiba = domainClient.getGrantTypes().contains("urn:openid:params:grant-type:ciba");
        if (isCiba) {
            cibaDeliveryMode = client.getCibaDeliveryMode() == null ? com.pingidentity.admin.api.model.oauth.CibaDeliveryMode.POLL.getDomainType() : client.getCibaDeliveryMode().getDomainType();
        } else if (client.getCibaDeliveryMode() != null) {
            cibaDeliveryMode = client.getCibaDeliveryMode().getDomainType();
        }
        domainClient.setCibaTokenDeliveryMode(cibaDeliveryMode);
        domainClient.setCibaNotificationEndpoint(client.getCibaNotificationEndpoint());
        domainClient.setCibaPollingInterval(isCiba && client.getCibaPollingInterval() == null ? Integer.valueOf(3) : client.getCibaPollingInterval());
        domainClient.setCibaRequireSignedRequests(isCiba && client.isCibaRequireSignedRequests() == null ? Boolean.FALSE : client.isCibaRequireSignedRequests());
        domainClient.setCibaUserCodeSupported(isCiba && client.isCibaUserCodeSupported() == null ? Boolean.FALSE : client.isCibaUserCodeSupported());
        String cibaRequestObjectSigningAlgorithm = client.getCibaRequestObjectSigningAlgorithm() != null ? client.getCibaRequestObjectSigningAlgorithm().getId() : null;
        domainClient.setCibaRequestObjectSigningAlgorithm(cibaRequestObjectSigningAlgorithm);
        String refreshTokenRollingGracePeriodTypeStr = client.getRefreshTokenRollingGracePeriodType() != null ? client.getRefreshTokenRollingGracePeriodType().getId() : null;
        domainClient.setRefreshTokenRollingGracePeriodType(refreshTokenRollingGracePeriodTypeStr);
        domainClient.setRefreshTokenRollingGracePeriod(client.getRefreshTokenRollingGracePeriod());
        String domainSigningAlg = client.getTokenIntrospectionSigningAlgorithm() != null ? client.getTokenIntrospectionSigningAlgorithm().getId() : null;
        domainClient.setIntrospectionSigningAlgorithm(domainSigningAlg);
        String domainEncryptionAlg = client.getTokenIntrospectionEncryptionAlgorithm() != null ? client.getTokenIntrospectionEncryptionAlgorithm().getId() : null;
        domainClient.setIntrospectionEncryptionAlgorithm(domainEncryptionAlg);
        String domainContentEncryptionAlg = client.getTokenIntrospectionContentEncryptionAlgorithm() != null ? client.getTokenIntrospectionContentEncryptionAlgorithm().getId() : null;
        domainClient.setIntrospectionContentEncryptionAlgorithm(domainContentEncryptionAlg);
        String jarmSigningAlgorithm = client.getJwtSecuredAuthorizationResponseModeSigningAlgorithm() != null ? client.getJwtSecuredAuthorizationResponseModeSigningAlgorithm().getId() : null;
        String jarmEncryptionAlgorithm = client.getJwtSecuredAuthorizationResponseModeEncryptionAlgorithm() != null ? client.getJwtSecuredAuthorizationResponseModeEncryptionAlgorithm().getId() : null;
        String jarmContentEncryptionAlgorithm = client.getJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm() != null ? client.getJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithm().getId() : null;
        domainClient.setAuthorizationResponseSigningAlgorithm(jarmSigningAlgorithm);
        domainClient.setAuthorizationResponseEncryptionAlgorithm(jarmEncryptionAlgorithm);
        domainClient.setAuthorizationResponseContentEncryptionAlgorithm(jarmContentEncryptionAlgorithm);
        domainClient.setRequireDpop(client.getRequireDpop());
        String requireOfflineAccessScopeToIssueRefreshTokens = client.getRequireOfflineAccessScopeToIssueRefreshTokens() != null ? client.getRequireOfflineAccessScopeToIssueRefreshTokens().getValue() : RequireOfflineAccessScopeToIssueRefreshTokensType.SERVER_DEFAULT.getValue();
        domainClient.setRequireOfflineAccessScopeToIssueRefreshTokens(requireOfflineAccessScopeToIssueRefreshTokens);
        boolean requireOfflineAccessIsYes = RequireOfflineAccessScopeToIssueRefreshTokensType.YES.getValue().equals(requireOfflineAccessScopeToIssueRefreshTokens);
        if (requireOfflineAccessIsYes) {
            String offlineAccessRequireConsentPrompt = client.getOfflineAccessRequireConsentPrompt() != null ? client.getOfflineAccessRequireConsentPrompt().getValue() : OfflineAccessRequireConsentPromptType.SERVER_DEFAULT.getValue();
            domainClient.setOfflineAccessRequireConsentPrompt(offlineAccessRequireConsentPrompt);
        }
        String lockoutMaxMaliciousActionsType = client.getLockoutMaxMaliciousActionsType() != null ? client.getLockoutMaxMaliciousActionsType().getValue() : LockoutMaxMaliciousActionsType.SERVER_DEFAULT.getValue();
        domainClient.setLockoutMaxMaliciousActionsType(lockoutMaxMaliciousActionsType);
        if (!LockoutMaxMaliciousActionsType.OVERRIDE_SERVER_DEFAULT.equals((Object)client.getLockoutMaxMaliciousActionsType())) {
            domainClient.setLockoutMaxMaliciousActions(null);
        } else {
            domainClient.setLockoutMaxMaliciousActions(client.getLockoutMaxMaliciousActions());
        }
    }

    private void translateApiExtendedParams(com.pingidentity.admin.api.model.oauth.Client client, Client domainClient) {
        Map<String, ParameterValues> params = client.getExtendedParameters();
        Map<String, ParamValues> domainParams = this.extendedPropertyTranslator.apiTodomain(params);
        domainClient.setExtendedParams(domainParams);
    }

    private void translateApiJwtAuthnSettings(com.pingidentity.admin.api.model.oauth.Client client, Client domainClient) {
        JwksSettings jwksSettings = client.getJwksSettings();
        if (jwksSettings != null) {
            domainClient.setJwks(jwksSettings.getJwks());
            domainClient.setJwksUrl(jwksSettings.getJwksUrl());
        }
    }

    public ResourceLink getPolicyResourceLink(Client client) {
        if (StringUtils.isNotBlank((String)client.getPolicyGroupId())) {
            String href = ApiUtil.getResourceUrl("/oauth/openIdConnect/policies", client.getPolicyGroupId());
            ResourceLink policyGroup = new ResourceLink(client.getPolicyGroupId(), href);
            return policyGroup;
        }
        return null;
    }
}

