/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.translator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.model.oauth.SecondarySecret;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.Password;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientSecondarySecretSet;
import org.sourceid.oauth20.domain.ClientSecretRetentionHelper;
import org.sourceid.util.json.JsonUtils;

public class SecondarySecretsTranslator {
    private List<ValidationError> validationErrors = null;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public SecondarySecretsTranslator(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public void apiToDomain(List<SecondarySecret> secondarySecrets, Client domainClient) {
        if (secondarySecrets == null) {
            return;
        }
        if (secondarySecrets.isEmpty()) {
            domainClient.setSecondarySecrets(null);
            return;
        }
        domainClient.setSecondarySecrets(new ClientSecondarySecretSet());
        if (secondarySecrets.size() > ClientSecretRetentionHelper.getMaxRetainedClientSecondarySecrets()) {
            this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_secondary_secret_number_greater_than_max, ClientPaths.getSecondarySecrets(), new Object[]{ClientSecretRetentionHelper.getMaxRetainedClientSecondarySecrets()}));
        }
        for (SecondarySecret secondarySecret : secondarySecrets) {
            String encryptedSecret = secondarySecret.getEncryptedSecret();
            String secret = secondarySecret.getSecret();
            Date expiryTime = secondarySecret.getExpiryTime();
            if (expiryTime == null) {
                this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_secondary_secret_expiry_time_required, ClientPaths.getSecondarySecretsExpiryTime()));
                return;
            }
            if (StringUtils.isNotBlank((String)secret)) {
                String reversible = Obfuscator.obfuscate((String)secret);
                domainClient.addSecondarySecret(secret, reversible, expiryTime);
                continue;
            }
            if (encryptedSecret == null) continue;
            String decrypted = EncryptedFieldValidator.decryptCiphertext(encryptedSecret);
            if (decrypted == null) {
                this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_clientauth_encrypted_secret_invalid, ClientPaths.getSecondarySecretsEncryptedSecret()));
                continue;
            }
            Map<String, Object> jsonObj = this.getJsonObject(decrypted);
            if (jsonObj == null) {
                this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_clientauth_encrypted_secret_invalid, ClientPaths.getSecondarySecretsEncryptedSecret()));
                continue;
            }
            String encodedSecret = (String)jsonObj.get("encoded");
            String reversibleSecret = (String)jsonObj.get("reversible");
            if (reversibleSecret != null) {
                String plainTextSecret = Obfuscator.deobfuscate((String)reversibleSecret);
                domainClient.addSecondarySecret(plainTextSecret, reversibleSecret, expiryTime);
                continue;
            }
            if (encodedSecret != null) {
                domainClient.addEncodedSecondarySecret(encodedSecret, null, expiryTime);
                continue;
            }
            this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_clientauth_encrypted_secret_invalid, ClientPaths.getSecondarySecretsEncryptedSecret()));
        }
    }

    public List<SecondarySecret> domainToApi(Client domainClient) {
        ClientSecondarySecretSet secondarySecretSet = domainClient.getSecondarySecrets();
        ArrayList<SecondarySecret> apiSecretList = new ArrayList<SecondarySecret>();
        for (ClientSecondarySecretSet.ClientSecondarySecret secret : secondarySecretSet.getSecondarySecrets()) {
            String reversibleSecret = secret.getReversibleSecret();
            String encodedSecret = secret.getSecret();
            String payload = this.getSecondarySecretJsonPayload(reversibleSecret, encodedSecret);
            String encrypted = Password.obfuscateAndEncode((String)payload);
            SecondarySecret apiSecret = new SecondarySecret();
            apiSecret.setExpiryTime(secret.getExpiryTime());
            apiSecret.setEncryptedSecret(encrypted);
            apiSecretList.add(apiSecret);
        }
        return apiSecretList;
    }

    private String getSecondarySecretJsonPayload(String reversibleSecret, String encodedSecret) {
        try {
            HashMap<String, String> jsonObj = new HashMap<String, String>();
            if (reversibleSecret != null) {
                jsonObj.put("reversible", reversibleSecret);
            } else if (encodedSecret != null) {
                jsonObj.put("encoded", encodedSecret);
            }
            return JsonUtils.getInstance().writeValueAsString(jsonObj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> getJsonObject(String decrypted) {
        if (StringUtils.isBlank((String)decrypted)) {
            return null;
        }
        try {
            return JsonUtils.getInstance().readToMap(decrypted);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

