/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.translator.plugin;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.ConfigField;
import com.pingidentity.admin.api.model.plugin.ConfigRow;
import com.pingidentity.admin.api.model.plugin.ConfigTable;
import com.pingidentity.admin.api.model.plugin.PluginConfiguration;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.PluginConfigValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.conf.internal.ConfigOverrideMetadata;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;

public class PluginConfigTranslator {
    private final List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private boolean terminateValidation = false;
    private boolean hasInheritedConfig = false;
    private Set<String> filledInBasicFields = new HashSet<String>();
    private Set<String> filledInAdvancedFields = new HashSet<String>();
    private Set<String> filledInTables = new HashSet<String>();

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public boolean isTerminateValidation() {
        return this.terminateValidation;
    }

    public PluginConfiguration domainToApi(Configuration domainConfig, GuiConfigDescriptor guiDescriptor) {
        return this.domainToApi(domainConfig, guiDescriptor, new ConfigOverrideMetadata(true));
    }

    public PluginConfiguration domainToApi(Configuration domainConfig, GuiConfigDescriptor guiDescriptor, ConfigOverrideMetadata overrideMetadata) {
        PluginConfiguration result = new PluginConfiguration();
        ArrayList<Field> basicFields = new ArrayList<Field>();
        if (domainConfig.getFields() != null) {
            for (Field domainField : domainConfig.getFields()) {
                basicFields.add(domainField);
            }
        }
        ArrayList<Field> advancedFields = new ArrayList<Field>();
        if (domainConfig.getAdvancedFields() != null) {
            for (Field domainField : domainConfig.getAdvancedFields().getFields()) {
                advancedFields.add(domainField);
            }
        }
        result.setFields(this.domainFieldsToApi(basicFields, advancedFields, (List<FieldDescriptor>)guiDescriptor.getFields(), guiDescriptor.getAdvancedFields(), overrideMetadata));
        result.setTables(this.domainTablesToApi(domainConfig.getTables(), guiDescriptor.getTables(), overrideMetadata));
        return result;
    }

    public Configuration apiToDomain(PluginConfiguration apiConfig, GuiConfigDescriptor guiDescriptor, PluginEnum pluginEnum, boolean askedForParent) {
        this.filledInBasicFields = new HashSet<String>();
        this.filledInAdvancedFields = new HashSet<String>();
        this.filledInTables = new HashSet<String>();
        List<Field>[] domainFieldLists = this.apiFieldsToDomain(apiConfig.getFields(), guiDescriptor.getFields(), guiDescriptor.getAdvancedFields(), PluginInstancePaths.getFields(), pluginEnum, askedForParent);
        List<Field> basicFields = domainFieldLists[0];
        List<Field> advancedFields = domainFieldLists[1];
        List<Table> tables = this.apiTablesToDomain(apiConfig.getTables(), guiDescriptor.getTables(), pluginEnum, askedForParent);
        Configuration initialDomainConfig = new Configuration(basicFields, tables, advancedFields);
        if (this.terminateValidation) {
            return initialDomainConfig;
        }
        HashSet<String> originalBasicFieldDescs = new HashSet<String>();
        HashSet<String> originalAdvancedFieldDescs = new HashSet<String>();
        HashSet<String> originalTableDescs = new HashSet<String>();
        for (FieldDescriptor basicDesc : guiDescriptor.getFields()) {
            originalBasicFieldDescs.add(basicDesc.getName());
        }
        for (FieldDescriptor advancedDesc : guiDescriptor.getAdvancedFields()) {
            originalAdvancedFieldDescs.add(advancedDesc.getName());
        }
        for (TableDescriptor tableDesc : guiDescriptor.getTables()) {
            originalTableDescs.add(tableDesc.getName());
        }
        PluginConfigValidator.executePreRenderCallbacks(guiDescriptor.getPreRenderCallbackChain(), guiDescriptor.getFields(), guiDescriptor.getAdvancedFields(), guiDescriptor.getTables(), ConfigurationUtil.prepareForPlugin((Configuration)initialDomainConfig));
        this.reconcileFields(guiDescriptor.getFields(), originalBasicFieldDescs, basicFields, this.filledInBasicFields);
        this.reconcileFields(guiDescriptor.getAdvancedFields(), originalAdvancedFieldDescs, advancedFields, this.filledInAdvancedFields);
        this.reconcileTables(guiDescriptor.getTables(), originalTableDescs, tables, this.filledInTables);
        return new Configuration(basicFields, tables, advancedFields);
    }

    public List<ConfigField> domainFieldsToApi(List<Field> basicFields, List<Field> advancedFields, List<FieldDescriptor> basicDescriptors, List<FieldDescriptor> advancedDescriptors, ConfigOverrideMetadata overrideMetadata) {
        ArrayList<ConfigField> result = new ArrayList<ConfigField>();
        this.domainFieldsToApi(result, basicFields, basicDescriptors, overrideMetadata, false);
        this.domainFieldsToApi(result, advancedFields, advancedDescriptors, overrideMetadata, true);
        return result;
    }

    private void domainFieldsToApi(List<ConfigField> apiFields, List<Field> domainFields, List<FieldDescriptor> descriptors, ConfigOverrideMetadata overrideMetadata, boolean isAdvanced) {
        if (domainFields != null) {
            Map<String, FieldDescriptor> fieldDescMap = this.getFieldDescriptorMap(descriptors);
            this.fillInMissingFields(domainFields, descriptors, domainFields.stream().map(Field::getName).collect(Collectors.toSet()));
            for (Field domainField : domainFields) {
                String fieldValue = domainField.getValue();
                String encryptedValue = null;
                FieldDescriptor descriptor = fieldDescMap.get(domainField.getName());
                if (descriptor == null) continue;
                if (!StringUtils.isBlank((String)fieldValue) && (descriptor instanceof TextFieldDescriptor && ((TextFieldDescriptor)descriptor).isEncrypted() || descriptor instanceof HashedTextFieldDescriptor)) {
                    encryptedValue = EncryptedFieldValidator.encryptPlaintext(fieldValue);
                    fieldValue = null;
                }
                if (descriptor.isHidden() && StringUtils.isEmpty((String)fieldValue) && StringUtils.isEmpty(encryptedValue)) continue;
                ConfigField apiField = new ConfigField(domainField.getName(), fieldValue, encryptedValue);
                boolean isInherited = false;
                if (overrideMetadata != null) {
                    if (isAdvanced) {
                        isInherited = !overrideMetadata.isAdvancedFieldOverridden(domainField.getName());
                    } else {
                        boolean bl = isInherited = !overrideMetadata.isFieldOverridden(domainField.getName());
                    }
                }
                if (isInherited) {
                    apiField.setInherited(Boolean.TRUE);
                }
                apiFields.add(apiField);
            }
        }
    }

    public List<Field>[] apiFieldsToDomain(List<ConfigField> apiFields, List<FieldDescriptor> basicDescriptors, List<FieldDescriptor> advancedDescriptors, String fieldsPath, PluginEnum pluginEnum, boolean askedForParent) {
        return this.apiFieldsToDomain(apiFields, basicDescriptors, advancedDescriptors, fieldsPath, pluginEnum.supportsPluginHierarchies(), askedForParent, pluginEnum.getFriendlyName());
    }

    public List<Field>[] apiFieldsToDomain(List<ConfigField> apiFields, List<FieldDescriptor> basicDescriptors, List<FieldDescriptor> advancedDescriptors, String fieldsPath, boolean supportsHierarchies, boolean askedForParent, String pluginFriendlyName) {
        ArrayList<Field> basicDomainFields = new ArrayList<Field>();
        ArrayList<Field> advancedDomainFields = new ArrayList<Field>();
        HashMap<String, FieldDescriptor> descriptorMap = new HashMap<String, FieldDescriptor>();
        HashSet<String> advancedSet = new HashSet<String>();
        if (basicDescriptors != null) {
            for (FieldDescriptor basicDesc : basicDescriptors) {
                descriptorMap.put(basicDesc.getName(), basicDesc);
            }
        }
        if (advancedDescriptors != null) {
            for (FieldDescriptor advDesc : advancedDescriptors) {
                descriptorMap.put(advDesc.getName(), advDesc);
                advancedSet.add(advDesc.getName());
            }
        }
        HashSet<String> fieldNamesSeen = new HashSet<String>();
        if (apiFields != null) {
            int index = -1;
            for (ConfigField apiField : apiFields) {
                Field domainField;
                boolean doFieldValidation;
                String fieldPath = fieldsPath + "[" + ++index + "]";
                if (apiField == null) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.list_cannot_contain_empty_entries, fieldPath));
                    this.terminateValidation = true;
                    continue;
                }
                if (fieldNamesSeen.contains(apiField.getName())) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_duplicate_field, fieldPath + "." + PluginInstancePaths.FieldPaths.getName(), new Object[]{apiField.getName()}));
                    this.terminateValidation = true;
                } else {
                    fieldNamesSeen.add(apiField.getName());
                }
                boolean fieldInheritsValue = this.getBooleanVal(apiField.isInherited());
                boolean bl = doFieldValidation = !fieldInheritsValue || !supportsHierarchies || !askedForParent;
                if (fieldInheritsValue) {
                    this.hasInheritedConfig = true;
                }
                if (fieldInheritsValue && !supportsHierarchies) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_field_inherited_not_supported, fieldPath + "." + PluginInstancePaths.FieldPaths.getInherited(), new Object[]{pluginFriendlyName}));
                } else if (fieldInheritsValue && !askedForParent) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_field_parent_not_defined, fieldPath + "." + PluginInstancePaths.FieldPaths.getInherited(), new Object[]{apiField.getName()}));
                }
                if (!doFieldValidation) continue;
                String fieldValue = null;
                FieldDescriptor fieldDesc = (FieldDescriptor)descriptorMap.get(apiField.getName());
                boolean isHashedField = fieldDesc instanceof HashedTextFieldDescriptor;
                boolean decryptionSuccessful = false;
                if (apiField.getEncryptedValue() != null) {
                    fieldValue = this.decryptTextField(apiField, fieldPath);
                    decryptionSuccessful = fieldValue != null;
                } else {
                    fieldValue = apiField.getValue();
                }
                if (fieldValue == null && !isHashedField || isHashedField && fieldValue == null && apiField.getEncryptedValue() == null) {
                    fieldValue = "";
                    if (fieldDesc != null && fieldDesc instanceof CheckBoxFieldDescriptor) {
                        fieldValue = Boolean.FALSE.toString();
                    }
                }
                if (isHashedField) {
                    String hashedValue = null;
                    if (apiField.getValue() == null && apiField.getEncryptedValue() != null) {
                        hashedValue = fieldValue;
                        if (decryptionSuccessful && !this.isValidHashValue(hashedValue)) {
                            this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_field_encrypted_value_invalid, fieldPath + "." + PluginInstancePaths.FieldPaths.getEncryptedValue(), new Object[]{apiField.getName()}));
                        }
                    }
                    domainField = new HashedField(apiField.getName(), hashedValue, apiField.getValue());
                } else {
                    domainField = new Field(apiField.getName(), fieldValue);
                }
                if (advancedSet.contains(apiField.getName())) {
                    advancedDomainFields.add(domainField);
                    continue;
                }
                basicDomainFields.add(domainField);
            }
        }
        if (!askedForParent) {
            this.filledInBasicFields = this.fillInMissingFields(basicDomainFields, basicDescriptors, fieldNamesSeen);
            this.filledInAdvancedFields = this.fillInMissingFields(advancedDomainFields, advancedDescriptors, fieldNamesSeen);
        }
        return new List[]{basicDomainFields, advancedDomainFields};
    }

    private boolean isValidHashValue(String hashedValue) {
        try {
            HashedPassword.fromEncodedText((String)hashedValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Set<String> fillInMissingFields(List<Field> domainFields, List<FieldDescriptor> fieldDescriptors, Set<String> seenFields) {
        HashSet<String> filledInFields = new HashSet<String>();
        if (fieldDescriptors != null) {
            for (FieldDescriptor descriptor : fieldDescriptors) {
                if (seenFields.contains(descriptor.getName())) continue;
                filledInFields.add(descriptor.getName());
                this.fillInMissingField(domainFields, descriptor, true);
            }
        }
        return filledInFields;
    }

    private void fillInMissingField(List<Field> domainFields, FieldDescriptor descriptor, boolean useLegacyDefault) {
        String fieldValue = "";
        if (useLegacyDefault && descriptor.getDefaultForLegacyConfig() != null) {
            fieldValue = descriptor.getDefaultForLegacyConfig();
        } else if (descriptor.getDefaultValue() != null) {
            fieldValue = descriptor.getDefaultValue();
        }
        if (StringUtils.isBlank((String)fieldValue) && descriptor instanceof CheckBoxFieldDescriptor) {
            fieldValue = Boolean.FALSE.toString();
        }
        Object field = descriptor instanceof HashedTextFieldDescriptor ? new HashedField(descriptor.getName(), null, fieldValue) : new Field(descriptor.getName(), fieldValue);
        domainFields.add((Field)field);
    }

    private List<ConfigTable> domainTablesToApi(List<Table> domainTables, List<TableDescriptor> tableDescriptors, ConfigOverrideMetadata overrideMetadata) {
        ArrayList<ConfigTable> result = new ArrayList<ConfigTable>();
        if (domainTables != null) {
            for (Table table : domainTables) {
                TableDescriptor tableDescriptor = this.findTableDescriptorByName(tableDescriptors, table.getName());
                List fieldDescriptors = tableDescriptor != null ? tableDescriptor.getRowFields() : null;
                List<ConfigRow> apiRows = this.domainRowsToApi(table.getRows(), fieldDescriptors, tableDescriptor);
                ConfigTable apiTable = new ConfigTable(table.getName(), apiRows);
                if (!overrideMetadata.isTableOverridden(table.getName())) {
                    apiTable.setInherited(Boolean.TRUE);
                }
                result.add(apiTable);
            }
        }
        return result;
    }

    private List<Table> apiTablesToDomain(List<ConfigTable> apiTables, List<TableDescriptor> tableDescriptors, PluginEnum pluginEnum, boolean askedForParent) {
        HashMap<String, TableDescriptor> tableDescriptorsByName = new HashMap<String, TableDescriptor>();
        if (tableDescriptors != null) {
            for (TableDescriptor tableDesc : tableDescriptors) {
                tableDescriptorsByName.put(tableDesc.getName(), tableDesc);
            }
        }
        ArrayList<Table> result = new ArrayList<Table>();
        HashSet<String> tableNamesSeen = new HashSet<String>();
        if (apiTables != null) {
            int tableIndex = -1;
            for (ConfigTable apiTable : apiTables) {
                boolean doTableValidation;
                String tablePath = PluginInstancePaths.getTable(++tableIndex);
                if (apiTable == null) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.list_cannot_contain_empty_entries, tablePath));
                    this.terminateValidation = true;
                    continue;
                }
                if (tableNamesSeen.contains(apiTable.getName())) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_duplicate_table, PluginInstancePaths.getTableName(tableIndex), new Object[]{apiTable.getName()}));
                    this.terminateValidation = true;
                } else {
                    tableNamesSeen.add(apiTable.getName());
                }
                boolean tableInherited = this.getBooleanVal(apiTable.isInherited());
                boolean bl = doTableValidation = !tableInherited || !pluginEnum.supportsPluginHierarchies() || !askedForParent;
                if (tableInherited) {
                    this.hasInheritedConfig = true;
                }
                if (tableInherited && !pluginEnum.supportsPluginHierarchies()) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_table_inherited_not_supported, PluginInstancePaths.getTableInherited(tableIndex), new Object[]{pluginEnum.getFriendlyName()}));
                } else if (tableInherited && !askedForParent) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.plugin_table_parent_not_defined, PluginInstancePaths.getTableInherited(tableIndex), new Object[]{apiTable.getName()}));
                }
                if (!doTableValidation) continue;
                TableDescriptor tableDesc = (TableDescriptor)tableDescriptorsByName.get(apiTable.getName());
                List fieldDescriptors = tableDesc != null ? tableDesc.getRowFields() : null;
                Table domainTable = new Table(apiTable.getName(), this.apiRowsToDomain(apiTable.getRows(), fieldDescriptors, tableDesc, tableIndex));
                result.add(domainTable);
            }
        }
        this.filledInTables = this.fillInMissingTables(result, tableDescriptors, tableNamesSeen);
        return result;
    }

    private Set<String> fillInMissingTables(List<Table> tables, List<TableDescriptor> tableDescriptors, Set<String> tableNamesSeen) {
        HashSet<String> filledInTables = new HashSet<String>();
        if (tableDescriptors != null) {
            for (TableDescriptor tableDesc : tableDescriptors) {
                if (tableNamesSeen.contains(tableDesc.getName())) continue;
                filledInTables.add(tableDesc.getName());
                this.fillInMissingTable(tables, tableDesc);
            }
        }
        return filledInTables;
    }

    private void fillInMissingTable(List<Table> tables, TableDescriptor tableDesc) {
        tables.add(new Table(tableDesc.getName(), new ArrayList()));
    }

    private List<ConfigRow> domainRowsToApi(List<Row> domainRows, List<FieldDescriptor> descriptors, TableDescriptor tableDescriptor) {
        ArrayList<ConfigRow> apiRows = new ArrayList<ConfigRow>();
        if (domainRows != null) {
            for (Row domainRow : domainRows) {
                if (tableDescriptor != null && tableDescriptor.getRequireDefaultRow()) {
                    apiRows.add(new ConfigRow(this.domainFieldsToApi(domainRow.getFields(), Collections.emptyList(), descriptors, Collections.emptyList(), new ConfigOverrideMetadata(true)), domainRow.isDefaultRow()));
                    continue;
                }
                apiRows.add(new ConfigRow(this.domainFieldsToApi(domainRow.getFields(), Collections.emptyList(), descriptors, Collections.emptyList(), new ConfigOverrideMetadata(true))));
            }
        }
        return apiRows;
    }

    private List<Row> apiRowsToDomain(List<ConfigRow> apiRows, List<FieldDescriptor> descriptors, TableDescriptor tableDescriptor, int tableIndex) {
        ArrayList<Row> domainRows = new ArrayList<Row>();
        if (apiRows != null) {
            int rowIndex = -1;
            for (ConfigRow apiRow : apiRows) {
                String rowPath = PluginInstancePaths.getTableRow(tableIndex, ++rowIndex);
                if (apiRow == null) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.list_cannot_contain_empty_entries, rowPath));
                    this.terminateValidation = true;
                    continue;
                }
                if (tableDescriptor != null && tableDescriptor.getRequireDefaultRow()) {
                    domainRows.add(new Row(this.apiFieldsToDomain(apiRow.getFields(), descriptors, Collections.emptyList(), PluginInstancePaths.getTableRowFields(tableIndex, rowIndex), false, false, "table fields")[0], apiRow.isDefaultRow()));
                    continue;
                }
                domainRows.add(new Row(this.apiFieldsToDomain(apiRow.getFields(), descriptors, Collections.emptyList(), PluginInstancePaths.getTableRowFields(tableIndex, rowIndex), false, false, "table fields")[0]));
            }
        }
        return domainRows;
    }

    private TableDescriptor findTableDescriptorByName(List<TableDescriptor> descriptors, String name) {
        if (name == null || descriptors == null) {
            return null;
        }
        for (TableDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    private Map<String, FieldDescriptor> getFieldDescriptorMap(List<FieldDescriptor> descriptors) {
        if (descriptors == null || descriptors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, FieldDescriptor> fieldDescMap = new HashMap<String, FieldDescriptor>();
        for (FieldDescriptor descriptor : descriptors) {
            fieldDescMap.put(descriptor.getName(), descriptor);
        }
        return fieldDescMap;
    }

    private String decryptTextField(ConfigField apiField, String fieldPath) {
        EncryptedFieldValidator validator = new EncryptedFieldValidator(apiField.getValue(), apiField.getEncryptedValue(), ApiMessageKey.plugin_field_encrypted_value_invalid, fieldPath + "." + PluginInstancePaths.FieldPaths.getEncryptedValue(), apiField.getName());
        if (!validator.validate()) {
            this.validationErrors.addAll(validator.getErrors());
            return null;
        }
        return validator.getPlaintext();
    }

    private boolean getBooleanVal(Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    private void reconcileFields(List<FieldDescriptor> newDescriptors, Set<String> originalFieldDescNames, List<Field> configFields, Set<String> filledInFields) {
        if (newDescriptors == null) {
            newDescriptors = Collections.emptyList();
        }
        if (newDescriptors.isEmpty() && filledInFields.isEmpty()) {
            return;
        }
        HashSet<String> configFieldSet = new HashSet<String>();
        for (Field field : configFields) {
            configFieldSet.add(field.getName());
        }
        for (FieldDescriptor fieldDescriptor : newDescriptors) {
            boolean fieldAlreadyExists;
            if (originalFieldDescNames.remove(fieldDescriptor.getName()) || (fieldAlreadyExists = configFieldSet.contains(fieldDescriptor.getName()))) continue;
            this.fillInMissingField(configFields, fieldDescriptor, false);
        }
        Iterator<Field> configFieldsIt = configFields.iterator();
        while (configFieldsIt.hasNext()) {
            Field field = configFieldsIt.next();
            String fieldName = field.getName();
            if (!originalFieldDescNames.contains(fieldName) || !filledInFields.contains(fieldName)) continue;
            configFieldsIt.remove();
        }
    }

    private void reconcileTables(List<TableDescriptor> newDescriptors, Set<String> originalTableDescNames, List<Table> configTables, Set<String> filledInTables) {
        if (newDescriptors == null) {
            newDescriptors = Collections.emptyList();
        }
        if (newDescriptors.isEmpty() && filledInTables.isEmpty()) {
            return;
        }
        HashSet<String> configTableSet = new HashSet<String>();
        for (Table table : configTables) {
            configTableSet.add(table.getName());
        }
        for (TableDescriptor tableDescriptor : newDescriptors) {
            boolean tableAlreadyExists;
            if (originalTableDescNames.remove(tableDescriptor.getName()) || (tableAlreadyExists = configTableSet.contains(tableDescriptor.getName()))) continue;
            this.fillInMissingTable(configTables, tableDescriptor);
        }
        Iterator<Table> configTablesIt = configTables.iterator();
        while (configTablesIt.hasNext()) {
            Table table = configTablesIt.next();
            String tableName = table.getName();
            if (!originalTableDescNames.contains(tableName) || !filledInTables.contains(tableName)) continue;
            configTablesIt.remove();
        }
    }

    public boolean hasInheritedConfig() {
        return this.hasInheritedConfig;
    }
}

