/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.util;

import com.pingidentity.admin.api.model.ResourceCategory;
import com.pingidentity.admin.api.model.ResourceCategoryInfo;
import com.pingidentity.admin.api.model.ResourceUsage;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class ResourceUsageUtil {
    private final InUseDetectionUtil inUseDetectionUtil = InUseDetectionUtil.getInstance();
    private final DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
    public static final List<ResourceCategory> PINGONE_PLUGIN_CATEGORIES = Collections.unmodifiableList(Arrays.asList(ResourceCategory.PASSWORD_CREDENTIAL_VALIDATOR, ResourceCategory.AUTHENTICATION_SELECTOR, ResourceCategory.IDP_ADAPTER, ResourceCategory.SP_ADAPTER, ResourceCategory.TOKEN_PROCESSOR, ResourceCategory.TOKEN_GENERATOR, ResourceCategory.DATA_STORE, ResourceCategory.NOTIFICATION_PUBLISHER, ResourceCategory.RISK_PROVIDER, ResourceCategory.OOB_AUTH_PLUGIN));

    public List<ResourceCategoryInfo> getCategoryInfos() {
        return Arrays.stream(ResourceCategory.values()).sorted(Comparator.comparing(ResourceCategory::getCategoryName)).map(ResourceCategoryInfo::new).collect(Collectors.toList());
    }

    public List<ResourceUsage> findResourceUsages(PingOneConnection connection) {
        ArrayList<ResourceUsage> result = new ArrayList<ResourceUsage>();
        InUseDetectionUtil.FieldReferenceChecker checker = new InUseDetectionUtil.FieldReferenceChecker(PingOneEnvironmentFieldDescriptor.class, (descriptor, fieldValue) -> connection.getId().equals(PingOneEnvironmentFieldDescriptor.getConnectionId((String)fieldValue)));
        result.addAll(this.findPluginUsages(checker));
        result.addAll(this.findSpConnectionUsages((InUseDetectionUtil.FieldReferenceChecker<PingOneEnvironmentFieldDescriptor>)checker));
        result.addAll(this.findGatewayUsages(connection));
        return result;
    }

    private List<ResourceUsage> findPluginUsages(InUseDetectionUtil.FieldReferenceChecker<?> checker) {
        ArrayList<ResourceUsage> result = new ArrayList<ResourceUsage>();
        for (ResourceCategory category : PINGONE_PLUGIN_CATEGORIES) {
            result.addAll(this.findPluginUsages(category, checker));
        }
        return result;
    }

    private Collection<? extends ConfigurablePluginInstance> getPluginInstances(ResourceCategory category) {
        PluginManager<? extends PluginDescriptor, ? extends ConfigurablePluginInstance> manager = this.getPluginManager(category);
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.getInstances();
    }

    public PluginManager<? extends PluginDescriptor, ? extends ConfigurablePluginInstance> getPluginManager(ResourceCategory category) {
        switch (category) {
            case ACCESS_TOKEN_MGMT_PLUGIN: {
                return MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
            }
            case PASSWORD_CREDENTIAL_VALIDATOR: {
                return MgmtFactory.getCredentialValidatorManager();
            }
            case NOTIFICATION_PUBLISHER: {
                return MgmtFactory.getNotificationPublisherPluginManager();
            }
            case DATA_STORE: {
                return MgmtFactory.getCustomDataSourceManager();
            }
            case TOKEN_GENERATOR: {
                return MgmtFactory.getTokenGeneratorManager();
            }
            case TOKEN_PROCESSOR: {
                return MgmtFactory.getTokenProcessorManager();
            }
            case IDP_ADAPTER: {
                return MgmtFactory.getIdpAdapterManager();
            }
            case SP_ADAPTER: {
                return MgmtFactory.getSpAdapterManager();
            }
            case OOB_AUTH_PLUGIN: {
                return MgmtFactory.getOOBAuthPluginManager();
            }
            case AUTHENTICATION_SELECTOR: {
                return MgmtFactory.getAuthnSelectorManager();
            }
            case IDENTITY_STORE_PROVISIONER: {
                return MgmtFactory.getIdentityStoreProvisionerManager();
            }
            case DYNAMIC_CLIENT_REGISTRATION_PLUGIN: {
                return MgmtFactory.getOAuthDynamicClientRegistrationPluginManager();
            }
            case RISK_PROVIDER: {
                return MgmtFactory.getCaptchaProviderPluginManager();
            }
        }
        return null;
    }

    private List<ResourceUsage> findSpConnectionUsages(InUseDetectionUtil.FieldReferenceChecker<PingOneEnvironmentFieldDescriptor> checker) {
        ArrayList<ResourceUsage> usages = new ArrayList<ResourceUsage>();
        for (ProvisionerConfig provisionerConfig : ProvisionerManager.getProvisionerConfigs()) {
            SaasTarget saasTarget = provisionerConfig.getTarget();
            SaasProvisionerPlugin provisionerPlugin = SaasPluginManager.getInstance().getPluginInstance(saasTarget.getPluginId());
            if (provisionerPlugin == null || !this.inUseDetectionUtil.isResourceInUseByPluginFields(provisionerPlugin.getParameterDescriptors(), (FieldList)saasTarget.getParameterValues(), checker)) continue;
            SpConnection spConnection = MgmtFactory.getConnectionManager().getSpConnection(provisionerConfig.getEntityId());
            ResourceUsage usage = new ResourceUsage(spConnection.getEntityId(), spConnection.getName(), ResourceCategory.SP_CONNECTION);
            usage.setSystemId(spConnection.getId());
            usages.add(usage);
        }
        return usages;
    }

    private List<ResourceUsage> findPluginUsages(ResourceCategory category, InUseDetectionUtil.FieldReferenceChecker<?> checker) {
        ArrayList<ResourceUsage> result = new ArrayList<ResourceUsage>();
        Collection<? extends ConfigurablePluginInstance> instances = this.getPluginInstances(category);
        List referencingInstances = this.inUseDetectionUtil.getPluginInstancesUsingResource(instances, checker);
        for (ConfigurablePluginInstance instance : referencingInstances) {
            String type;
            String name;
            if (instance instanceof CustomDataSource) {
                CustomDataSource customDataSource = (CustomDataSource)instance;
                name = customDataSource.getDescription();
                if (customDataSource.getDriver() == null) {
                    MgmtFactory.getDataSourceManager().loadCustomDataSourceDriver(customDataSource);
                }
                type = customDataSource.getDriver().getSourceDescriptor().getType();
            } else {
                name = instance.getName();
                type = instance.getDescriptor().getType();
            }
            result.add(new ResourceUsage(instance.getId(), name, category, type));
        }
        return result;
    }

    private Collection<? extends ResourceUsage> findGatewayUsages(PingOneConnection connection) {
        return this.dataSourceManager.getLdapDataSources().stream().filter(ds -> ds.isGatewayEnabled() && connection.getId().equals(ds.getPingOneConnection())).map(ds -> new ResourceUsage(ds.getId(), ds.getDsName(), ResourceCategory.DATA_STORE, "PingOne LDAP Gateway")).collect(Collectors.toList());
    }
}

